/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.types.JSContext;

public enum JSTypeContext {
    STATIC,
    INSTANCE,
    PROTOTYPE,
    UNKNOWN;


    public static JSTypeContext fromJSContext(JSContext jsContext) {
        return JSTypeContext.fromJSContext(jsContext, false);
    }

    public static JSTypeContext fromJSContext(JSContext jsContext, boolean isDeclaration) {
        return switch (jsContext) {
            default -> throw new IncompatibleClassChangeError();
            case JSContext.STATIC -> STATIC;
            case JSContext.INSTANCE -> {
                if (isDeclaration) {
                    yield PROTOTYPE;
                }
                yield INSTANCE;
            }
            case JSContext.UNKNOWN -> UNKNOWN;
        };
    }

    public JSContext toJSContext() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case STATIC -> JSContext.STATIC;
            case INSTANCE, PROTOTYPE -> JSContext.INSTANCE;
            case UNKNOWN -> JSContext.UNKNOWN;
        };
    }
}

