/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.ide.IconProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JSXFileType;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileIconProvider
extends IconProvider {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        VirtualFile virtualFile;
        PsiFile psiFile;
        if (element == null) {
            JSFileIconProvider.$$$reportNull$$$0(0);
        }
        if ((psiFile = (PsiFile)ObjectUtils.tryCast((Object)element, PsiFile.class)) == null) {
            return null;
        }
        FileType type2 = psiFile.getFileType();
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
        Object object = virtualFile = type2 == JavaScriptFileType.INSTANCE || jsFile != null ? psiFile.getVirtualFile() : null;
        if (virtualFile == null) {
            return null;
        }
        if (type2 == JavaScriptFileType.INSTANCE && JSMinifiedFileUtil.isFileContentMinified(virtualFile)) {
            return JavaScriptLanguageIcons.Library.JsCompact;
        }
        if (jsFile != null && ProjectFileIndex.getInstance((Project)psiFile.getProject()).isInContent(virtualFile) && jsFile.isTestFile()) {
            return JSFileIconProvider.getTestFileIcon(type2);
        }
        return null;
    }

    @Nullable
    private static Icon getTestFileIcon(@NotNull FileType type2) {
        if (type2 == null) {
            JSFileIconProvider.$$$reportNull$$$0(1);
        }
        if (type2 == TypeScriptFileType.INSTANCE) {
            return JavaScriptLanguageIcons.FileTypes.TypeScriptTest;
        }
        if (type2 == TypeScriptJSXFileType.INSTANCE) {
            return JavaScriptLanguageIcons.FileTypes.TsxTest;
        }
        if (type2 == JSXFileType.INSTANCE) {
            return JavaScriptLanguageIcons.FileTypes.Jsx_test_file;
        }
        if (DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type2)) {
            return JavaScriptLanguageIcons.FileTypes.JsTestFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ui/JSFileIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestFileIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

