/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolderKt;
import com.intellij.lang.typescript.compiler.VirtualFileAndTypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptServiceHolder;", "", "<init>", "()V", "getAllForProject", "", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "project", "Lcom/intellij/openapi/project/Project;", "getCompilerServicesForProject", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService;", "getCreatedForProject", "hasAnyCreatedServices", "", "getCompilerServiceForProject", "getForElement", "Lcom/intellij/lang/typescript/compiler/VirtualFileAndTypeScriptService;", "element", "Lcom/intellij/psi/PsiElement;", "location", "getForFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCompilerServiceForFile", "intellij.javascript.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nTypeScriptServiceHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServiceHolder.kt\ncom/intellij/lang/typescript/compiler/TypeScriptServiceHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TypeScriptServiceHolder.kt\ncom/intellij/lang/typescript/compiler/TypeScriptServiceHolderKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n808#2,11:129\n808#2,11:140\n774#2:151\n865#2,2:152\n1755#2,3:154\n98#3,2:157\n100#3,4:160\n98#3,2:165\n100#3,4:168\n98#3,2:172\n100#3,4:175\n98#3,2:179\n100#3,4:182\n15#4:159\n15#4:167\n15#4:174\n15#4:181\n1#5:164\n*S KotlinDebug\n*F\n+ 1 TypeScriptServiceHolder.kt\ncom/intellij/lang/typescript/compiler/TypeScriptServiceHolder\n*L\n20#1:129,11\n27#1:140,11\n31#1:151\n31#1:152,2\n36#1:154,3\n69#1:157,2\n69#1:160,4\n80#1:165,2\n80#1:168,4\n88#1:172,2\n88#1:175,4\n93#1:179,2\n93#1:182,4\n69#1:159\n80#1:167\n88#1:174\n93#1:181\n*E\n"})
public final class TypeScriptServiceHolder {
    @NotNull
    public static final TypeScriptServiceHolder INSTANCE = new TypeScriptServiceHolder();

    private TypeScriptServiceHolder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeScriptService> getAllForProject(@NotNull Project project) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$filterIsInstance$iv = JSLanguageServiceProvider.Companion.getLanguageServices(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TypeScriptService)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public static final List<TypeScriptCompilerService> getCompilerServicesForProject(@NotNull Project project) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$filterIsInstance$iv = INSTANCE.getAllForProject(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TypeScriptCompilerService)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeScriptService> getCreatedForProject(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$filter$iv = this.getAllForProject(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TypeScriptService it = (TypeScriptService)element$iv$iv;
            boolean bl = false;
            if (!it.isServiceCreated()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    public static final boolean hasAnyCreatedServices(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$any$iv = INSTANCE.getAllForProject(project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeScriptService it = (TypeScriptService)element$iv;
                    boolean bl2 = false;
                    if (!it.isServiceCreated()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Deprecated(message="don't request TypeScriptCompilerService directly, it doesn't behave cleanly for frameworks")
    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final TypeScriptCompilerService getCompilerServiceForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getService(TypeScriptServerServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        return (TypeScriptCompilerService)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final VirtualFileAndTypeScriptService getForElement(@Nullable PsiElement element, @Nullable PsiElement location) {
        TypeScriptService typeScriptService;
        if (element == null) {
            return null;
        }
        if (location == null || Intrinsics.areEqual((Object)location.getContainingFile(), (Object)element.getContainingFile())) {
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            Pair pair = TypeScriptServiceHolderKt.access$getServiceAwareVirtualFile((PsiElement)psiFile2);
            if (pair == null) {
                return null;
            }
            Pair pair2 = pair;
            VirtualFile virtualFile = (VirtualFile)pair2.component1();
            boolean wasInjected = (Boolean)pair2.component2();
            Project project = psiFile2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project$iv = project;
            boolean $i$f$getForFileImpl = false;
            if (virtualFile instanceof VirtualFileWindow) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TypeScriptServiceHolder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("VirtualFileWindow is not expected here, injected files need to be handled explicitly");
                return null;
            }
            if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(virtualFile)) {
                return null;
            }
            TypeScriptService typeScriptService2 = (TypeScriptService)ReadAction.compute((ThrowableComputable)new ThrowableComputable(project$iv, virtualFile){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;
                {
                    this.$project = $project;
                    this.$file = $file;
                }

                public final T compute() {
                    Object v0;
                    block1: {
                        Iterable iterable = TypeScriptServiceHolder.INSTANCE.getAllForProject(this.$project);
                        VirtualFile virtualFile = this.$file;
                        for (T t : iterable) {
                            TypeScriptService it = (TypeScriptService)t;
                            boolean bl = false;
                            if (!(it instanceof TypeScriptService && it.isServiceForFile(virtualFile) && it.ensureServiceAvailable())) continue;
                            v0 = t;
                            break block1;
                        }
                        v0 = null;
                    }
                    return (T)((TypeScriptService)v0);
                }
            });
            TypeScriptService typeScriptService3 = typeScriptService2;
            if (typeScriptService3 == null) return null;
            TypeScriptService it = $i$f$getForFileImpl = typeScriptService3;
            boolean bl = false;
            if (wasInjected) {
                if (!it.supportsInjectedFile(psiFile2)) return null;
            }
            boolean bl2 = true;
            if (!bl2) return null;
            TypeScriptService typeScriptService4 = $i$f$getForFileImpl;
            TypeScriptService typeScriptService5 = typeScriptService4;
            if (typeScriptService5 == null) return null;
            it = typeScriptService5;
            boolean bl3 = false;
            VirtualFileAndTypeScriptService virtualFileAndTypeScriptService = new VirtualFileAndTypeScriptService(virtualFile, it);
            return virtualFileAndTypeScriptService;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile;
        PsiFile psiFile4 = location.getContainingFile();
        if (psiFile4 == null) {
            return null;
        }
        PsiFile locationPsiFile = psiFile4;
        Pair pair = TypeScriptServiceHolderKt.access$getServiceAwareVirtualFile(element);
        if (pair == null) {
            return null;
        }
        Pair pair3 = pair;
        VirtualFile virtualFile = (VirtualFile)pair3.component1();
        boolean wasInjected = (Boolean)pair3.component2();
        Pair pair4 = TypeScriptServiceHolderKt.access$getServiceAwareVirtualFile(location);
        if (pair4 == null) {
            return null;
        }
        Pair pair5 = pair4;
        VirtualFile locationFile = (VirtualFile)pair5.component1();
        boolean locationWasInjected = (Boolean)pair5.component2();
        Project project = psiFile3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project$iv = project;
        boolean $i$f$getForFileImpl = false;
        if (locationFile instanceof VirtualFileWindow) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TypeScriptServiceHolder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("VirtualFileWindow is not expected here, injected files need to be handled explicitly");
            return null;
        }
        if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(locationFile)) {
            return null;
        }
        TypeScriptService typeScriptService6 = (TypeScriptService)ReadAction.compute((ThrowableComputable)new ThrowableComputable(project$iv, locationFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            {
                this.$project = $project;
                this.$file = $file;
            }

            public final T compute() {
                Object v0;
                block1: {
                    Iterable iterable = TypeScriptServiceHolder.INSTANCE.getAllForProject(this.$project);
                    VirtualFile virtualFile = this.$file;
                    for (T t : iterable) {
                        TypeScriptService it = (TypeScriptService)t;
                        boolean bl = false;
                        if (!(it instanceof TypeScriptService && it.isServiceForFile(virtualFile) && it.ensureServiceAvailable())) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return (T)((TypeScriptService)v0);
            }
        });
        TypeScriptService typeScriptService7 = typeScriptService6;
        if (typeScriptService7 == null) return null;
        TypeScriptService it = typeScriptService = typeScriptService7;
        boolean bl = false;
        if (wasInjected) {
            if (!it.supportsInjectedFile(psiFile3)) return null;
        }
        if (locationWasInjected) {
            if (!it.supportsInjectedFile(locationPsiFile)) return null;
        }
        boolean bl4 = true;
        if (!bl4) return null;
        TypeScriptService typeScriptService8 = typeScriptService;
        TypeScriptService typeScriptService9 = typeScriptService8;
        if (typeScriptService9 == null) return null;
        it = typeScriptService9;
        boolean bl5 = false;
        VirtualFileAndTypeScriptService virtualFileAndTypeScriptService = new VirtualFileAndTypeScriptService(virtualFile, it);
        return virtualFileAndTypeScriptService;
    }

    public static /* synthetic */ VirtualFileAndTypeScriptService getForElement$default(PsiElement psiElement, PsiElement psiElement2, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement2 = null;
        }
        return TypeScriptServiceHolder.getForElement(psiElement, psiElement2);
    }

    @JvmStatic
    @Nullable
    public static final TypeScriptService getForFile(@NotNull Project project, @NotNull VirtualFile file) {
        TypeScriptService typeScriptService;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$getForFileImpl = false;
        if (file instanceof VirtualFileWindow) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TypeScriptServiceHolder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("VirtualFileWindow is not expected here, injected files need to be handled explicitly");
            typeScriptService = null;
        } else {
            typeScriptService = JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file) ? null : (TypeScriptService)ReadAction.compute((ThrowableComputable)new ThrowableComputable(project, file){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;
                {
                    this.$project = $project;
                    this.$file = $file;
                }

                public final T compute() {
                    Object v0;
                    block1: {
                        Iterable iterable = TypeScriptServiceHolder.INSTANCE.getAllForProject(this.$project);
                        VirtualFile virtualFile = this.$file;
                        for (T t : iterable) {
                            TypeScriptService it = (TypeScriptService)t;
                            boolean bl = false;
                            if (!(it instanceof TypeScriptService && it.isServiceForFile(virtualFile) && it.ensureServiceAvailable())) continue;
                            v0 = t;
                            break block1;
                        }
                        v0 = null;
                    }
                    return (T)((TypeScriptService)v0);
                }
            });
        }
        return typeScriptService;
    }

    @JvmStatic
    @Nullable
    public static final TypeScriptCompilerService getCompilerServiceForFile(@NotNull Project project, @NotNull VirtualFile file) {
        TypeScriptService typeScriptService;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$getForFileImpl = false;
        if (file instanceof VirtualFileWindow) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TypeScriptServiceHolder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("VirtualFileWindow is not expected here, injected files need to be handled explicitly");
            typeScriptService = null;
        } else {
            typeScriptService = JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file) ? null : (TypeScriptService)ReadAction.compute((ThrowableComputable)new ThrowableComputable(project, file){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;
                {
                    this.$project = $project;
                    this.$file = $file;
                }

                public final T compute() {
                    Object v0;
                    block1: {
                        Iterable iterable = TypeScriptServiceHolder.INSTANCE.getAllForProject(this.$project);
                        VirtualFile virtualFile = this.$file;
                        for (T t : iterable) {
                            TypeScriptService it = (TypeScriptService)t;
                            boolean bl = false;
                            if (!(it instanceof TypeScriptCompilerService && it.isServiceForFile(virtualFile) && it.ensureServiceAvailable())) continue;
                            v0 = t;
                            break block1;
                        }
                        v0 = null;
                    }
                    return (T)((TypeScriptService)v0);
                }
            });
        }
        return (TypeScriptCompilerService)typeScriptService;
    }
}

