/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ParameterNamingConventionJSInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSParameter parameter = (JSParameter)((PsiElement)args[0]).getParent();
        assert (parameter != null);
        String parameterName = parameter.getName();
        if (parameterName.length() < this.getMinLength()) {
            String string = InspectionJSBundle.message("parameter.name.is.too.short.error.string", new Object[0]);
            if (string == null) {
                ParameterNamingConventionJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (parameterName.length() > this.getMaxLength()) {
            String string = InspectionJSBundle.message("parameter.name.is.too.long.error.string", new Object[0]);
            if (string == null) {
                ParameterNamingConventionJSInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionJSBundle.message("parameter.name.doesnt.match.regex.error.string", this.getRegex());
        if (string == null) {
            ParameterNamingConventionJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NonNls
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/naming/ParameterNamingConventionJSInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            JSParameter[] parameters2;
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function);
            for (JSParameter variable : parameters2 = function.getParameterVariables()) {
                String name = variable.getName();
                if (name == null || ParameterNamingConventionJSInspection.this.isValid(name)) continue;
                this.registerVariableError(variable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/naming/ParameterNamingConventionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

