/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker.watcher;

import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.python.docker.watcher.PyDockerComposeInterpreterInfo;
import com.intellij.python.docker.watcher.PyDockerInterpreterInfo;
import com.intellij.python.docker.watcher.PyDockerInterpretersUpdater;
import com.intellij.python.docker.watcher.PyDockerProjectInterpretersWatcherKt;
import com.intellij.python.docker.watcher.PyInterpreterInfo;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher;", "", "<init>", "()V", "moduleToRegisteredInterpreters", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/python/docker/watcher/PyInterpreterInfo;", "updateSdkStatusForProject", "", "project", "Lcom/intellij/openapi/project/Project;", "updateSdkStatusForModule", "module", "stopWatchingForInterpreterOfModule", "Companion", "ProjectListener", "ModuleListener", "SdkEntitiesChangeListener", "intellij.python.docker"})
@SourceDebugExtension(value={"SMAP\nPyDockerProjectInterpretersWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDockerProjectInterpretersWatcher.kt\ncom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n13402#2,2:156\n62#3,5:158\n62#3,5:163\n15#3:168\n*S KotlinDebug\n*F\n+ 1 PyDockerProjectInterpretersWatcher.kt\ncom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher\n*L\n30#1:156,2\n36#1:158,5\n38#1:163,5\n71#1:168\n*E\n"})
final class PyDockerProjectInterpretersWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Module, PyInterpreterInfo<?>> moduleToRegisteredInterpreters = new LinkedHashMap();
    @NotNull
    private static final Logger LOG;

    private final void updateSdkStatusForProject(Project project) {
        Module[] $this$forEach$iv = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Module element$iv;
            Module module = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.updateSdkStatusForModule(module);
        }
    }

    private final void updateSdkStatusForModule(Module module) {
        PyInterpreterInfo info;
        Object credentials;
        Sdk sdk;
        Logger logger;
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Updating status for module '" + module.getName() + "'", e$iv);
        }
        if (module.isDisposed()) {
            $this$debug_u24default$iv = LOG;
            e$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Stop watching for changes of '" + module.getName() + "' module's assigned SDK as the module is disposed", e$iv);
            }
            this.stopWatchingForInterpreterOfModule(module);
            return;
        }
        Sdk sdk2 = sdk = PythonSdkUtil.findPythonSdk((Module)module);
        Object bl = sdk2 != null ? sdk2.getSdkAdditionalData() : null;
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = bl instanceof PyRemoteSdkAdditionalData ? (PyRemoteSdkAdditionalData)bl : null;
        Object object = credentials = pyRemoteSdkAdditionalData != null && (pyRemoteSdkAdditionalData = pyRemoteSdkAdditionalData.connectionCredentials()) != null ? pyRemoteSdkAdditionalData.getCredentials() : null;
        if (object != null) {
            Object it = object;
            boolean bl2 = false;
            Object object2 = it;
            v3 = object2 instanceof DockerCredentialsHolder ? (PyInterpreterInfo)new PyDockerInterpreterInfo(module, sdk, (DockerCredentialsHolder)it) : (object2 instanceof DockerComposeCredentialsHolder ? (PyInterpreterInfo)new PyDockerComposeInterpreterInfo(module, sdk, (DockerComposeCredentialsHolder)it) : null);
        } else {
            v3 = info = null;
        }
        if (info == null) {
            this.stopWatchingForInterpreterOfModule(module);
        } else {
            PyInterpreterInfo<?> oldInfo;
            PyInterpreterInfo<?> pyInterpreterInfo = oldInfo = this.moduleToRegisteredInterpreters.get(module);
            if (!Intrinsics.areEqual(pyInterpreterInfo != null ? pyInterpreterInfo.getCredentials() : null, info.getCredentials())) {
                this.moduleToRegisteredInterpreters.put(module, info);
                PyDockerInterpretersUpdater.Companion.getInstance().registerInterpreter$intellij_python_docker(info);
            }
        }
    }

    private final void stopWatchingForInterpreterOfModule(Module module) {
        this.moduleToRegisteredInterpreters.remove(module);
        PyDockerInterpretersUpdater.Companion.getInstance().unregisterForModule$intellij_python_docker(module);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PyDockerProjectInterpretersWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.docker"})
    @SourceDebugExtension(value={"SMAP\nPyDockerProjectInterpretersWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDockerProjectInterpretersWatcher.kt\ncom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,155:1\n31#2,2:156\n*S KotlinDebug\n*F\n+ 1 PyDockerProjectInterpretersWatcher.kt\ncom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher$Companion\n*L\n72#1:156,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final PyDockerProjectInterpretersWatcher getInstance(Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PyDockerProjectInterpretersWatcher> serviceClass$iv = PyDockerProjectInterpretersWatcher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PyDockerProjectInterpretersWatcher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher$ModuleListener;", "Lcom/intellij/openapi/project/ModuleListener;", "<init>", "()V", "moduleRemoved", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.python.docker"})
    public static final class ModuleListener
    implements com.intellij.openapi.project.ModuleListener {
        public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Companion.getInstance(project).moduleToRegisteredInterpreters.remove(module);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher$ProjectListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "<init>", "()V", "projectOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.docker"})
    public static final class ProjectListener
    implements ProjectManagerListener {
        public void projectOpened(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Companion.getInstance(project).updateSdkStatusForProject(project);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher$SdkEntitiesChangeListener;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "<init>", "()V", "changed", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "onModuleAddedOrRemoved", "storageWithModule", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "entity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "eventType", "", "onModuleUpdated", "oldEntity", "newEntity", "intellij.python.docker"})
    @SourceDebugExtension(value={"SMAP\nPyDockerProjectInterpretersWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDockerProjectInterpretersWatcher.kt\ncom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher$SdkEntitiesChangeListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n62#2,5:156\n62#2,5:161\n62#2,5:166\n*S KotlinDebug\n*F\n+ 1 PyDockerProjectInterpretersWatcher.kt\ncom/intellij/python/docker/watcher/PyDockerProjectInterpretersWatcher$SdkEntitiesChangeListener\n*L\n104#1:156,5\n121#1:161,5\n128#1:166,5\n*E\n"})
    public static final class SdkEntitiesChangeListener
    implements WorkspaceModelChangeListener {
        public void changed(@NotNull VersionedStorageChange event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            List entityChanges = event.getChanges(ModuleEntity.class);
            for (EntityChange entityChange : entityChanges) {
                EntityChange entityChange2 = entityChange;
                if (entityChange2 instanceof EntityChange.Added) {
                    this.onModuleAddedOrRemoved(event.getStorageAfter(), (ModuleEntity)((EntityChange.Added)entityChange).getNewEntity(), "added");
                    continue;
                }
                if (entityChange2 instanceof EntityChange.Removed) {
                    this.onModuleAddedOrRemoved(event.getStorageBefore(), (ModuleEntity)((EntityChange.Removed)entityChange).getOldEntity(), "removed");
                    continue;
                }
                if (entityChange2 instanceof EntityChange.Replaced) {
                    this.onModuleUpdated(event, (ModuleEntity)((EntityChange.Replaced)entityChange).getOldEntity(), (ModuleEntity)((EntityChange.Replaced)entityChange).getNewEntity());
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        private final void onModuleAddedOrRemoved(ImmutableEntityStorage storageWithModule, ModuleEntity entity, String eventType) {
            if (PyDockerProjectInterpretersWatcherKt.access$hasSdkDependencies(entity)) {
                ModuleBridge module = ModuleEntityUtils.findModule((ModuleEntity)entity, (EntityStorage)((EntityStorage)storageWithModule));
                if (module != null) {
                    Logger $this$debug_u24default$iv = LOG;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Module '" + module.getName() + "' has been " + eventType + " with SDK dependencies [" + PyDockerProjectInterpretersWatcherKt.access$toPresentableString(PyDockerProjectInterpretersWatcherKt.access$collectSdkDependencies(entity)) + "]", e$iv);
                    }
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Companion.getInstance(project).updateSdkStatusForModule((Module)module);
                } else {
                    LOG.info("Module '" + entity.getName() + "' has been " + eventType + ", but it is not found in entity storage");
                }
            }
        }

        private final void onModuleUpdated(VersionedStorageChange event, ModuleEntity oldEntity, ModuleEntity newEntity) {
            Set oldSdkDependencies = PyDockerProjectInterpretersWatcherKt.access$collectSdkDependencies(oldEntity);
            Set newSdkDependencies = PyDockerProjectInterpretersWatcherKt.access$collectSdkDependencies(newEntity);
            if (!Intrinsics.areEqual((Object)newSdkDependencies, (Object)oldSdkDependencies)) {
                ModuleBridge module = ModuleEntityUtils.findModule((ModuleEntity)newEntity, (EntityStorage)((EntityStorage)event.getStorageAfter()));
                if (module != null) {
                    Logger $this$debug_u24default$iv = LOG;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("SDK dependencies of the module '" + module.getName() + "' have been changed from [" + PyDockerProjectInterpretersWatcherKt.access$toPresentableString(oldSdkDependencies) + "] to [" + PyDockerProjectInterpretersWatcherKt.access$toPresentableString(newSdkDependencies) + "]", e$iv);
                    }
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Companion.getInstance(project).updateSdkStatusForModule((Module)module);
                } else {
                    Logger $this$debug_u24default$iv = LOG;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("SDK dependencies have been replaced from [" + PyDockerProjectInterpretersWatcherKt.access$toPresentableString(oldSdkDependencies) + "] to [" + PyDockerProjectInterpretersWatcherKt.access$toPresentableString(newSdkDependencies) + "], but the associated module \"" + newEntity.getName() + "\" is not found", e$iv);
                    }
                }
            }
        }
    }
}

