/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.fastapi;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.pro.fastapi.FastApiExecutionException;
import com.intellij.python.pro.fastapi.FastApiRunConfiguration;
import com.intellij.python.pro.fastapi.UtilKt;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonModuleExecution;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/python/pro/fastapi/FastApiRunServerCommandLineState;", "Lcom/jetbrains/python/run/PythonCommandLineState;", "configuration", "Lcom/intellij/python/pro/fastapi/FastApiRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Lcom/intellij/python/pro/fastapi/FastApiRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "uvicornAppName", "", "getUvicornAppName", "()Ljava/lang/String;", "generateCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "buildPythonExecution", "Lcom/jetbrains/python/run/PythonExecution;", "helpersAwareRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "getPythonExecutionWorkingDir", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "createRunConfigurationHyperlinkListener", "Lkotlin/Function1;", "Ljavax/swing/event/HyperlinkEvent;", "", "intellij.python"})
@SourceDebugExtension(value={"SMAP\nfastApiRun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 fastApiRun.kt\ncom/intellij/python/pro/fastapi/FastApiRunServerCommandLineState\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n13402#2,2:224\n1#3:226\n*S KotlinDebug\n*F\n+ 1 fastApiRun.kt\ncom/intellij/python/pro/fastapi/FastApiRunServerCommandLineState\n*L\n138#1:224,2\n*E\n"})
public final class FastApiRunServerCommandLineState
extends PythonCommandLineState {
    @NotNull
    private final FastApiRunConfiguration configuration;

    public FastApiRunServerCommandLineState(@NotNull FastApiRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super((AbstractPythonRunConfiguration)configuration, environment);
        this.configuration = configuration;
    }

    private final String getUvicornAppName() {
        Object object = ReadAction.compute(() -> FastApiRunServerCommandLineState._get_uvicornAppName_$lambda$2(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (String)object;
    }

    @NotNull
    public GeneralCommandLine generateCommandLine() {
        ParamsGroup moduleGroup;
        GeneralCommandLine generalCommandLine = super.generateCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"generateCommandLine(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        ParamsGroup paramsGroup = commandLine.getParametersList().getParamsGroup("Exe Options");
        Intrinsics.checkNotNull((Object)paramsGroup);
        ParamsGroup exeOptions = paramsGroup;
        exeOptions.addParametersString(this.configuration.getInterpreterOptions());
        ParamsGroup paramsGroup2 = moduleGroup = commandLine.getParametersList().getParamsGroup("Module");
        Intrinsics.checkNotNull((Object)paramsGroup2);
        paramsGroup2.addParameter("-m");
        moduleGroup.addParameter("uvicorn");
        moduleGroup.addParametersString(this.getUvicornAppName());
        String string = this.configuration.getFastApiOptions().getAdditionalOptions();
        if (string != null) {
            String string2;
            String $this$generateCommandLine_u24lambda_u243 = string2 = string;
            boolean bl = false;
            moduleGroup.addParametersString($this$generateCommandLine_u24lambda_u243);
        }
        commandLine.setWorkDirectory(Paths.get(this.configuration.getWorkingDirectorySafe(), new String[0]).toFile());
        return commandLine;
    }

    @NotNull
    protected PythonExecution buildPythonExecution(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareRequest) {
        PythonModuleExecution execution;
        block1: {
            Intrinsics.checkNotNullParameter((Object)helpersAwareRequest, (String)"helpersAwareRequest");
            execution = new PythonModuleExecution();
            execution.setModuleName("uvicorn");
            execution.addParameter(this.getUvicornAppName());
            String string = this.configuration.getFastApiOptions().getAdditionalOptions();
            if (string == null) break block1;
            String options = string;
            boolean bl = false;
            String[] stringArray = ParametersList.parse((String)options);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"parse(...)");
            Object[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                execution.addParameter(it);
            }
        }
        return (PythonExecution)execution;
    }

    @Nullable
    protected Function<TargetEnvironment, String> getPythonExecutionWorkingDir(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        Function function;
        String workingDir;
        String string;
        Intrinsics.checkNotNullParameter((Object)targetEnvironmentRequest, (String)"targetEnvironmentRequest");
        String explicitWorkingDir = this.configuration.getWorkingDirectory();
        if (explicitWorkingDir != null && !StringsKt.isBlank((CharSequence)explicitWorkingDir)) {
            string = PythonScriptCommandLineState.getExpandedWorkingDir((AbstractPythonRunConfiguration)((AbstractPythonRunConfiguration)this.configuration));
        } else {
            Module module = this.configuration.getModule();
            string = module != null ? BasePySdkExtKt.getBasePath((Module)module) : null;
        }
        String string2 = workingDir = string;
        if (string2 == null) {
            function = null;
        } else {
            Path path2 = Path.of(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            function = TargetEnvironmentFunctions.targetPath((Path)path2);
        }
        return function;
    }

    private final Function1<HyperlinkEvent, Unit> createRunConfigurationHyperlinkListener() {
        return arg_0 -> FastApiRunServerCommandLineState.createRunConfigurationHyperlinkListener$lambda$7(this, arg_0);
    }

    private static final String _get_uvicornAppName_$lambda$2(FastApiRunServerCommandLineState this$0) {
        String string;
        String string2;
        block9: {
            block8: {
                PyFile pyFile;
                string2 = this$0.configuration.getFastApiOptions().getFile();
                if (string2 == null) break block8;
                String fastApiFilePath = string2;
                boolean bl = false;
                VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(fastApiFilePath, new String[0]), (boolean)false);
                if (virtualFile != null) {
                    VirtualFile vFile = virtualFile;
                    boolean bl2 = false;
                    PsiFile psiFile = PsiManager.getInstance((Project)this$0.configuration.getProject()).findFile(vFile);
                    pyFile = psiFile instanceof PyFile ? (PyFile)psiFile : null;
                } else {
                    pyFile = null;
                }
                string2 = pyFile;
                if (pyFile != null) break block9;
            }
            String string3 = PythonProBundle.message((String)"fastapi.run.invalid.file.error.notification");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            throw new FastApiExecutionException(string3, this$0.createRunConfigurationHyperlinkListener());
        }
        String pyFile = string2;
        QualifiedName qualifiedName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)((PsiFileSystemItem)pyFile));
        Intrinsics.checkNotNull((Object)qualifiedName);
        QualifiedName qName = qualifiedName;
        String explicitAppName = this$0.configuration.getFastApiOptions().getAppName();
        if (explicitAppName != null && !StringsKt.isBlank((CharSequence)explicitAppName)) {
            string = explicitAppName;
        } else {
            PyTargetExpression app = UtilKt.findFastApiApplicationWithResolve((PyFile)pyFile);
            if (app == null) {
                String string4 = this$0.configuration.getFastApiOptions().getFile();
                Intrinsics.checkNotNull((Object)string4);
                String fileName = StringsKt.substringAfterLast$default((String)string4, (String)"/", null, (int)2, null);
                Object[] objectArray = new Object[]{fileName};
                String string5 = PythonProBundle.message((String)"fastapi.run.no.app.in.file", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                throw new FastApiExecutionException(string5, this$0.createRunConfigurationHyperlinkListener());
            }
            string = app.getName();
        }
        String appName = string;
        return qName + ":" + appName;
    }

    private static final Unit createRunConfigurationHyperlinkListener$lambda$7(FastApiRunServerCommandLineState this$0, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && Intrinsics.areEqual((Object)it.getDescription(), (Object)"edit")) {
            Object v1;
            block3: {
                Project project = this$0.configuration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                RunManager runManager = RunManager.Companion.getInstance(project);
                Iterable iterable = runManager.getAllSettings();
                for (Object t : iterable) {
                    RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)settings.getConfiguration(), (Object)((Object)this$0.configuration))) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            RunnerAndConfigurationSettings configurationSettings = v1;
            if (configurationSettings != null) {
                Object[] objectArray = new Object[]{this$0.configuration.getName()};
                RunDialog.editConfiguration((Project)this$0.configuration.getProject(), (RunnerAndConfigurationSettings)configurationSettings, (String)ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])objectArray));
            }
        }
        return Unit.INSTANCE;
    }
}

