/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.lines;

import com.google.common.collect.Maps;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.python.pro.coverage.PyCoverageEngine;
import com.intellij.python.profiler.CallTreeNode;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0006\u0010\u001a\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0080\u0001\u0010\f\u001ar\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012 \u000f*\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00100\u0010 \u000f*8\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012 \u000f*\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00100\u0010\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/python/profiler/lines/LineProfileSuite;", "Lcom/intellij/coverage/BaseCoverageSuite;", "stats", "Lcom/intellij/python/profiler/ProfileStats;", "<init>", "(Lcom/intellij/python/profiler/ProfileStats;)V", "engine", "Lcom/intellij/python/pro/coverage/PyCoverageEngine;", "getCoverageEngine", "Lcom/intellij/coverage/CoverageEngine;", "isCoverageByTestApplicable", "", "myFilesWithLines", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "", "", "Lcom/intellij/rt/coverage/data/LineData;", "Ljava/util/HashMap;", "walkTree", "", "tree", "Lcom/intellij/python/profiler/CallTreeNode;", "loadProjectInfo", "Lcom/intellij/rt/coverage/data/ProjectData;", "projectData", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nLineProfileSuite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineProfileSuite.kt\ncom/intellij/python/profiler/lines/LineProfileSuite\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,77:1\n381#2,7:78\n381#2,7:85\n*S KotlinDebug\n*F\n+ 1 LineProfileSuite.kt\ncom/intellij/python/profiler/lines/LineProfileSuite\n*L\n45#1:78,7\n48#1:85,7\n*E\n"})
public final class LineProfileSuite
extends BaseCoverageSuite {
    @NotNull
    private final PyCoverageEngine engine;
    private final HashMap<String, Map<Integer, LineData>> myFilesWithLines;

    public LineProfileSuite(@NotNull ProfileStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        super("LineProfiling", null, null, new CoverageFileProvider(){

            public String getCoverageDataFilePath() {
                return "";
            }

            public boolean ensureFileExists() {
                return true;
            }

            public boolean isValid() {
                return true;
            }
        }, System.currentTimeMillis());
        this.engine = new PyCoverageEngine(){

            public Object[] postProcessExecutableLines(Object[] executableLines, Editor editor) {
                Intrinsics.checkNotNullParameter((Object)executableLines, (String)"executableLines");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return executableLines;
            }
        };
        this.myFilesWithLines = Maps.newHashMap();
        this.walkTree(stats.getCallTree());
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        return this.engine;
    }

    public boolean isCoverageByTestApplicable() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void walkTree(CallTreeNode tree) {
        Object object;
        void $this$getOrPut$iv;
        if (tree == null) {
            return;
        }
        HashMap<String, Map<Integer, LineData>> hashMap = this.myFilesWithLines;
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"myFilesWithLines");
        Iterator<CallTreeNode> iterator = hashMap;
        String string = tree.getFile();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(string);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = Maps.newHashMap();
            $this$getOrPut$iv.put(string, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map lineDataMap = (Map)object;
        for (Map.Entry entry : tree.getLineHits().entrySet()) {
            Object object2;
            void $this$getOrPut$iv2;
            int line = ((Number)entry.getKey()).intValue();
            int hits = ((Number)entry.getValue()).intValue();
            Intrinsics.checkNotNull((Object)lineDataMap);
            Map map = lineDataMap;
            Integer key$iv3 = line;
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv2.get(key$iv3);
            if (value$iv2 == null) {
                boolean bl = false;
                LineData answer$iv = new LineData(line, "");
                $this$getOrPut$iv2.put(key$iv3, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv2;
            }
            LineData lineData = (LineData)object2;
            lineData.setHits(lineData.getHits() + hits);
        }
        for (CallTreeNode callTreeNode : tree.getChildren()) {
            this.walkTree(callTreeNode);
        }
    }

    @NotNull
    protected ProjectData loadProjectInfo() {
        return this.projectData();
    }

    @NotNull
    public final ProjectData projectData() {
        ProjectData data = new ProjectData();
        HashMap<String, Map<Integer, LineData>> hashMap = this.myFilesWithLines;
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"myFilesWithLines");
        for (Map.Entry entry : ((Map)hashMap).entrySet()) {
            Integer max;
            String k = (String)entry.getKey();
            Map lines = (Map)entry.getValue();
            ClassData file = data.getOrCreateClassData(k);
            Integer n = max = (Integer)CollectionsKt.maxOrNull((Iterable)lines.keySet());
            LineData[] linesArray = new LineData[n != null ? n + 1 : 0];
            Intrinsics.checkNotNull((Object)lines);
            for (Map.Entry entry2 : lines.entrySet()) {
                LineData v;
                int k2 = ((Number)entry2.getKey()).intValue();
                linesArray[k2] = v = (LineData)entry2.getValue();
            }
            file.setLines(linesArray);
        }
        return data;
    }
}

