/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSessionKey;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteUpload;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionServiceUtil;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.python.PythonHelpersLocator;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PyHelpersUpload
extends RemoteUpload {
    private static final Logger LOG = Logger.getInstance(PyHelpersUpload.class);
    private static final Object myAsyncTransferLock = new Object();
    private static final ConcurrentMap<SshSessionKey, ListenableFuture<?>> myHelpersTransferSessionMap = Maps.newConcurrentMap();
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("PyCharm Helpers Upload");
    private static final String BUILD_FILE_PATH = "/build.txt";

    private PyHelpersUpload(@Nullable Project project, @Nullable Component component, RemoteCredentials credentials, boolean isModal, Collection<String> helpersPaths, String remotePath) {
        super(credentials, project, component, PythonRemoteInterpreterBundle.message("pycharm.helpers.upload.progress.title", new Object[0]), false, isModal, helpersPaths, remotePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ListenableFuture<?> uploadAllHelpers(@Nullable Project project, @Nullable Component component, @NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties, boolean uploadOnSnapshot) {
        if (credentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(0);
        }
        if (sdkProperties == null) {
            PyHelpersUpload.$$$reportNull$$$0(1);
        }
        List helperRoots = ContainerUtil.map((Collection)PythonHelpersLocator.getHelpersRoots(), it -> it.toString());
        Object object = myAsyncTransferLock;
        synchronized (object) {
            SshSessionKey key = SshConnectionServiceUtil.remoteCredentialsToSessionKey((RemoteCredentials)credentials);
            PyHelpersUpload transfer = (PyHelpersUpload)((Object)UIUtil.invokeAndWaitIfNeeded(() -> new PyHelpersUpload(project, component, credentials, false, helperRoots, sdkProperties.getHelpersPath())));
            transfer.setUploadOnSnapshot(uploadOnSnapshot);
            Callable<Object> transferTask = () -> {
                PyHelpersUpload.removeHelpersIfNeeded(credentials, sdkProperties);
                ListenableFuture f = JdkFutureAdapters.listenInPoolThread((Future)transfer.upload());
                f.addListener(() -> myHelpersTransferSessionMap.remove(key), (Executor)ourExecutorService);
                myHelpersTransferSessionMap.put(key, f);
                if (f.isDone()) {
                    myHelpersTransferSessionMap.remove(key);
                }
                return f.get();
            };
            ListenableFuture future = (ListenableFuture)myHelpersTransferSessionMap.get(key);
            if (future != null) {
                return Futures.transform((ListenableFuture)future, input -> {
                    try {
                        return transferTask.call();
                    }
                    catch (Exception e) {
                        LOG.error("Error from future", (Throwable)e);
                        return false;
                    }
                }, (Executor)ourExecutorService);
            }
            return ourExecutorService.submit(transferTask);
        }
    }

    public static void uploadHelpersSync(@Nullable Project project, @NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties, @NotNull Set<String> filesToUpload) {
        if (credentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(2);
        }
        if (sdkProperties == null) {
            PyHelpersUpload.$$$reportNull$$$0(3);
        }
        if (filesToUpload == null) {
            PyHelpersUpload.$$$reportNull$$$0(4);
        }
        PyHelpersUpload transfer = new PyHelpersUpload(project, null, credentials, true, filesToUpload, sdkProperties.getHelpersPath()){

            @Override
            protected boolean helpersArchiveCopyEnabled() {
                return false;
            }
        };
        Path root = PythonHelpersLocator.getCommunityHelpersRoot();
        ImmutableMap map = Maps.toMap(filesToUpload, path2 -> FileUtil.getRelativePath((File)root.toFile(), (File)new File(Objects.requireNonNull(path2))));
        transfer.setRelativePathsMap((Map)map);
        ListenableFuture future = JdkFutureAdapters.listenInPoolThread((Future)transfer.upload());
        try {
            future.get();
        }
        catch (Exception e) {
            LOG.error("Helpers upload failed", (Throwable)e);
        }
    }

    protected boolean helpersArchiveCopyEnabled() {
        return true;
    }

    @NotNull
    protected List<ExcludedPath> getExcludedHelpersPaths(@NotNull Collection<String> helpersPaths) {
        if (helpersPaths == null) {
            PyHelpersUpload.$$$reportNull$$$0(5);
        }
        Set<String> pathsToExclude = PyHelpersUpload.getPathsToExclude();
        ArrayList<ExcludedPath> result = new ArrayList<ExcludedPath>();
        for (String path2 : helpersPaths) {
            for (String subPath : pathsToExclude) {
                File helper = new File(path2, subPath);
                if (!helper.exists()) continue;
                result.add(new ExcludedPath(helper.getPath(), true));
            }
        }
        ArrayList<ExcludedPath> arrayList = result;
        if (arrayList == null) {
            PyHelpersUpload.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static Set<String> getPathsToExclude() {
        Set<String> set = Set.of("docutils", "epydoc", "process", "pydev/pydev_test_pydevd_reload", "pydev/pydev_tests", "pydev/pydev_tests_mainloop", "pydev/pydev_tests_python", "pydev/pydev_tests_runfiles", "pydev/pytest.ini", "pydev/third_party", "pydev/tox.ini", "python-skeletons", "tools", "MathJax", "py2only", "py3only", "typeshed", "tests");
        if (set == null) {
            PyHelpersUpload.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    protected Predicate<String> createFileFilter() {
        Set<String> pathsToExclude = PyHelpersUpload.getPathsToExclude();
        Predicate predicate = path2 -> path2 != null && !pathsToExclude.contains(path2) && !path2.endsWith(".pyc") && !path2.endsWith(".class") && !path2.endsWith("conftest.py");
        if (predicate == null) {
            PyHelpersUpload.$$$reportNull$$$0(8);
        }
        return predicate;
    }

    protected void onUploadError(@NotNull SshException e) {
        if (e == null) {
            PyHelpersUpload.$$$reportNull$$$0(9);
        }
        @NlsSafe String localizedMessage = e.getLocalizedMessage();
        NOTIFICATION_GROUP.createNotification(PythonRemoteInterpreterBundle.message("upload.helpers.error.text", new Object[0]), localizedMessage, NotificationType.WARNING).notify(this.getProject());
    }

    private static void removeHelpersIfNeeded(RemoteCredentials credentials, RemoteSdkProperties sdkProperties) {
        String localVersion = ApplicationInfo.getInstance().getBuild().asString();
        try (SftpChannel connection = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials).openSftpChannel();){
            RemoteFileObject buildFile = connection.file(sdkProperties.getHelpersPath() + BUILD_FILE_PATH);
            String remoteVersion = null;
            try (InputStream inputStream = buildFile.inputStream();){
                remoteVersion = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                LOG.warn("Failed to get remote version from build.txt");
            }
            if (remoteVersion != null && !remoteVersion.equals(localVersion)) {
                PyHelpersUpload.deleteRemoteDir(connection.file(sdkProperties.getHelpersPath()));
            }
        }
        catch (SshException e) {
            LOG.warn("Failed to remove pycharm helpers directory from remote interpreter");
        }
    }

    private static void deleteRemoteDir(RemoteFileObject remoteFileObject) {
        if (!remoteFileObject.rm()) {
            List children = remoteFileObject.list();
            for (RemoteFileObject file : children) {
                PyHelpersUpload.deleteRemoteDir(file);
            }
            remoteFileObject.rm();
        }
    }

    @TestOnly
    public static synchronized void shutDownService() {
        ourExecutorService.shutdownNow();
        try {
            ourExecutorService.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to stop threads", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToUpload";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPaths";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/PyHelpersUpload";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyHelpersUpload";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedHelpersPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToExclude";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uploadAllHelpers";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uploadHelpersSync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedHelpersPaths";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onUploadError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

