/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.substitution;

import com.intellij.httpClient.http.request.HttpRequestExecutionEnvironment;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutionKey;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpVariableBase;
import com.intellij.httpClient.http.request.substitution.HttpEnvironmentContextProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/http/request/substitution/HttpRequestVariableCommonSubstitutorImpl;", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "<init>", "()V", "context", "Lcom/intellij/httpClient/http/request/substitution/HttpEnvironmentContextProvider;", "getContext", "()Lcom/intellij/httpClient/http/request/substitution/HttpEnvironmentContextProvider;", "getValue", "", "element", "Lcom/intellij/psi/PsiElement;", "filter", "Lcom/intellij/openapi/util/Condition;", "getAllEnvVariables", "", "Lcom/intellij/httpClient/http/request/HttpRequestExecutionEnvironment$VariableInfo;", "getVariableValue", "variable", "Lcom/intellij/httpClient/http/request/psi/HttpVariableBase;", "key", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutionKey;", "name", "defaultValue", "project", "Lcom/intellij/openapi/project/Project;", "intellij.httpClient.executor"})
public abstract class HttpRequestVariableCommonSubstitutorImpl
implements HttpRequestVariableSubstitutor {
    @NotNull
    public abstract HttpEnvironmentContextProvider getContext();

    @Override
    @NotNull
    public String getValue(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Condition condition = Conditions.alwaysTrue();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"alwaysTrue(...)");
        return this.getValue(element, (Condition<? super PsiElement>)condition);
    }

    @Override
    @NotNull
    public String getValue(@NotNull PsiElement element, @NotNull Condition<? super PsiElement> filter2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        if (element instanceof HttpVariableBase) {
            return this.getVariableValue((HttpVariableBase)element, HttpRequestVariableSubstitutionKey.Companion.fromPsiElement(element));
        }
        if (!(element instanceof HttpRequestCompositeElement)) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        StringBuilder builder = new StringBuilder();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof HttpVariableBase) {
                builder.append(this.getVariableValue((HttpVariableBase)child, HttpRequestVariableSubstitutionKey.Companion.fromPsiElement(child)));
                continue;
            }
            if (!filter2.value((Object)child)) continue;
            builder.append(child.getText());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public List<HttpRequestExecutionEnvironment.VariableInfo> getAllEnvVariables() {
        List<HttpRequestExecutionEnvironment.VariableInfo> list2 = this.getContext().getEnvironment().getAllVariables();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllVariables(...)");
        return list2;
    }

    @NotNull
    public String getVariableValue(@NotNull HttpVariableBase variable, @NotNull HttpRequestVariableSubstitutionKey key) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (variable instanceof HttpDynamicVariable) {
            return this.getContext().getDynamicVariable((HttpDynamicVariable)variable, key);
        }
        String string = variable.getName();
        if (string == null) {
            String string2 = variable.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            return string2;
        }
        String name = string;
        String string3 = HttpEnvironmentContextProvider.getValue$default(this.getContext(), name, variable.getText(), key, null, 8, null);
        if (string3 == null) {
            String string4 = variable.getText();
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        }
        return string3;
    }

    @Override
    @Nullable
    public String getVariableValue(@Nullable String name, @Nullable String defaultValue, @NotNull Project project, @Nullable HttpRequestVariableSubstitutionKey key) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (name == null) {
            return null;
        }
        return this.getContext().getValue(name, defaultValue, key, project);
    }
}

