/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalDurationPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.cast.JSNumberToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerWithoutRoundingNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.TemporalBalanceDateDurationRelativeNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDurationAddNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalRoundDurationNode;
import com.oracle.truffle.js.nodes.temporal.TemporalUnbalanceDateDurationRelativeNode;
import com.oracle.truffle.js.nodes.temporal.ToRelativeTemporalObjectNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.DateDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;

public class TemporalDurationPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalDurationPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalDurationPrototypeBuiltins();

    protected TemporalDurationPrototypeBuiltins() {
        super(JSTemporalDuration.PROTOTYPE_NAME, TemporalDurationPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalDurationPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationGetterNodeGen.create(context2, builtin, builtinEnum, TemporalDurationPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 12: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationWithNodeGen.create(context2, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 13: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationNegatedNodeGen.create(context2, builtin, TemporalDurationPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 14: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationAbsNodeGen.create(context2, builtin, TemporalDurationPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 15: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationAddSubNodeGen.create(context2, builtin, 1, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 16: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationAddSubNodeGen.create(context2, builtin, -1, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 17: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationRoundNodeGen.create(context2, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 18: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationTotalNodeGen.create(context2, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 19: 
            case 21: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationToLocaleStringNodeGen.create(context2, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 20: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationToStringNodeGen.create(context2, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 22: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationValueOfNodeGen.create(context2, builtin, TemporalDurationPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum TemporalDurationPrototype implements BuiltinEnum<TemporalDurationPrototype>
    {
        years(0),
        months(0),
        weeks(0),
        days(0),
        hours(0),
        minutes(0),
        seconds(0),
        milliseconds(0),
        microseconds(0),
        nanoseconds(0),
        sign(0),
        blank(0),
        with(1),
        negated(0),
        abs(0),
        add(1),
        subtract(1),
        round(1),
        total(1),
        toJSON(0),
        toString(0),
        toLocaleString(0),
        valueOf(0);

        private final int length;

        private TemporalDurationPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(hours, new TemporalDurationPrototype[]{minutes, seconds, milliseconds, microseconds, nanoseconds, years, months, weeks, days, sign, blank}).contains(this);
        }
    }

    public static abstract class JSTemporalDurationGetterNode
    extends JSBuiltinNode {
        public final TemporalDurationPrototype property;

        public JSTemporalDurationGetterNode(JSContext context2, JSBuiltin builtin, TemporalDurationPrototype property) {
            super(context2, builtin);
            this.property = property;
        }

        @Specialization
        protected Object durationGetter(JSTemporalDurationObject temporalD) {
            switch (this.property.ordinal()) {
                case 4: {
                    return temporalD.getHours();
                }
                case 5: {
                    return temporalD.getMinutes();
                }
                case 6: {
                    return temporalD.getSeconds();
                }
                case 7: {
                    return temporalD.getMilliseconds();
                }
                case 8: {
                    return temporalD.getMicroseconds();
                }
                case 9: {
                    return temporalD.getNanoseconds();
                }
                case 0: {
                    return temporalD.getYears();
                }
                case 1: {
                    return temporalD.getMonths();
                }
                case 2: {
                    return temporalD.getWeeks();
                }
                case 3: {
                    return temporalD.getDays();
                }
                case 10: {
                    return TemporalUtil.durationSign(temporalD.getYears(), temporalD.getMonths(), temporalD.getWeeks(), temporalD.getDays(), temporalD.getHours(), temporalD.getMinutes(), temporalD.getSeconds(), temporalD.getMilliseconds(), temporalD.getMicroseconds(), temporalD.getNanoseconds());
                }
                case 11: {
                    int sign = TemporalUtil.durationSign(temporalD.getYears(), temporalD.getMonths(), temporalD.getWeeks(), temporalD.getDays(), temporalD.getHours(), temporalD.getMinutes(), temporalD.getSeconds(), temporalD.getMilliseconds(), temporalD.getMicroseconds(), temporalD.getNanoseconds());
                    return sign == 0;
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationWith(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSTemporalDurationObject with(JSTemporalDurationObject duration, Object temporalDurationLike, @Cached JSToIntegerWithoutRoundingNode toInt, @Cached InlinedBranchProfile errorBranch) {
            JSDynamicObject durationLike = TemporalUtil.toPartialDuration(temporalDurationLike, this.getContext(), this.isObjectNode, toInt, this, errorBranch);
            double years = TemporalUtil.getDouble(durationLike, TemporalConstants.YEARS, duration.getYears());
            double months = TemporalUtil.getDouble(durationLike, TemporalConstants.MONTHS, duration.getMonths());
            double weeks = TemporalUtil.getDouble(durationLike, TemporalConstants.WEEKS, duration.getWeeks());
            double days = TemporalUtil.getDouble(durationLike, TemporalConstants.DAYS, duration.getDays());
            double hours = TemporalUtil.getDouble(durationLike, TemporalConstants.HOURS, duration.getHours());
            double minutes = TemporalUtil.getDouble(durationLike, TemporalConstants.MINUTES, duration.getMinutes());
            double seconds = TemporalUtil.getDouble(durationLike, TemporalConstants.SECONDS, duration.getSeconds());
            double milliseconds = TemporalUtil.getDouble(durationLike, TemporalConstants.MILLISECONDS, duration.getMilliseconds());
            double microseconds = TemporalUtil.getDouble(durationLike, TemporalConstants.MICROSECONDS, duration.getMicroseconds());
            double nanoseconds = TemporalUtil.getDouble(durationLike, TemporalConstants.NANOSECONDS, duration.getNanoseconds());
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationNegated
    extends JSBuiltinNode {
        protected JSTemporalDurationNegated(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSTemporalDurationObject negated(JSTemporalDurationObject duration) {
            return JSTemporalDuration.createNegatedTemporalDuration(this.getContext(), this.getRealm(), duration);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationAbs
    extends JSBuiltinNode {
        protected JSTemporalDurationAbs(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSTemporalDurationObject abs(JSTemporalDurationObject duration, @Cached InlinedBranchProfile errorBranch) {
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), Math.abs(duration.getYears()), Math.abs(duration.getMonths()), Math.abs(duration.getWeeks()), Math.abs(duration.getDays()), Math.abs(duration.getHours()), Math.abs(duration.getMinutes()), Math.abs(duration.getSeconds()), Math.abs(duration.getMilliseconds()), Math.abs(duration.getMicroseconds()), Math.abs(duration.getNanoseconds()), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;
        @Node.Child
        private GetMethodNode getMethodDateAddNode;
        @Node.Child
        private GetMethodNode getMethodDateUntilNode;

        protected JSTemporalDurationAddSubNode(JSContext context2, JSBuiltin builtin, int sign) {
            super(context2, builtin);
            this.sign = sign;
            this.getMethodDateAddNode = GetMethodNode.create(context2, TemporalConstants.DATE_ADD);
            this.getMethodDateUntilNode = GetMethodNode.create(context2, TemporalConstants.DATE_UNTIL);
        }

        @Specialization
        protected JSTemporalDurationObject addDurationToOrSubtractDurationFromDuration(JSTemporalDurationObject duration, Object other, Object options, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached TemporalDurationAddNode durationAddNode, @Cached ToRelativeTemporalObjectNode toRelativeTemporalObjectNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalDurationObject otherDuration = toTemporalDurationNode.execute(other);
            JSDynamicObject normalizedOptions = this.getOptionsObject(options, this, errorBranch, optionUndefined);
            ToRelativeTemporalObjectNode.Result relativeToRec = toRelativeTemporalObjectNode.execute(normalizedOptions);
            JSTemporalCalendarHolder relativeTo = relativeToRec.relativeTo();
            TimeZoneMethodsRecord timeZoneRec = relativeToRec.timeZoneRec();
            CalendarMethodsRecord calendarRec = relativeToRec.createCalendarMethodsRecord(this.getMethodDateAddNode, this.getMethodDateUntilNode);
            JSTemporalDurationRecord result2 = durationAddNode.execute(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), (double)this.sign * otherDuration.getYears(), (double)this.sign * otherDuration.getMonths(), (double)this.sign * otherDuration.getWeeks(), (double)this.sign * otherDuration.getDays(), (double)this.sign * otherDuration.getHours(), (double)this.sign * otherDuration.getMinutes(), (double)this.sign * otherDuration.getSeconds(), (double)this.sign * otherDuration.getMilliseconds(), (double)this.sign * otherDuration.getMicroseconds(), (double)this.sign * otherDuration.getNanoseconds(), relativeTo, calendarRec, timeZoneRec, null);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), result2.getYears(), result2.getMonths(), result2.getWeeks(), result2.getDays(), result2.getHours(), result2.getMinutes(), result2.getSeconds(), result2.getMilliseconds(), result2.getMicroseconds(), result2.getNanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object other, Object options) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationRound
    extends JSTemporalBuiltinOperation {
        @Node.Child
        private GetMethodNode getMethodDateAddNode;
        @Node.Child
        private GetMethodNode getMethodDateUntilNode;

        protected JSTemporalDurationRound(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.getMethodDateAddNode = GetMethodNode.create(context2, TemporalConstants.DATE_ADD);
            this.getMethodDateUntilNode = GetMethodNode.create(context2, TemporalConstants.DATE_UNTIL);
        }

        @Specialization
        protected JSTemporalDurationObject round(JSTemporalDurationObject duration, Object roundToParam, @Cached JSToNumberNode toNumber, @Cached TruffleString.EqualNode equalNode, @Cached TemporalDurationAddNode durationAddNode, @Cached InlinedConditionProfile roundToIsTString, @Cached InlinedConditionProfile relativeToIsZonedDateTime, @Cached ToRelativeTemporalObjectNode toRelativeTemporalObjectNode, @Cached TemporalRoundDurationNode roundDurationNode, @Cached TemporalUnbalanceDateDurationRelativeNode unbalanceDurationRelativeNode, @Cached TemporalBalanceDateDurationRelativeNode balanceDateDurationRelativeNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            TimeDurationRecord balanceResult;
            boolean plainDateTimeOrRelativeToWillBeUsed;
            boolean hoursToDaysConversionMayOccur;
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (roundToIsTString.profile(this, Strings.isTString(roundToParam))) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, JSRuntime.toStringIsString(roundToParam));
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            boolean smallestUnitPresent = true;
            boolean largestUnitPresent = true;
            TemporalUtil.Unit smallestUnit = JSTemporalDurationRound.toSmallestTemporalUnit(roundTo, TemporalUtil.listEmpty, null, equalNode, getOptionNode, this, errorBranch);
            if (smallestUnit == TemporalUtil.Unit.EMPTY) {
                smallestUnitPresent = false;
                smallestUnit = TemporalUtil.Unit.NANOSECOND;
            }
            TemporalUtil.Unit existingLargestUnit = TemporalUtil.defaultTemporalLargestUnit(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds());
            TemporalUtil.Unit defaultLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(existingLargestUnit, smallestUnit);
            TemporalUtil.Unit largestUnit = JSTemporalDurationRound.toLargestTemporalUnit(roundTo, TemporalUtil.listEmpty, null, null, equalNode, getOptionNode, this, errorBranch);
            if (largestUnit == TemporalUtil.Unit.EMPTY) {
                largestUnitPresent = false;
                largestUnit = defaultLargestUnit;
            } else if (TemporalUtil.Unit.AUTO == largestUnit) {
                largestUnit = defaultLargestUnit;
            }
            if (!smallestUnitPresent && !largestUnitPresent) {
                errorBranch.enter(this);
                throw Errors.createRangeError("at least one of smallestUnit or largestUnit is required");
            }
            JSRealm realm = this.getRealm();
            TemporalUtil.validateTemporalUnitRange(largestUnit, smallestUnit);
            TemporalUtil.RoundingMode roundingMode = JSTemporalDurationRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            Double maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
            double roundingIncrement = TemporalUtil.toTemporalRoundingIncrement(roundTo, maximum, false, this.isObjectNode, toNumber);
            ToRelativeTemporalObjectNode.Result relativeToRec = toRelativeTemporalObjectNode.execute(roundTo);
            JSTemporalZonedDateTimeObject zonedRelativeTo = relativeToRec.zonedRelativeTo();
            JSTemporalPlainDateObject plainRelativeTo = relativeToRec.plainRelativeTo();
            TimeZoneMethodsRecord timeZoneRec = relativeToRec.timeZoneRec();
            boolean roundingGranularityIsNoop = smallestUnit == TemporalUtil.Unit.NANOSECOND && roundingIncrement == 1.0;
            boolean calendarUnitsPresent = duration.getYears() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0;
            boolean bl = hoursToDaysConversionMayOccur = duration.getDays() != 0.0 && zonedRelativeTo != null || Math.abs(duration.getHours()) >= 24.0;
            if (roundingGranularityIsNoop && largestUnit == existingLargestUnit && !calendarUnitsPresent && !hoursToDaysConversionMayOccur && Math.abs(duration.getMinutes()) < 60.0 && Math.abs(duration.getSeconds()) < 60.0 && Math.abs(duration.getMilliseconds()) < 1000.0 && Math.abs(duration.getMicroseconds()) < 1000.0 && Math.abs(duration.getNanoseconds()) < 1000.0) {
                return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), this, errorBranch);
            }
            JSTemporalPlainDateTimeObject precalculatedPlainDateTime = null;
            boolean bl2 = plainDateTimeOrRelativeToWillBeUsed = !roundingGranularityIsNoop || largestUnit == TemporalUtil.Unit.YEAR || largestUnit == TemporalUtil.Unit.MONTH || largestUnit == TemporalUtil.Unit.WEEK || largestUnit == TemporalUtil.Unit.DAY || calendarUnitsPresent || duration.getDays() != 0.0;
            if (zonedRelativeTo != null && plainDateTimeOrRelativeToWillBeUsed) {
                JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedRelativeTo.getNanoseconds());
                precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), this.getRealm(), timeZoneRec, instant, zonedRelativeTo.getCalendar());
                plainRelativeTo = JSTemporalPlainDate.create(this.getContext(), realm, precalculatedPlainDateTime.getYear(), precalculatedPlainDateTime.getMonth(), precalculatedPlainDateTime.getDay(), zonedRelativeTo.getCalendar(), this, errorBranch);
            }
            CalendarMethodsRecord calendarRec = relativeToRec.createCalendarMethodsRecord(this.getMethodDateAddNode, this.getMethodDateUntilNode);
            JSTemporalDurationRecord unbalanceResult = unbalanceDurationRelativeNode.execute(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), largestUnit, plainRelativeTo, calendarRec);
            JSTemporalDurationRecord roundResult = roundDurationNode.execute(unbalanceResult.getYears(), unbalanceResult.getMonths(), unbalanceResult.getWeeks(), unbalanceResult.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), (long)roundingIncrement, smallestUnit, roundingMode, plainRelativeTo, zonedRelativeTo, calendarRec, timeZoneRec, precalculatedPlainDateTime);
            if (relativeToIsZonedDateTime.profile(this, zonedRelativeTo != null)) {
                JSTemporalDurationRecord adjustResult = TemporalUtil.adjustRoundedDurationDays(this.getContext(), realm, durationAddNode, roundDurationNode, roundResult.getYears(), roundResult.getMonths(), roundResult.getWeeks(), roundResult.getDays(), roundResult.getHours(), roundResult.getMinutes(), roundResult.getSeconds(), roundResult.getMilliseconds(), roundResult.getMicroseconds(), roundResult.getNanoseconds(), (long)roundingIncrement, smallestUnit, roundingMode, zonedRelativeTo, calendarRec, timeZoneRec, precalculatedPlainDateTime);
                balanceResult = TemporalUtil.balanceTimeDurationRelative(adjustResult.getDays(), adjustResult.getHours(), adjustResult.getMinutes(), adjustResult.getSeconds(), adjustResult.getMilliseconds(), adjustResult.getMicroseconds(), adjustResult.getNanoseconds(), largestUnit, zonedRelativeTo, timeZoneRec, precalculatedPlainDateTime, this.getContext(), realm);
            } else {
                balanceResult = TemporalUtil.balanceTimeDuration(roundResult.getDays(), roundResult.getHours(), roundResult.getMinutes(), roundResult.getSeconds(), roundResult.getMilliseconds(), roundResult.getMicroseconds(), roundResult.getNanoseconds(), largestUnit);
            }
            DateDurationRecord result2 = balanceDateDurationRelativeNode.execute(roundResult.getYears(), roundResult.getMonths(), roundResult.getWeeks(), balanceResult.days(), largestUnit, smallestUnit, plainRelativeTo, calendarRec);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, result2.years(), result2.months(), result2.weeks(), result2.days(), balanceResult.hours(), balanceResult.minutes(), balanceResult.seconds(), balanceResult.milliseconds(), balanceResult.microseconds(), balanceResult.nanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationTotal
    extends JSTemporalBuiltinOperation {
        @Node.Child
        private GetMethodNode getMethodDateAddNode;
        @Node.Child
        private GetMethodNode getMethodDateUntilNode;

        protected JSTemporalDurationTotal(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.getMethodDateAddNode = GetMethodNode.create(context2, TemporalConstants.DATE_ADD);
            this.getMethodDateUntilNode = GetMethodNode.create(context2, TemporalConstants.DATE_UNTIL);
        }

        @Specialization
        protected double total(JSTemporalDurationObject duration, Object totalOfParam, @Cached TruffleString.EqualNode equalNode, @Cached ToRelativeTemporalObjectNode toRelativeTemporalObjectNode, @Cached TemporalRoundDurationNode roundDurationNode, @Cached TemporalUnbalanceDateDurationRelativeNode unbalanceDurationRelativeNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            TimeDurationRecord balanceResult;
            boolean plainDateTimeOrRelativeToWillBeUsed;
            JSDynamicObject totalOf;
            if (totalOfParam == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            JSRealm realm = this.getRealm();
            if (Strings.isTString(totalOfParam)) {
                totalOf = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(totalOf, TemporalConstants.UNIT, JSRuntime.toStringIsString(totalOfParam));
            } else {
                totalOf = this.getOptionsObject(totalOfParam, this, errorBranch, optionUndefined);
            }
            ToRelativeTemporalObjectNode.Result relativeToRec = toRelativeTemporalObjectNode.execute(totalOf);
            JSTemporalZonedDateTimeObject zonedRelativeTo = relativeToRec.zonedRelativeTo();
            JSTemporalPlainDateObject plainRelativeTo = relativeToRec.plainRelativeTo();
            TimeZoneMethodsRecord timeZoneRec = relativeToRec.timeZoneRec();
            TemporalUtil.Unit unit = JSTemporalDurationTotal.toTemporalDurationTotalUnit(totalOf, equalNode, getOptionNode);
            JSTemporalPlainDateTimeObject precalculatedPlainDateTime = null;
            boolean bl = plainDateTimeOrRelativeToWillBeUsed = unit == TemporalUtil.Unit.YEAR || unit == TemporalUtil.Unit.MONTH || unit == TemporalUtil.Unit.WEEK || unit == TemporalUtil.Unit.DAY || duration.getYears() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0;
            if (zonedRelativeTo != null && plainDateTimeOrRelativeToWillBeUsed) {
                JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedRelativeTo.getNanoseconds());
                precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), this.getRealm(), timeZoneRec, instant, zonedRelativeTo.getCalendar());
                plainRelativeTo = JSTemporalPlainDate.create(this.getContext(), realm, precalculatedPlainDateTime.getYear(), precalculatedPlainDateTime.getMonth(), precalculatedPlainDateTime.getDay(), zonedRelativeTo.getCalendar(), this, errorBranch);
            }
            CalendarMethodsRecord calendarRec = relativeToRec.createCalendarMethodsRecord(this.getMethodDateAddNode, this.getMethodDateUntilNode);
            JSTemporalDurationRecord unbalanceResult = unbalanceDurationRelativeNode.execute(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), unit, plainRelativeTo, calendarRec);
            if (zonedRelativeTo != null) {
                JSTemporalZonedDateTimeObject intermediate = TemporalUtil.moveRelativeZonedDateTime(this.getContext(), realm, zonedRelativeTo, calendarRec, timeZoneRec, TemporalUtil.dtol(unbalanceResult.getYears()), TemporalUtil.dtol(unbalanceResult.getMonths()), TemporalUtil.dtol(unbalanceResult.getWeeks()), 0L, precalculatedPlainDateTime);
                balanceResult = TemporalUtil.balancePossiblyInfiniteTimeDurationRelative(unbalanceResult.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), unit, intermediate, timeZoneRec, null, this.getContext(), realm);
            } else {
                balanceResult = TemporalUtil.balancePossiblyInfiniteTimeDuration(unbalanceResult.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), unit);
            }
            if (balanceResult.isOverflow()) {
                return balanceResult.getOverflow();
            }
            JSTemporalDurationRecord roundResult = roundDurationNode.execute(unbalanceResult.getYears(), unbalanceResult.getMonths(), unbalanceResult.getWeeks(), balanceResult.days(), balanceResult.hours(), balanceResult.minutes(), balanceResult.seconds(), balanceResult.milliseconds(), balanceResult.microseconds(), balanceResult.nanoseconds(), 1.0, unit, TemporalUtil.RoundingMode.TRUNC, plainRelativeTo, zonedRelativeTo, calendarRec, timeZoneRec, precalculatedPlainDateTime);
            double whole = 0.0;
            if (unit == TemporalUtil.Unit.YEAR) {
                whole = roundResult.getYears();
            } else if (unit == TemporalUtil.Unit.MONTH) {
                whole = roundResult.getMonths();
            } else if (unit == TemporalUtil.Unit.WEEK) {
                whole = roundResult.getWeeks();
            } else if (unit == TemporalUtil.Unit.DAY) {
                whole = roundResult.getDays();
            } else if (unit == TemporalUtil.Unit.HOUR) {
                whole = roundResult.getHours();
            } else if (unit == TemporalUtil.Unit.MINUTE) {
                whole = roundResult.getMinutes();
            } else if (unit == TemporalUtil.Unit.SECOND) {
                whole = roundResult.getSeconds();
            } else if (unit == TemporalUtil.Unit.MILLISECOND) {
                whole = roundResult.getMilliseconds();
            } else if (unit == TemporalUtil.Unit.MICROSECOND) {
                whole = roundResult.getMicroseconds();
            } else {
                assert (TemporalUtil.Unit.NANOSECOND == unit);
                whole = roundResult.getNanoseconds();
            }
            return whole + roundResult.getRemainder();
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object totalOfParam) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationToLocaleString(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected static TruffleString toString(JSTemporalDurationObject duration, @Cached JSNumberToBigIntNode toBigIntNode) {
            return JSTemporalDuration.temporalDurationToString(TemporalUtil.dtol(duration.getYears()), TemporalUtil.dtol(duration.getMonths()), TemporalUtil.dtol(duration.getWeeks()), TemporalUtil.dtol(duration.getDays()), TemporalUtil.dtol(duration.getHours()), TemporalUtil.dtol(duration.getMinutes()), TemporalUtil.dtol(duration.getSeconds()), TemporalUtil.dtol(duration.getMilliseconds()), TemporalUtil.dtol(duration.getMicroseconds()), TemporalUtil.dtol(duration.getNanoseconds()), TemporalConstants.AUTO, toBigIntNode);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationToString(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalDurationObject dur, Object opt, @Cached JSNumberToBigIntNode toBigIntNode, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalRoundDurationNode roundDurationNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(opt, this, errorBranch, optionUndefined);
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecision(options, toStringNode, getOptionNode, equalNode);
            if (precision.getUnit() == TemporalUtil.Unit.MINUTE) {
                errorBranch.enter(this);
                throw Errors.createRangeError("unexpected precision minute");
            }
            TemporalUtil.RoundingMode roundingMode = JSTemporalDurationToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            JSTemporalDurationRecord result2 = roundDurationNode.execute(dur.getYears(), dur.getMonths(), dur.getWeeks(), dur.getDays(), dur.getHours(), dur.getMinutes(), dur.getSeconds(), dur.getMilliseconds(), dur.getMicroseconds(), dur.getNanoseconds(), (long)precision.getIncrement(), precision.getUnit(), roundingMode);
            return JSTemporalDuration.temporalDurationToString(result2.getYears(), result2.getMonths(), result2.getWeeks(), result2.getDays(), result2.getHours(), result2.getMinutes(), result2.getSeconds(), result2.getMilliseconds(), result2.getMicroseconds(), result2.getNanoseconds(), precision.getPrecision(), toBigIntNode);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object opt) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationValueOf
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationValueOf(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected static Object valueOf(Object thisObj) {
            throw Errors.createTypeError("Not supported.");
        }
    }
}

