/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale.provider;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.colorspace.HCL;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.MapperUtil;
import org.jetbrains.letsPlot.core.plot.builder.scale.GuideMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.HclColorMapperProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorHueMapperProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/HclColorMapperProvider;", "hueRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "chroma", "", "luminance", "startHue", "reversed", "", "naValue", "Lorg/jetbrains/letsPlot/commons/values/Color;", "(Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;DDDZLorg/jetbrains/letsPlot/commons/values/Color;)V", "createContinuousMapper", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/GuideMapper;", "domain", "trans", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "createDiscreteMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nColorHueMapperProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorHueMapperProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorHueMapperProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class ColorHueMapperProvider
extends HclColorMapperProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double chroma;
    private final double luminance;
    private final boolean reversed;
    @NotNull
    private final DoubleSpan hueRange;
    public static final double DEF_CHROMA = 100.0;
    public static final double DEF_LUMINANCE = 65.0;
    public static final double DEF_START_HUE = 0.0;
    @NotNull
    private static final DoubleSpan DEF_HUE_RANGE = new DoubleSpan(15.0, 375.0);

    public ColorHueMapperProvider(@NotNull DoubleSpan hueRange, double chroma, double luminance, double startHue, boolean reversed, @NotNull Color naValue) {
        Intrinsics.checkNotNullParameter((Object)hueRange, (String)"hueRange");
        Intrinsics.checkNotNullParameter((Object)naValue, (String)"naValue");
        super(naValue);
        this.chroma = chroma;
        this.luminance = luminance;
        this.reversed = reversed;
        this.hueRange = new DoubleSpan(hueRange.getLowerEnd() + startHue, hueRange.getUpperEnd() + startHue);
    }

    @Override
    @NotNull
    public ScaleMapper<Color> createDiscreteMapper(@NotNull DiscreteTransform discreteTransform) {
        HCL hCL;
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        int n = discreteTransform.getEffectiveDomain().size();
        DoubleSpan it = doubleSpan = this.hueRange;
        boolean bl = false;
        DoubleSpan doubleSpan2 = !(it.getLength() % (double)360 < 1.0) ? doubleSpan : null;
        if (doubleSpan2 == null) {
            doubleSpan2 = new DoubleSpan(this.hueRange.getLowerEnd(), this.hueRange.getUpperEnd() - 360.0 / (double)n);
        }
        DoubleSpan hueRange = doubleSpan2;
        double step2 = hueRange.getLength() / (double)(n - 1);
        HCL from2 = new HCL(hueRange.getLowerEnd(), this.chroma, this.luminance);
        HCL to = new HCL(hueRange.getLowerEnd() + step2 * (double)(n - 1), this.chroma, this.luminance);
        HCL hCL2 = hCL = from2;
        List<Double> list2 = discreteTransform.getEffectiveDomainTransformed();
        ColorHueMapperProvider colorHueMapperProvider = this;
        boolean bl2 = false;
        boolean bl3 = this.reversed;
        HCL hCL3 = !bl3 ? hCL : null;
        if (hCL3 == null) {
            hCL3 = to;
        }
        HCL it2 = hCL = to;
        HCL hCL4 = hCL3;
        boolean bl4 = false;
        boolean bl5 = this.reversed;
        HCL hCL5 = !bl5 ? hCL : null;
        if (hCL5 == null) {
            hCL5 = from2;
        }
        return colorHueMapperProvider.createDiscreteMapper(list2, hCL4, hCL5);
    }

    @Override
    @NotNull
    public GuideMapper<Color> createContinuousMapper(@NotNull DoubleSpan domain, @NotNull ContinuousTransform trans) {
        HCL hCL;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        DoubleSpan domain2 = MapperUtil.INSTANCE.rangeWithLimitsAfterTransform(domain, trans);
        HCL from2 = new HCL(this.hueRange.getLowerEnd(), this.chroma, this.luminance);
        HCL to = new HCL(this.hueRange.getUpperEnd(), this.chroma, this.luminance);
        HCL hCL2 = hCL = from2;
        DoubleSpan doubleSpan = domain2;
        ColorHueMapperProvider colorHueMapperProvider = this;
        boolean bl = false;
        boolean bl2 = this.reversed;
        HCL hCL3 = !bl2 ? hCL : null;
        if (hCL3 == null) {
            hCL3 = to;
        }
        HCL it = hCL = to;
        HCL hCL4 = hCL3;
        boolean bl3 = false;
        boolean bl4 = this.reversed;
        HCL hCL5 = !bl4 ? hCL : null;
        if (hCL5 == null) {
            hCL5 = from2;
        }
        return colorHueMapperProvider.createContinuousMapper(doubleSpan, hCL4, hCL5);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorHueMapperProvider$Companion;", "", "()V", "DEF_CHROMA", "", "DEF_HUE_RANGE", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "getDEF_HUE_RANGE", "()Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "DEF_LUMINANCE", "DEF_START_HUE", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleSpan getDEF_HUE_RANGE() {
            return DEF_HUE_RANGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

