/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir.cfg;

import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.utils.graph.ControlFlowGraph;
import com.intellij.rml.dfa.utils.graph.GraphBuilder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rml/dfa/ir/cfg/IrCfg;", "", "blocks", "", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "jumps", "", "Lcom/intellij/rml/dfa/ir/cfg/IrJump;", "startBlock", "exitBlock", "<init>", "(Ljava/util/Set;Ljava/util/Map;Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;)V", "getBlocks", "()Ljava/util/Set;", "getJumps", "()Ljava/util/Map;", "getStartBlock", "()Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "getExitBlock", "toControlFlowGraph", "Lcom/intellij/rml/dfa/utils/graph/ControlFlowGraph;", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nIrCfg.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrCfg.kt\ncom/intellij/rml/dfa/ir/cfg/IrCfg\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,80:1\n1863#2,2:81\n216#3,2:83\n*S KotlinDebug\n*F\n+ 1 IrCfg.kt\ncom/intellij/rml/dfa/ir/cfg/IrCfg\n*L\n35#1:81,2\n36#1:83,2\n*E\n"})
public final class IrCfg {
    @NotNull
    private final Set<IrCFGBlock> blocks;
    @NotNull
    private final Map<IrCFGBlock, IrJump> jumps;
    @NotNull
    private final IrCFGBlock startBlock;
    @NotNull
    private final IrCFGBlock exitBlock;

    public IrCfg(@NotNull Set<? extends IrCFGBlock> blocks, @NotNull Map<IrCFGBlock, ? extends IrJump> jumps, @NotNull IrCFGBlock startBlock, @NotNull IrCFGBlock exitBlock) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter(jumps, (String)"jumps");
        Intrinsics.checkNotNullParameter((Object)startBlock, (String)"startBlock");
        Intrinsics.checkNotNullParameter((Object)exitBlock, (String)"exitBlock");
        this.blocks = blocks;
        this.jumps = jumps;
        this.startBlock = startBlock;
        this.exitBlock = exitBlock;
    }

    @NotNull
    public final Set<IrCFGBlock> getBlocks() {
        return this.blocks;
    }

    @NotNull
    public final Map<IrCFGBlock, IrJump> getJumps() {
        return this.jumps;
    }

    @NotNull
    public final IrCFGBlock getStartBlock() {
        return this.startBlock;
    }

    @NotNull
    public final IrCFGBlock getExitBlock() {
        return this.exitBlock;
    }

    @NotNull
    public final ControlFlowGraph<IrCFGBlock> toControlFlowGraph() {
        Object element$iv;
        GraphBuilder<IrCFGBlock> builder2 = new GraphBuilder<IrCFGBlock>();
        Object $this$forEach$iv = this.blocks;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            IrCFGBlock it = (IrCFGBlock)element$iv;
            boolean bl = false;
            builder2.addNode(it);
        }
        $this$forEach$iv = this.jumps;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            IrCFGBlock block = (IrCFGBlock)object.getKey();
            IrJump jump = (IrJump)object.getValue();
            IrJump irJump = jump;
            if (irJump instanceof IrUnconditionalJump) {
                builder2.addEdge(block, ((IrUnconditionalJump)jump).getNextBlock());
                continue;
            }
            if (irJump instanceof IrConditionalJump) {
                builder2.addEdge(block, ((IrConditionalJump)jump).getTrueBranch());
                builder2.addEdge(block, ((IrConditionalJump)jump).getFalseBranch());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return new ControlFlowGraph<IrCFGBlock>(builder2.getGraph(), this.startBlock, this.exitBlock);
    }
}

