/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.core;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.clones.core.CommonUtilsKt;
import com.jetbrains.clones.core.HashInfo;
import com.jetbrains.clones.languagescope.DuplicateScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Use LighterAstNodeHashCache instead")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\nJ\u0014\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/clones/core/LightAstNodeHasher;", "", "scope", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "ast", "Lcom/intellij/lang/LighterAST;", "<init>", "(Lcom/jetbrains/clones/languagescope/DuplicateScope;Lcom/intellij/lang/LighterAST;)V", "cache", "Ljava/util/HashMap;", "Lcom/intellij/lang/LighterASTNode;", "Lcom/jetbrains/clones/core/HashInfo;", "Lkotlin/collections/HashMap;", "getHashInfo", "node", "getRangeInfo", "nodes", "", "computeAndCache", "", "children", "computeAndCacheLeaf", "Lcom/intellij/lang/LighterASTTokenNode;", "computeAndCacheNode", "nodeChildren", "computeLeafHash", "", "intellij.platform.duplicatesDetector"})
@ApiStatus.ScheduledForRemoval
@SourceDebugExtension(value={"SMAP\nLightAstHasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightAstHasher.kt\ncom/jetbrains/clones/core/LightAstNodeHasher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n827#2:69\n855#2,2:70\n1557#2:72\n1628#2,3:73\n1557#2:76\n1628#2,3:77\n1#3:80\n*S KotlinDebug\n*F\n+ 1 LightAstHasher.kt\ncom/jetbrains/clones/core/LightAstNodeHasher\n*L\n22#1:69\n22#1:70,2\n34#1:72\n34#1:73,3\n35#1:76\n35#1:77,3\n*E\n"})
public final class LightAstNodeHasher {
    @NotNull
    private final DuplicateScope scope;
    @NotNull
    private final LighterAST ast;
    @NotNull
    private final HashMap<LighterASTNode, HashInfo> cache;

    public LightAstNodeHasher(@NotNull DuplicateScope scope, @NotNull LighterAST ast) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        this.scope = scope;
        this.ast = ast;
        this.cache = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashInfo getHashInfo(@NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!((Map)this.cache).containsKey(node)) {
            void $this$filterNotTo$iv$iv;
            List list2 = this.ast.getChildren(node);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
            Iterable $this$filterNot$iv = list2;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                LighterASTNode it = (LighterASTNode)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (this.scope.isNoise(this.ast, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List indexedChildren = (List)destination$iv$iv;
            this.computeAndCache(node, indexedChildren);
        }
        HashInfo hashInfo = this.cache.get(node);
        Intrinsics.checkNotNull((Object)hashInfo);
        return hashInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashInfo getRangeInfo(@NotNull List<? extends LighterASTNode> nodes) {
        void $this$mapTo$iv$iv;
        HashInfo it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        if (!(!((Collection)nodes).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (nodes.size() == 1) {
            return this.getHashInfo((LighterASTNode)CollectionsKt.first(nodes));
        }
        Iterable $this$map$iv = nodes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            LighterASTNode lighterASTNode = (LighterASTNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getHashInfo((LighterASTNode)it));
        }
        List hashNodes = (List)destination$iv$iv;
        Iterable $this$map$iv2 = hashNodes;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            HashInfo hashInfo = (HashInfo)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it2.getHash());
        }
        long hash = CommonUtilsKt.longHash((List)destination$iv$iv2);
        Iterable iterable2 = hashNodes;
        int n = 0;
        for (Object t : iterable2) {
            it = (HashInfo)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getWeight();
            n = n2 + n3;
        }
        int weight = n;
        return new HashInfo(hash, weight);
    }

    private final void computeAndCache(LighterASTNode node, List<? extends LighterASTNode> children) {
        if (node instanceof LighterASTTokenNode) {
            this.computeAndCacheLeaf((LighterASTTokenNode)node);
        } else {
            this.computeAndCacheNode(node, children);
        }
    }

    private final void computeAndCacheLeaf(LighterASTTokenNode node) {
        long hash = this.computeLeafHash(node);
        int weight = this.scope.weightOf(this.ast, (LighterASTNode)node);
        HashInfo info = new HashInfo(hash, weight);
        ((Map)this.cache).put(node, info);
    }

    /*
     * WARNING - void declaration
     */
    private final void computeAndCacheNode(LighterASTNode node, List<? extends LighterASTNode> nodeChildren) {
        long hash = this.scope.getNormalizedHash(this, this.ast, node, nodeChildren);
        Iterable iterable = nodeChildren;
        int n = 0;
        for (Object t : iterable) {
            void it;
            LighterASTNode lighterASTNode = (LighterASTNode)t;
            int n2 = n;
            boolean bl = false;
            int n3 = this.getHashInfo((LighterASTNode)it).getWeight();
            n = n2 + n3;
        }
        int weight = n + this.scope.weightOf(this.ast, node);
        HashInfo info = new HashInfo(hash, weight);
        ((Map)this.cache).put(node, info);
    }

    private final long computeLeafHash(LighterASTTokenNode node) {
        long l;
        if (!this.scope.isAnonymized(this.ast, node)) {
            l = node.getText().hashCode();
        } else {
            IElementType iElementType = node.getTokenType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
            l = CommonUtilsKt.hash(iElementType);
        }
        return l;
    }
}

