"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorBoundary = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _react = _interopRequireWildcard(require("react"));
var _bindEventListener = require("bind-event-listener");
var _combine = require("@atlaskit/pragmatic-drag-and-drop/combine");
var _adapter = require("@atlaskit/pragmatic-drag-and-drop/element/adapter");
var _devWarning = require("../dev-warning");
var _cancelDrag = require("./cancel-drag");
var _rbdInvariant = require("./rbd-invariant");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * This component holds the actual error boundary logic.
 */
function ErrorBoundaryInner(_ref) {
  var children = _ref.children,
    dragController = _ref.dragController;
  var isDraggingRef = (0, _react.useRef)(false);
  var handleWindowError = (0, _react.useCallback)(function (event) {
    var dragState = dragController.getDragState();
    if (!dragState.isDragging) {
      return;
    }
    if (dragState.mode === 'FLUID') {
      (0, _cancelDrag.cancelPointerDrag)();
    }
    if (dragState.mode === 'SNAP') {
      dragController.stopDrag({
        reason: 'CANCEL'
      });
    }
    if (process.env.NODE_ENV !== 'production') {
      (0, _devWarning.warning)("\n          An error was caught by our window 'error' event listener while a drag was occurring.\n          The active drag has been aborted.\n        ");
    }
    var err = event.error;
    if (err instanceof _rbdInvariant.RbdInvariant) {
      // Marking the event as dealt with.
      // This will prevent any 'uncaught' error warnings in the console
      event.preventDefault();
      if (process.env.NODE_ENV !== 'production') {
        (0, _devWarning.error)(err.message);
      }
    }
  }, [dragController]);
  (0, _react.useEffect)(function () {
    return (0, _combine.combine)((0, _adapter.monitorForElements)({
      onDragStart: function onDragStart() {
        isDraggingRef.current = true;
      },
      onDrop: function onDrop() {
        isDraggingRef.current = false;
      }
    }),
    // @ts-expect-error - type narrowing isn't working on the error param
    (0, _bindEventListener.bind)(window, {
      type: 'error',
      listener: handleWindowError
    }));
  }, [handleWindowError]);
  return children;
}

/**
 * Cancels drags when errors occur.
 */
// We have to use a class component to create an error boundary
// eslint-disable-next-line @repo/internal/react/no-class-components
var ErrorBoundary = exports.ErrorBoundary = /*#__PURE__*/function (_React$Component) {
  function ErrorBoundary() {
    (0, _classCallCheck2.default)(this, ErrorBoundary);
    return _callSuper(this, ErrorBoundary, arguments);
  }
  (0, _inherits2.default)(ErrorBoundary, _React$Component);
  return (0, _createClass2.default)(ErrorBoundary, [{
    key: "componentDidCatch",
    value: function componentDidCatch(err) {
      if (err instanceof _rbdInvariant.RbdInvariant) {
        if (process.env.NODE_ENV !== 'production') {
          (0, _devWarning.error)(err.message);
        }
        return;
      }

      // throwing error for other error boundaries
      throw err;
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement(ErrorBoundaryInner, {
        contextId: this.props.contextId,
        dragController: this.props.dragController
      }, this.props.children);
    }
  }], [{
    key: "getDerivedStateFromError",
    value: function getDerivedStateFromError() {
      // Intentionally blank, because this method needs to be defined
    }
  }]);
}(_react.default.Component);