/// <reference types="react" />
import type { BackgroundColorToken } from './types';
/**
 * __Surface context__
 *
 * A surface context provides context information on the current background (if set).
 */
export declare const SurfaceContext: import("react").Context<BackgroundColorToken>;
/**
 * __useSurface__
 *
 * Return the current surface. If no parent sets a surface color it falls back to the default surface.
 *
 * @see SurfaceContext
 */
export declare const useSurface: () => BackgroundColorToken;
