/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ml extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ഗ്രീൻവിച്ച് മീൻ സമയം",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "എയ്ക്കർ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "എയ്ക്കർ വേനൽക്കാല സമയം",
               "",
               "എയ്ക്കർ സമയം",
               "",
            };
        final String[] Apia = new String[] {
               "അപിയ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "അപിയ ഡേലൈറ്റ് സമയം",
               "",
               "അപിയ സമയം",
               "",
            };
        final String[] Cook = new String[] {
               "കുക്ക് ദ്വീപുകൾ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "കുക്ക് ദ്വീപുകൾ അർദ്ധ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "കുക്ക് ദ്വീപുകൾ സമയം",
               "",
            };
        final String[] Cuba = new String[] {
               "ക്യൂബ സ്റ്റാൻഡേർഡ് സമയം",
               "CST",
               "ക്യൂബ ഡേലൈറ്റ് സമയം",
               "CDT",
               "ക്യൂബ സമയം",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ഫിജി സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഫിജി ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഫിജി സമയം",
               "",
            };
        final String[] Gulf = new String[] {
               "ഗൾഫ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ഹോഡ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഹോഡ് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഹോഡ് സമയം",
               "",
            };
        final String[] Iran = new String[] {
               "ഇറാൻ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഇറാൻ ഡേലൈറ്റ് സമയം",
               "",
               "ഇറാൻ സമയം",
               "",
            };
        final String[] Niue = new String[] {
               "ന്യൂയി സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ഓംസ്‌ക്ക് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഓംസ്‌ക്ക് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഓംസ്‌ക്ക് സമയം",
               "",
            };
        final String[] Peru = new String[] {
               "പെറു സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "പെറു ഗ്രീഷ്‌മകാല സമയം",
               "",
               "പെറു സമയം",
               "",
            };
        final String[] Truk = new String[] {
               "ചൂക്ക് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "വേക്ക് ദ്വീപ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ചിലി സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ചിലി ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ചിലി സമയം",
               "",
            };
        final String[] China = new String[] {
               "ചൈന സ്റ്റാൻഡേർഡ് സമയം",
               "CST",
               "ചൈന ഡേലൈറ്റ് സമയം",
               "CDT",
               "ചൈന സമയം",
               "CT",
            };
        final String[] Cocos = new String[] {
               "കൊക്കോസ് ദ്വീപുകൾ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ഡേവിസ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ഇന്ത്യൻ സ്റ്റാൻഡേർഡ് സമയം",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ജപ്പാൻ സ്റ്റാൻഡേർഡ് സമയം",
               "JST",
               "ജപ്പാൻ ഡേലൈറ്റ് സമയം",
               "JDT",
               "ജപ്പാൻ സമയം",
               "JT",
            };
        final String[] Korea = new String[] {
               "കൊറിയൻ സ്റ്റാൻഡേർഡ് സമയം",
               "KST",
               "കൊറിയൻ ഡേലൈറ്റ് സമയം",
               "KST",
               "കൊറിയൻ സമയം",
               "KST",
            };
        final String[] Nauru = new String[] {
               "നൗറു സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "നേപ്പാൾ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "പലാവു സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "സമോവ സ്റ്റാൻഡേർഡ് സമയം",
               "SST",
               "സമോവാ ഗ്രീഷ്‌മകാല സമയം",
               "SST",
               "സമോവ സമയം",
               "SST",
            };
        final String[] Syowa = new String[] {
               "സയോവ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ടോംഗ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ടോംഗ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ടോംഗ സമയം",
               "",
            };
        final String[] Yukon = new String[] {
               "യൂക്കോൺ സമയം",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "അലാസ്ക സ്റ്റാൻഡേർഡ് സമയം",
               "AKST",
               "അലാസ്‌ക ഡേലൈറ്റ് സമയം",
               "AKDT",
               "അലാസ്‌ക സമയം",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ആമസോൺ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ആമസോൺ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ആമസോൺ സമയം",
               "",
            };
        final String[] Azores = new String[] {
               "അസോർസ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "അസോർസ് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "അസോർസ് സമയം",
               "",
            };
        final String[] Bhutan = new String[] {
               "ഭൂട്ടാൻ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ബ്രൂണൈ ദാറുസ്സലാം സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ഈസ്റ്റർ ദ്വീപ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഈസ്റ്റർ ദ്വീപ് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഈസ്റ്റർ ദ്വീപ് സമയം",
               "",
            };
        final String[] Guyana = new String[] {
               "ഗയാന സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ഹവായ്-അലൂഷ്യൻ സ്റ്റാൻഡേർഡ് സമയം",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ഇസ്രായേൽ സ്റ്റാൻഡേർഡ് സമയം",
               "IST",
               "ഇസ്രായേൽ ഡേലൈറ്റ് സമയം",
               "IDT",
               "ഇസ്രായേൽ സമയം",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "കൊസ്ര സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "മാസൺ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "മോസ്കോ സ്റ്റാൻഡേർഡ് സമയം",
               "MSK",
               "മോസ്‌കോ ഗ്രീഷ്‌മകാല സമയം",
               "MSK",
               "മോസ്കോ സമയം",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "പൊനാപ്പ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "സമാറ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "സമാറ വേനൽക്കാല സമയം",
               "",
               "സമാര സമയം",
               "",
            };
        final String[] Tahiti = new String[] {
               "താഹിതി സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "തായ്‌പെയ് സ്റ്റാൻഡേർഡ് സമയം",
               "CST",
               "തായ്‌പെയ് ഡേലൈറ്റ് സമയം",
               "CDT",
               "തായ്‌പെയ് സമയം",
               "CT",
            };
        final String[] Turkey = new String[] {
               "തുർക്കി സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "തുർക്കി വേനൽക്കാല സമയം",
               "",
               "തുർക്കി സമയം",
               "",
            };
        final String[] Tuvalu = new String[] {
               "ടുവാലു സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "വോസ്റ്റോക് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "വാലിസ് ആന്റ് ഫ്യൂച്യുന സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "അറേബ്യൻ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "അറേബ്യൻ ഡേലൈറ്റ് സമയം",
               "",
               "അറേബ്യൻ സമയം",
               "",
            };
        final String[] Armenia = new String[] {
               "അർമേനിയ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "അർമേനിയ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "അർമേനിയ സമയം",
               "",
            };
        final String[] Bolivia = new String[] {
               "ബൊളീവിയ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ചാത്തം സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ചാത്തം ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ചാത്തം സമയം",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "കോർഡിനേറ്റഡ് യൂണിവേഴ്‌സൽ സമയം",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ഇക്വഡോർ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ഗാമ്പിയർ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ജോർജ്ജിയ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ജോർജ്ജിയ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ജോർജ്ജിയ സമയം",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ഇർകസ്ക് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഇർകസ്‌ക് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഇർകസ്ക് സമയം",
               "",
            };
        final String[] Magadan = new String[] {
               "മഗാദൻ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "മഗാദൻ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "മഗാദൻ സമയം",
               "",
            };
        final String[] Myanmar = new String[] {
               "മ്യാൻമാർ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "നോർ‌ഫോക്ക് ദ്വീപ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "നോർ‌ഫോക്ക് ദ്വീപ് ഡേലൈറ്റ് സമയം",
               "",
               "നോർ‌ഫോക്ക് ദ്വീപ് സമയം",
               "",
            };
        final String[] Noronha = new String[] {
               "ഫെർണാഡോ ഡി നൊറോൻഹ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഫെർണാഡോ ഡി നൊറോൻഹ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഫെർണാഡോ ഡി നൊറോൻഹ സമയം",
               "",
            };
        final String[] Reunion = new String[] {
               "റീയൂണിയൻ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "റോഥെറ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "സോളമൻ ദ്വീപുകൾ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ടോക്കെലൂ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ഉറുഗ്വേ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഉറുഗ്വേ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഉറുഗ്വേ സമയം",
               "",
            };
        final String[] Vanuatu = new String[] {
               "വന്വാതു സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "വന്വാതു ഗ്രീഷ്‌മകാല സമയം",
               "",
               "വന്വാതു സമയം",
               "",
            };
        final String[] Yakutsk = new String[] {
               "യാകസ്‌ക്ക് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "യാകസ്‌ക്ക് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "യാകസ്‌ക്ക് സമയം",
               "",
            };
        final String[] Atlantic = new String[] {
               "അറ്റ്‌ലാന്റിക് സ്റ്റാൻഡേർഡ് സമയം",
               "AST",
               "അറ്റ്‌ലാന്റിക് ഡേലൈറ്റ് സമയം",
               "AST",
               "അറ്റ്‌ലാന്റിക് സമയം",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ബ്രസീലിയ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ബ്രസീലിയ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ബ്രസീലിയ സമയം",
               "",
            };
        final String[] Chamorro = new String[] {
               "ചമോറോ സ്റ്റാൻഡേർഡ് സമയം",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "കൊളംബിയ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "കൊളംബിയ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "കൊളംബിയ സമയം",
               "",
            };
        final String[] Falkland = new String[] {
               "ഫാക്ക്‌ലാൻഡ് ദ്വീപുകൾ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഫാക്ക്‌ലാൻഡ് ദ്വീപുകൾ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഫാക്ക്‌ലാൻഡ് ദ്വീപുകൾ സമയം",
               "",
            };
        final String[] Malaysia = new String[] {
               "മലേഷ്യ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "മാലിദ്വീപ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ഉലാൻബാത്തർ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഉലാൻബാത്തർ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഉലാൻബാത്തർ സമയം",
               "",
            };
        final String[] Pakistan = new String[] {
               "പാക്കിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം",
               "PKT",
               "പാക്കിസ്ഥാൻ ഗ്രീഷ്‌മകാല സമയം",
               "PKST",
               "പാക്കിസ്ഥാൻ സമയം",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "പരാഗ്വേ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "പരാഗ്വേ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "പരാഗ്വേ സമയം",
               "",
            };
        final String[] Pitcairn = new String[] {
               "പിറ്റ്കേൻ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "സുരിനെയിം സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "അർജന്റീന സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "അർജന്റീന ഗ്രീഷ്‌മകാല സമയം",
               "",
               "അർജന്റീന സമയം",
               "",
            };
        final String[] Christmas = new String[] {
               "ക്രിസ്‌മസ് ദ്വീപ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ഗാലപ്പഗോസ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ഹോങ്കോങ്ങ് സ്റ്റാൻഡേർഡ് സമയം",
               "HKT",
               "ഹോങ്കോങ്ങ് ഗ്രീഷ്‌മകാല സമയം",
               "HKST",
               "ഹോങ്കോങ്ങ് സമയം",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ഇൻഡോചൈന സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി വേനൽക്കാല സമയം",
               "",
               "പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി സമയം",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "കിർഗിസ്ഥാൻ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ലോർഡ് ഹോവ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ലോർഡ് ഹോവ് ഡേലൈറ്റ് സമയം",
               "",
               "ലോർഡ് ഹോവ് സമയം",
               "",
            };
        final String[] Marquesas = new String[] {
               "മർക്കസസ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "മൗറീഷ്യസ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "മൗറീഷ്യസ് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "മൗറീഷ്യസ് സമയം",
               "",
            };
        final String[] Singapore = new String[] {
               "സിംഗപ്പൂർ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "വെനിസ്വേല സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "അസർബൈജാൻ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "അസർബൈജാൻ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "അസർബൈജാൻ സമയം",
               "",
            };
        final String[] Bangladesh = new String[] {
               "ബംഗ്ലാദേശ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ബംഗ്ലാദേശ് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ബംഗ്ലാദേശ് സമയം",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "കേപ് വെർദെ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "കേപ് വെർദെ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "കേപ് വെർദെ സമയം",
               "",
            };
        final String[] East_Timor = new String[] {
               "കിഴക്കൻ തിമോർ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "കസാഖിസ്ഥാൻ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "സീഷെൽസ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "താജിക്കിസ്ഥാൻ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ഉസ്‌ബെക്കിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഉസ്‌ബെക്കിസ്ഥാൻ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ഉസ്‌ബെക്കിസ്ഥാൻ സമയം",
               "",
            };
        final String[] Afghanistan = new String[] {
               "അഫ്‌ഗാനിസ്ഥാൻ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ക്രാസ്‌നോയാർസ്‌ക് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ക്രാസ്‌നോയാർസ്‌ക് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ക്രാസ്‌നോയാർസ്‌ക് സമയം",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ന്യൂസിലാൻഡ് സ്റ്റാൻഡേർഡ് സമയം",
               "NZST",
               "ന്യൂസിലാൻഡ് ഡേലൈറ്റ് സമയം",
               "NZDT",
               "ന്യൂസിലാൻഡ് സമയം",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ഫിലിപ്പൈൻ സ്റ്റാൻഡേർഡ് സമയം",
               "PST",
               "ഫിലിപ്പൈൻ ഗ്രീഷ്‌മകാല സമയം",
               "PDT",
               "ഫിലിപ്പൈൻ സമയം",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "വ്ലാഡിവോസ്റ്റോക് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "വ്ലാഡിവോസ്റ്റോക് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "വ്ലാഡിവോസ്റ്റോക് സമയം",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ഇന്ത്യൻ മഹാസമുദ്ര സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ലൈൻ ദ്വീപുകൾ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ന്യൂഫൗണ്ട്‌ലാന്റ് സ്റ്റാൻഡേർഡ് സമയം",
               "NST",
               "ന്യൂഫൗണ്ട്‌ലാന്റ് ഡേലൈറ്റ് സമയം",
               "NDT",
               "ന്യൂഫൗണ്ട്‌ലാന്റ് സമയം",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "തുർക്ക്‌മെനിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "തുർക്ക്‌മെനിസ്ഥാൻ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "തുർക്ക്‌മെനിസ്ഥാൻ സമയം",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ഫ്രഞ്ച് ഗയാന സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ന്യൂ കാലിഡോണിയ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ന്യൂ കാലിഡോണിയ ഗ്രീഷ്‌മകാല സമയം",
               "",
               "ന്യൂ കാലിഡോണിയ സമയം",
               "",
            };
        final String[] South_Georgia = new String[] {
               "ദക്ഷിണ ജോർജ്ജിയൻ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "യെക്കാറ്റരിൻബർഗ് സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "യെക്കാറ്റരിൻബർഗ് ഗ്രീഷ്‌മകാല സമയം",
               "",
               "യെക്കാറ്റരിൻബർഗ് സമയം",
               "",
            };
        final String[] Africa_Central = new String[] {
               "മധ്യ ആഫ്രിക്ക സമയം",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "കിഴക്കൻ ആഫ്രിക്ക സമയം",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "പടിഞ്ഞാറൻ ആഫ്രിക്ക സമയം",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ഡുമോണ്ട് ഡി ഉർവില്ലെ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "സെൻട്രൽ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം",
               "CET",
               "സെൻട്രൽ യൂറോപ്യൻ ഗ്രീഷ്മകാല സമയം",
               "CEST",
               "സെൻട്രൽ യൂറോപ്യൻ സമയം",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "കിഴക്കൻ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം",
               "EET",
               "കിഴക്കൻ യൂറോപ്യൻ ഗ്രീഷ്മകാല സമയം",
               "EEST",
               "കിഴക്കൻ യൂറോപ്യൻ സമയം",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "പടിഞ്ഞാറൻ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം",
               "WET",
               "പടിഞ്ഞാറൻ യൂറോപ്യൻ ഗ്രീഷ്‌മകാല സമയം",
               "WEST",
               "പടിഞ്ഞാറൻ യൂറോപ്യൻ സമയം",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "മെക്‌സിക്കൻ പസഫിക് സ്റ്റാൻഡേർഡ് സമയം",
               "MST",
               "മെക്സിക്കൻ പസഫിക് ഡേലൈറ്റ് സമയം",
               "MDT",
               "മെക്സിക്കൻ പസഫിക് സമയം",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "ദക്ഷിണാഫ്രിക്ക സ്റ്റാൻഡേർഡ് സമയം",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "സെൻട്രൽ സ്റ്റാൻഡേർഡ് സമയം",
               "CST",
               "സെൻട്രൽ ഡേലൈറ്റ് സമയം",
               "CDT",
               "സെൻട്രൽ സമയം",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ഈസ്റ്റേൺ സ്റ്റാൻഡേർഡ് സമയം",
               "EST",
               "ഈസ്റ്റേൺ ഡേലൈറ്റ് സമയം",
               "EST",
               "ഈസ്റ്റേൺ സമയം",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "പസഫിക് സ്റ്റാൻഡേർഡ് സമയം",
               "PST",
               "പസഫിക് ഡേലൈറ്റ് സമയം",
               "PDT",
               "വടക്കെ അമേരിക്കൻ പസഫിക് സമയം",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ഫ്രഞ്ച് സതേൺ, അന്റാർട്ടിക് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ഗിൽബേർട്ട് ദ്വീപുകൾ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ഹവായ്-അലൂഷ്യൻ സ്റ്റാൻഡേർഡ് സമയം",
               "HST",
               "ഹവായ്-അലൂഷ്യൻ ഡേലൈറ്റ് സമയം",
               "HDT",
               "ഹവായ്-അലൂഷ്യൻ സമയം",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ഫിനിക്‌സ് ദ്വീപ് സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "സെന്റ് പിയറി ആൻഡ് മിക്വലൻ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "സെന്റ് പിയറി ആൻഡ് മിക്വലൻ ഡേലൈറ്റ് സമയം",
               "",
               "സെന്റ് പിയറി ആൻഡ് മിക്വലൻ സമയം",
               "",
            };
        final String[] America_Mountain = new String[] {
               "മൗണ്ടൻ സ്റ്റാൻഡേർഡ് സമയം",
               "MST",
               "മൗണ്ടൻ ഡേലൈറ്റ് സമയം",
               "MST",
               "മൗണ്ടൻ സമയം",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "മാർഷൽ ദ്വീപുകൾ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "പാപ്പുവ ന്യൂ ഗിനിയ സമയം",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ഓസ്ട്രേലിയൻ സെൻട്രൽ സ്റ്റാൻഡേർഡ് സമയം",
               "ACST",
               "ഓസ്ട്രേലിയൻ സെൻട്രൽ ഡേലൈറ്റ് സമയം",
               "ACDT",
               "സെൻട്രൽ ഓസ്ട്രേലിയ സമയം",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ഓസ്‌ട്രേലിയൻ കിഴക്കൻ സ്റ്റാൻഡേർഡ് സമയം",
               "AEST",
               "ഓസ്‌ട്രേലിയൻ കിഴക്കൻ ഡേലൈറ്റ് സമയം",
               "AEDT",
               "കിഴക്കൻ ഓസ്‌ട്രേലിയ സമയം",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ഓസ്‌ട്രേലിയൻ പടിഞ്ഞാറൻ സ്റ്റാൻഡേർഡ് സമയം",
               "AWST",
               "ഓസ്‌ട്രേലിയൻ പടിഞ്ഞാറൻ ഡേലൈറ്റ് സമയം",
               "AWDT",
               "പടിഞ്ഞാറൻ ഓസ്‌ട്രേലിയ സമയം",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "മധ്യ ഇന്തോനേഷ്യ സമയം",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "കിഴക്കൻ ഇന്തോനേഷ്യ സമയം",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "പടിഞ്ഞാറൻ ഇന്തോനേഷ്യ സമയം",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ഓസ്ട്രേലിയൻ സെൻട്രൽ പടിഞ്ഞാറൻ സ്റ്റാൻഡേർഡ് സമയം",
               "",
               "ഓസ്ട്രേലിയൻ സെൻട്രൽ പടിഞ്ഞാറൻ ഡേലൈറ്റ് സമയം",
               "",
               "ഓസ്ട്രേലിയൻ സെൻട്രൽ പടിഞ്ഞാറൻ സമയം",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ബ്രിട്ടീഷ് ഗ്രീഷ്‌മകാല സമയം",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "കോർഡിനേറ്റഡ് യൂണിവേഴ്‌സൽ സമയം",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ഐറിഷ് സ്റ്റാൻഡേർഡ് സമയം",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "കോർഡിനേറ്റഡ് യൂണിവേഴ്‌സൽ സമയം",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "കോർഡിനേറ്റഡ് യൂണിവേഴ്‌സൽ സമയം",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ബ്രിട്ടീഷ് ഗ്രീഷ്‌മകാല സമയം",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "കോർഡിനേറ്റഡ് യൂണിവേഴ്‌സൽ സമയം",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "കോർഡിനേറ്റഡ് യൂണിവേഴ്‌സൽ സമയം",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "കോർഡിനേറ്റഡ് യൂണിവേഴ്‌സൽ സമയം",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ഐറിഷ് സ്റ്റാൻഡേർഡ് സമയം",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ബ്രിട്ടീഷ് ഗ്രീഷ്‌മകാല സമയം",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ബ്രിട്ടീഷ് ഗ്രീഷ്‌മകാല സമയം",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ബ്രിട്ടീഷ് ഗ്രീഷ്‌മകാല സമയം",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ബ്രിട്ടീഷ് ഗ്രീഷ്‌മകാല സമയം",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ഗ്രീൻവിച്ച് മീൻ സമയം",
                    "GMT",
                    "ബ്രിട്ടീഷ് ഗ്രീഷ്‌മകാല സമയം",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ഏദെൻ" },
            { "timezone.excity.Asia/Baku", "ബാക്കു" },
            { "timezone.excity.Asia/Dili", "ദിലി" },
            { "timezone.excity.Asia/Gaza", "ഗാസ" },
            { "timezone.excity.Asia/Hovd", "ഹോഡ്" },
            { "timezone.excity.Asia/Omsk", "ഒംസ്ക്" },
            { "timezone.excity.Asia/Oral", "ഓറൽ" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "അമ്മാൻ‌" },
            { "timezone.excity.Asia/Aqtau", "അക്തൗ" },
            { "timezone.excity.Asia/Chita", "ചീറ്റ" },
            { "timezone.excity.Asia/Dhaka", "ധാക്ക" },
            { "timezone.excity.Asia/Dubai", "ദുബായ്" },
            { "timezone.excity.Asia/Kabul", "കാബൂൾ" },
            { "timezone.excity.Asia/Macau", "മക്കാവു" },
            { "timezone.excity.Asia/Qatar", "ഖത്തർ" },
            { "timezone.excity.Asia/Seoul", "സോൾ" },
            { "timezone.excity.Asia/Tokyo", "ടോക്കിയോ" },
            { "timezone.excity.Asia/Tomsk", "ടോംസ്ക്" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ജുബ" },
            { "timezone.excity.Africa/Lome", "ലോം" },
            { "timezone.excity.Asia/Almaty", "അൽമാട്ടി" },
            { "timezone.excity.Asia/Anadyr", "അനാഡിർ" },
            { "timezone.excity.Asia/Aqtobe", "അഖ്‌തോബ്" },
            { "timezone.excity.Asia/Atyrau", "അറ്റിറോ" },
            { "timezone.excity.Asia/Beirut", "ബെയ്‌റൂട്ട്" },
            { "timezone.excity.Asia/Brunei", "ബ്രൂണൈ" },
            { "timezone.excity.Asia/Hebron", "ഹെബ്‌റോൺ" },
            { "timezone.excity.Asia/Kuwait", "കുവൈത്ത്" },
            { "timezone.excity.Asia/Manila", "മനില" },
            { "timezone.excity.Asia/Muscat", "മസ്കറ്റ്" },
            { "timezone.excity.Asia/Riyadh", "റിയാദ്" },
            { "timezone.excity.Asia/Saigon", "ഹോ ചി മിൻ സിറ്റി" },
            { "timezone.excity.Asia/Taipei", "തായ്‌പെയ്" },
            { "timezone.excity.Asia/Tehran", "ടെഹ്‌റാൻ‌" },
            { "timezone.excity.Asia/Urumqi", "ഉറുംഖി" },
            { "timezone.excity.Etc/Unknown", "അജ്ഞാത നഗരം" },
            { "timezone.excity.Europe/Kiev", "കീവ്" },
            { "timezone.excity.Europe/Oslo", "ഓസ്ലോ" },
            { "timezone.excity.Europe/Riga", "റിഗ" },
            { "timezone.excity.Europe/Rome", "റോം" },
            { "timezone.excity.Indian/Mahe", "മാഹി" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ആക്ര" },
            { "timezone.excity.Africa/Cairo", "കെയ്‌റോ" },
            { "timezone.excity.Africa/Ceuta", "ക്യൂട്ട" },
            { "timezone.excity.Africa/Dakar", "ഡാക്കർ‌" },
            { "timezone.excity.Africa/Lagos", "ലാഗോസ്" },
            { "timezone.excity.Africa/Tunis", "ട്യൂണിസ്" },
            { "timezone.excity.America/Adak", "അഡാക്" },
            { "timezone.excity.America/Lima", "ലിമ" },
            { "timezone.excity.America/Nome", "നോം" },
            { "timezone.excity.Asia/Baghdad", "ബാഗ്‌ദാദ്" },
            { "timezone.excity.Asia/Bahrain", "ബഹ്റിൻ" },
            { "timezone.excity.Asia/Bangkok", "ബാങ്കോക്ക്" },
            { "timezone.excity.Asia/Barnaul", "ബർണോൽ" },
            { "timezone.excity.Asia/Bishkek", "ബിഷ്‌കേക്" },
            { "timezone.excity.Asia/Colombo", "കൊളം‌ബോ" },
            { "timezone.excity.Asia/Irkutsk", "ഇർകസ്ക്" },
            { "timezone.excity.Asia/Jakarta", "ജക്കാർത്ത" },
            { "timezone.excity.Asia/Karachi", "കറാച്ചി" },
            { "timezone.excity.Asia/Kuching", "കുചിങ്" },
            { "timezone.excity.Asia/Magadan", "മഗഡാൻ" },
            { "timezone.excity.Asia/Nicosia", "നിക്കോഷ്യ" },
            { "timezone.excity.Asia/Rangoon", "റങ്കൂൺ‌" },
            { "timezone.excity.Asia/Tbilisi", "തിബിലിസി" },
            { "timezone.excity.Asia/Thimphu", "തിംഫു" },
            { "timezone.excity.Asia/Yakutsk", "യാക്കറ്റ്സ്‌ക്" },
            { "timezone.excity.Asia/Yerevan", "യേരവൻ‌" },
            { "timezone.excity.Europe/Kirov", "കിറോ" },
            { "timezone.excity.Europe/Malta", "മാൾട്ട" },
            { "timezone.excity.Europe/Minsk", "മിൻ‌സ്ക്" },
            { "timezone.excity.Europe/Paris", "പാരീസ്" },
            { "timezone.excity.Europe/Sofia", "സോഫിയ" },
            { "timezone.excity.Europe/Vaduz", "വാദുസ്" },
            { "timezone.excity.Indian/Cocos", "കോക്കോസ്" },
            { "timezone.excity.Pacific/Apia", "ആപിയ" },
            { "timezone.excity.Pacific/Fiji", "ഫിജി" },
            { "timezone.excity.Pacific/Guam", "ഗ്വാം" },
            { "timezone.excity.Pacific/Niue", "നിയു" },
            { "timezone.excity.Pacific/Truk", "ചക്" },
            { "timezone.excity.Pacific/Wake", "വെയ്ക്" },
            { "timezone.excity.Africa/Asmera", "അസ്‍മാര" },
            { "timezone.excity.Africa/Bamako", "ബമാകോ" },
            { "timezone.excity.Africa/Bangui", "ബംഗുയി" },
            { "timezone.excity.Africa/Banjul", "ബഞ്ചുൽ" },
            { "timezone.excity.Africa/Bissau", "ബിസ്സാവു" },
            { "timezone.excity.Africa/Douala", "ഡൗല" },
            { "timezone.excity.Africa/Harare", "ഹരാരെ" },
            { "timezone.excity.Africa/Kigali", "കിഗാലി" },
            { "timezone.excity.Africa/Luanda", "ലുവാൻഡ" },
            { "timezone.excity.Africa/Lusaka", "ലുസാക" },
            { "timezone.excity.Africa/Malabo", "മലാബോ" },
            { "timezone.excity.Africa/Maputo", "മാപ്യുട്ടോ" },
            { "timezone.excity.Africa/Maseru", "മസേറു" },
            { "timezone.excity.Africa/Niamey", "നിയാമി" },
            { "timezone.excity.America/Aruba", "അറൂബ" },
            { "timezone.excity.America/Bahia", "ബഹിയ" },
            { "timezone.excity.America/Belem", "ബെലം" },
            { "timezone.excity.America/Boise", "ബൊയ്സി" },
            { "timezone.excity.America/Jujuy", "ജുജുയ്" },
            { "timezone.excity.America/Sitka", "സിറ്റ്‌കാ" },
            { "timezone.excity.America/Thule", "തൂളി" },
            { "timezone.excity.Asia/Ashgabat", "ആഷ്‌ഗാബട്ട്" },
            { "timezone.excity.Asia/Calcutta", "കൊൽ‌ക്കത്ത" },
            { "timezone.excity.Asia/Damascus", "ദമാസ്കസ്" },
            { "timezone.excity.Asia/Dushanbe", "ദുഷൻ‌ബെ" },
            { "timezone.excity.Asia/Jayapura", "ജയപുര" },
            { "timezone.excity.Asia/Katmandu", "കാഠ്‌മണ്ഡു" },
            { "timezone.excity.Asia/Khandyga", "കാൻഡിഗ" },
            { "timezone.excity.Asia/Makassar", "മകസ്സർ" },
            { "timezone.excity.Asia/Qostanay", "കോസ്റ്റനേ" },
            { "timezone.excity.Asia/Sakhalin", "സഖാലിൻ" },
            { "timezone.excity.Asia/Shanghai", "ഷാങ്‌ഹായി" },
            { "timezone.excity.Asia/Tashkent", "താഷ്‌ക്കന്റ്" },
            { "timezone.excity.Asia/Ust-Nera", "യുസ്-നേര" },
            { "timezone.excity.Europe/Athens", "ഏതൻ‌സ്" },
            { "timezone.excity.Europe/Berlin", "ബെർ‌ലിൻ‌" },
            { "timezone.excity.Europe/Dublin", "ഡബ്ലിൻ" },
            { "timezone.excity.Europe/Jersey", "ജേഴ്‌സി" },
            { "timezone.excity.Europe/Lisbon", "ലിസ്‌ബൺ‌" },
            { "timezone.excity.Europe/London", "ലണ്ടൻ‌" },
            { "timezone.excity.Europe/Madrid", "മാഡ്രിഡ്" },
            { "timezone.excity.Europe/Monaco", "മൊണാക്കോ" },
            { "timezone.excity.Europe/Moscow", "മോസ്കോ" },
            { "timezone.excity.Europe/Prague", "പ്രാഗ്" },
            { "timezone.excity.Europe/Samara", "സമാറ" },
            { "timezone.excity.Europe/Skopje", "സ്കോപ്പിയെ" },
            { "timezone.excity.Europe/Tirane", "ടിരാനെ" },
            { "timezone.excity.Europe/Vienna", "വിയന്ന" },
            { "timezone.excity.Europe/Warsaw", "വാർസോ" },
            { "timezone.excity.Europe/Zagreb", "സാക്രെബ്" },
            { "timezone.excity.Europe/Zurich", "സൂറിച്ച്" },
            { "timezone.excity.Indian/Chagos", "ചാഗോസ്" },
            { "timezone.excity.Indian/Comoro", "കൊമോറോ" },
            { "timezone.excity.Pacific/Efate", "ഇഫാതെ" },
            { "timezone.excity.Pacific/Nauru", "നൗറു" },
            { "timezone.excity.Pacific/Palau", "പലാവു" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "അബിദ്‌ജാൻ‌" },
            { "timezone.excity.Africa/Algiers", "അൾജിയേഴ്‌സ്" },
            { "timezone.excity.Africa/Conakry", "കൊണാക്രി" },
            { "timezone.excity.Africa/Kampala", "കമ്പാല" },
            { "timezone.excity.Africa/Mbabane", "മബാബെയ്‌ൻ‌" },
            { "timezone.excity.Africa/Nairobi", "നയ്‌റോബി" },
            { "timezone.excity.Africa/Tripoli", "ട്രിപൊളി" },
            { "timezone.excity.America/Belize", "ബെലീസ്" },
            { "timezone.excity.America/Bogota", "ബൊഗോട്ട" },
            { "timezone.excity.America/Cancun", "കാൻകൂൺ" },
            { "timezone.excity.America/Cayman", "കേമാൻ" },
            { "timezone.excity.America/Cuiaba", "കുയ്‌ബ" },
            { "timezone.excity.America/Dawson", "ഡോവ്സൺ" },
            { "timezone.excity.America/Denver", "ഡെൻ‌വർ" },
            { "timezone.excity.America/Guyana", "ഗയാന" },
            { "timezone.excity.America/Havana", "ഹവാന" },
            { "timezone.excity.America/Inuvik", "ഇനുവിക്" },
            { "timezone.excity.America/Juneau", "ജൂനോ" },
            { "timezone.excity.America/La_Paz", "ലാ പാസ്" },
            { "timezone.excity.America/Maceio", "മാസിയോ" },
            { "timezone.excity.America/Manaus", "മനൗസ്" },
            { "timezone.excity.America/Merida", "മെരിഡ" },
            { "timezone.excity.America/Nassau", "നാസൗ" },
            { "timezone.excity.America/Panama", "പനാമ" },
            { "timezone.excity.America/Recife", "റെസീഫെ" },
            { "timezone.excity.America/Regina", "റിജീന" },
            { "timezone.excity.Asia/Famagusta", "ഫാമഗുസ്‌റ്റ" },
            { "timezone.excity.Asia/Hong_Kong", "ഹോങ്കോംഗ്" },
            { "timezone.excity.Asia/Jerusalem", "ജെറുസലേം" },
            { "timezone.excity.Asia/Kamchatka", "കാംചട്ക" },
            { "timezone.excity.Asia/Pontianak", "പൊന്റിയാനക്" },
            { "timezone.excity.Asia/Pyongyang", "പ്യോംഗ്‌യാംഗ്" },
            { "timezone.excity.Asia/Qyzylorda", "ഖിസിലോർഡ" },
            { "timezone.excity.Asia/Samarkand", "സമർക്കന്ദ്" },
            { "timezone.excity.Asia/Singapore", "സിംഗപ്പൂർ" },
            { "timezone.excity.Asia/Vientiane", "വെന്റിയാൻ" },
            { "timezone.excity.Europe/Andorra", "അണ്ടോറ" },
            { "timezone.excity.Europe/Saratov", "സരാറ്റോവ്" },
            { "timezone.excity.Europe/Tallinn", "ടാലിൻ‌" },
            { "timezone.excity.Europe/Vatican", "വത്തിക്കാൻ" },
            { "timezone.excity.Europe/Vilnius", "വിൽ‌നിയസ്" },
            { "timezone.excity.Indian/Mayotte", "മയോട്ടി" },
            { "timezone.excity.Indian/Reunion", "റീയൂണിയൻ" },
            { "timezone.excity.Pacific/Easter", "ഈസ്റ്റർ" },
            { "timezone.excity.Pacific/Kosrae", "കൊസ്രേ" },
            { "timezone.excity.Pacific/Majuro", "മജൂറോ" },
            { "timezone.excity.Pacific/Midway", "മിഡ്‌വേ" },
            { "timezone.excity.Pacific/Noumea", "നോമിയ" },
            { "timezone.excity.Pacific/Ponape", "പോൺപെ" },
            { "timezone.excity.Pacific/Saipan", "സെയ്‌പ്പാൻ‌" },
            { "timezone.excity.Pacific/Tahiti", "താഹിതി" },
            { "timezone.excity.Pacific/Tarawa", "തരാവ" },
            { "timezone.excity.Pacific/Wallis", "വാല്ലിസ്" },
            { "timezone.excity.Africa/Blantyre", "ബ്ലാണ്ടെയർ‌" },
            { "timezone.excity.Africa/Djibouti", "ദിജിബൗട്ടി" },
            { "timezone.excity.Africa/El_Aaiun", "എൽ‌ ഐയുൻ‌" },
            { "timezone.excity.Africa/Freetown", "ഫ്രീടൗൺ" },
            { "timezone.excity.Africa/Gaborone", "ഗാബറോൺ" },
            { "timezone.excity.Africa/Khartoum", "ഖാർ‌തൌം" },
            { "timezone.excity.Africa/Kinshasa", "കിൻഷാസ" },
            { "timezone.excity.Africa/Monrovia", "മൺ‌റോവിയ" },
            { "timezone.excity.Africa/Ndjamena", "ജമെന" },
            { "timezone.excity.Africa/Sao_Tome", "സാവോ ടോം‌" },
            { "timezone.excity.Africa/Windhoek", "വിൻഡ്‌ഹോക്" },
            { "timezone.excity.America/Antigua", "ആൻറിഗ്വ" },
            { "timezone.excity.America/Caracas", "കരാക്കസ്" },
            { "timezone.excity.America/Cayenne", "കയീൻ‌" },
            { "timezone.excity.America/Chicago", "ചിക്കാഗോ" },
            { "timezone.excity.America/Cordoba", "കോർഡോബ" },
            { "timezone.excity.America/Creston", "ക്രെസ്റ്റൺ" },
            { "timezone.excity.America/Curacao", "കുറാക്കാവോ" },
            { "timezone.excity.America/Detroit", "ഡെട്രോയിറ്റ്" },
            { "timezone.excity.America/Godthab", "നൂക്ക്" },
            { "timezone.excity.America/Grenada", "ഗ്രനേഡ" },
            { "timezone.excity.America/Halifax", "ഹാലിഫാക്സ്" },
            { "timezone.excity.America/Iqaluit", "ഇഖാലിത്" },
            { "timezone.excity.America/Jamaica", "ജമൈക്ക" },
            { "timezone.excity.America/Managua", "മനാഗ്വ" },
            { "timezone.excity.America/Marigot", "മാരിഗോ" },
            { "timezone.excity.America/Mendoza", "മെൻഡോസ" },
            { "timezone.excity.America/Moncton", "മോംഗ്‌ടൻ" },
            { "timezone.excity.America/Noronha", "നൊറോന" },
            { "timezone.excity.America/Ojinaga", "ഒജിൻഗ" },
            { "timezone.excity.America/Phoenix", "ഫീനിക്സ്" },
            { "timezone.excity.America/Tijuana", "തിയുവാന" },
            { "timezone.excity.America/Toronto", "ടൊറന്റോ" },
            { "timezone.excity.America/Tortola", "ടോർ‌ട്ടോള" },
            { "timezone.excity.America/Yakutat", "യാകുറ്റാറ്റ്" },
            { "timezone.excity.Asia/Phnom_Penh", "ഫെനോം പെൻ" },
            { "timezone.excity.Atlantic/Azores", "അസോറസ്" },
            { "timezone.excity.Atlantic/Canary", "ക്യാനറി" },
            { "timezone.excity.Atlantic/Faeroe", "ഫെറോ" },
            { "timezone.excity.Australia/Eucla", "യൂക്ല" },
            { "timezone.excity.Australia/Perth", "പെർത്ത്" },
            { "timezone.excity.Europe/Belgrade", "ബെൽഗ്രേഡ്" },
            { "timezone.excity.Europe/Brussels", "ബ്രസ്സൽ‌സ്" },
            { "timezone.excity.Europe/Budapest", "ബുഡാപെസ്റ്റ്" },
            { "timezone.excity.Europe/Busingen", "ബുസിൻജൻ" },
            { "timezone.excity.Europe/Chisinau", "ചിസിനാവു" },
            { "timezone.excity.Europe/Guernsey", "ഗേൺസേ" },
            { "timezone.excity.Europe/Helsinki", "ഹെൽ‌സിങ്കി" },
            { "timezone.excity.Europe/Istanbul", "ഇസ്താം‌ബുൾ‌" },
            { "timezone.excity.Europe/Sarajevo", "സരയേവോ" },
            { "timezone.excity.Indian/Maldives", "മാലിദ്വീപ്" },
            { "timezone.excity.Pacific/Chatham", "ചാത്തം" },
            { "timezone.excity.Pacific/Fakaofo", "ഫക്കാവോഫോ" },
            { "timezone.excity.Pacific/Gambier", "ഗാമ്പിയർ" },
            { "timezone.excity.Pacific/Norfolk", "നോർ‌ഫോക്ക്" },
            { "timezone.excity.Africa/Bujumbura", "ബുജും‌ബുര" },
            { "timezone.excity.Africa/Mogadishu", "മൊഗാദിഷു" },
            { "timezone.excity.America/Anguilla", "ആൻഗ്വില്ല" },
            { "timezone.excity.America/Asuncion", "അസൻ‌ഷ്യൻ‌" },
            { "timezone.excity.America/Barbados", "ബാർബഡോസ്" },
            { "timezone.excity.America/Dominica", "ഡൊമിനിക്ക" },
            { "timezone.excity.America/Edmonton", "എഡ്മോൺടൺ" },
            { "timezone.excity.America/Eirunepe", "യെറുനീപ്പെ" },
            { "timezone.excity.America/Mazatlan", "മസറ്റ്‌ലാൻ" },
            { "timezone.excity.America/Miquelon", "മിക്വലൻ" },
            { "timezone.excity.America/New_York", "ന്യൂയോർക്ക്" },
            { "timezone.excity.America/Resolute", "റെസല്യൂട്ട്" },
            { "timezone.excity.America/Santarem", "സാന്ററെം" },
            { "timezone.excity.America/Santiago", "സാന്റിയാഗോ" },
            { "timezone.excity.America/St_Johns", "സെന്റ് ജോൺസ്" },
            { "timezone.excity.America/St_Kitts", "സെന്റ് കിറ്റ്സ്" },
            { "timezone.excity.America/St_Lucia", "സെന്റ് ലൂസിയ" },
            { "timezone.excity.America/Winnipeg", "വിന്നിപെഗ്" },
            { "timezone.excity.Antarctica/Casey", "കാസെ" },
            { "timezone.excity.Antarctica/Davis", "ഡെയ്‌വിസ്" },
            { "timezone.excity.Antarctica/Syowa", "സ്യോവ" },
            { "timezone.excity.Antarctica/Troll", "ട്രോൾ" },
            { "timezone.excity.Asia/Krasnoyarsk", "ക്രാസ്നോയാസ്ക്" },
            { "timezone.excity.Asia/Novosibirsk", "നൊവോസിബിർസ്ക്" },
            { "timezone.excity.Asia/Ulaanbaatar", "ഉലാൻബാത്തർ" },
            { "timezone.excity.Asia/Vladivostok", "വ്ളാഡിവോസ്റ്റോക്" },
            { "timezone.excity.Atlantic/Bermuda", "ബർമുഡ" },
            { "timezone.excity.Atlantic/Madeira", "മഡെയ്റ" },
            { "timezone.excity.Atlantic/Stanley", "സ്റ്റാൻ‌ലി" },
            { "timezone.excity.Australia/Darwin", "ഡാർവിൻ" },
            { "timezone.excity.Australia/Hobart", "ഹൊബാർട്ട്" },
            { "timezone.excity.Australia/Sydney", "സിഡ്നി" },
            { "timezone.excity.Europe/Amsterdam", "ആം‌സ്റ്റർ‌ഡാം" },
            { "timezone.excity.Europe/Astrakhan", "അസ്‌ട്രഖാൻ" },
            { "timezone.excity.Europe/Bucharest", "ബുച്ചാറെസ്റ്റ്" },
            { "timezone.excity.Europe/Gibraltar", "ജിബ്രാൾട്ടർ" },
            { "timezone.excity.Europe/Ljubljana", "ലുബ്‍ലിയാന" },
            { "timezone.excity.Europe/Mariehamn", "മരിയാഹാമൻ" },
            { "timezone.excity.Europe/Podgorica", "പൊഡ്‍ഗൊറിസ" },
            { "timezone.excity.Europe/Stockholm", "സ്റ്റോക്ക്ഹോം" },
            { "timezone.excity.Europe/Ulyanovsk", "ഉല്ല്യാനോവ്‌സ്‌ക്" },
            { "timezone.excity.Europe/Volgograd", "വോൾഗോഗ്രാഡ്" },
            { "timezone.excity.Indian/Christmas", "ക്രിസ്തുമസ്" },
            { "timezone.excity.Indian/Kerguelen", "കെർഗുലെൻ" },
            { "timezone.excity.Indian/Mauritius", "മൗറീഷ്യസ്" },
            { "timezone.excity.Pacific/Auckland", "ഓക്ക്‌ലാന്റ്" },
            { "timezone.excity.Pacific/Funafuti", "ഫുണാഫുട്ടി" },
            { "timezone.excity.Pacific/Honolulu", "ഹോണലൂലു" },
            { "timezone.excity.Pacific/Pitcairn", "പിറ്റ്കയിൻ‌" },
            { "timezone.excity.Africa/Casablanca", "കാസബ്ലാങ്ക" },
            { "timezone.excity.Africa/Libreville", "ലിബ്രെവില്ല" },
            { "timezone.excity.Africa/Lubumbashi", "ലൂബുംബാഷി" },
            { "timezone.excity.Africa/Nouakchott", "നൗവാക്‌ഷോട്ട്" },
            { "timezone.excity.Africa/Porto-Novo", "പോർ‌ട്ടോ-നോവോ" },
            { "timezone.excity.America/Anchorage", "ആങ്കറേജ്" },
            { "timezone.excity.America/Araguaina", "അറഗ്വൈന" },
            { "timezone.excity.America/Boa_Vista", "ബോവ വിസ്റ്റ" },
            { "timezone.excity.America/Catamarca", "‍ക്യാറ്റമാർക്ക" },
            { "timezone.excity.America/Chihuahua", "ചിഹ്വാഹ" },
            { "timezone.excity.America/Coyhaique", "കൊയൈകേ" },
            { "timezone.excity.America/Fortaleza", "ഫോർട്ടലീസ" },
            { "timezone.excity.America/Glace_Bay", "ഗ്ലെയ്സ് ബേ" },
            { "timezone.excity.America/Goose_Bay", "ഗൂസ് ബേ" },
            { "timezone.excity.America/Guatemala", "ഗ്വാട്ടിമാല" },
            { "timezone.excity.America/Guayaquil", "ഗുവായക്വിൽ" },
            { "timezone.excity.America/Matamoros", "മറ്റാമൊറോസ്" },
            { "timezone.excity.America/Menominee", "മെനോമിനീ" },
            { "timezone.excity.America/Monterrey", "മോണ്ടെറി" },
            { "timezone.excity.America/Sao_Paulo", "സാവോപോളോ" },
            { "timezone.excity.America/St_Thomas", "സെന്റ് തോമസ്" },
            { "timezone.excity.America/Vancouver", "വാൻ‌കൂവർ" },
            { "timezone.excity.Antarctica/Mawson", "മാവ്സൺ" },
            { "timezone.excity.Antarctica/Palmer", "പാമർ" },
            { "timezone.excity.Antarctica/Vostok", "വോസ്റ്റോക്" },
            { "timezone.excity.Asia/Kuala_Lumpur", "ക്വാലലം‌പൂർ‌‌" },
            { "timezone.excity.Asia/Novokuznetsk", "നോവോകുസെൻസ്‌ക്" },
            { "timezone.excity.Europe/Bratislava", "ബ്രാട്ടിസ്‍ലാവ" },
            { "timezone.excity.Europe/Copenhagen", "കോപ്പൻ‌ഹേഗൻ‌" },
            { "timezone.excity.Europe/Luxembourg", "ലക്‌സംബർഗ്" },
            { "timezone.excity.Europe/San_Marino", "സാൻ മാരിനോ" },
            { "timezone.excity.Europe/Simferopol", "സിംഫെറോപോൾ" },
            { "timezone.excity.Pacific/Enderbury", "കാന്റൺ ദ്വീപ്" },
            { "timezone.excity.Pacific/Galapagos", "ഗാലപ്പാഗോസ്" },
            { "timezone.excity.Pacific/Kwajalein", "ക്വാജലെയ്ൻ" },
            { "timezone.excity.Pacific/Marquesas", "മാർക്യുസാസ്" },
            { "timezone.excity.Pacific/Pago_Pago", "പാഗോ പാഗോ" },
            { "timezone.excity.Pacific/Rarotonga", "റാരോടോംഗ" },
            { "timezone.excity.Pacific/Tongatapu", "ടോംഗാടാപു" },
            { "timezone.excity.Africa/Addis_Ababa", "അഡിസ് അബാബ" },
            { "timezone.excity.Africa/Brazzaville", "ബ്രാസവിൽ" },
            { "timezone.excity.Africa/Ouagadougou", "ഔഗാദൗഗൗ" },
            { "timezone.excity.America/Costa_Rica", "കോസ്റ്റ റിക്ക" },
            { "timezone.excity.America/Grand_Turk", "ഗ്രാൻഡ് ടർക്ക്" },
            { "timezone.excity.America/Guadeloupe", "ഗ്വാഡലൂപ്പ്" },
            { "timezone.excity.America/Hermosillo", "ഹെർമോസില്ലോ" },
            { "timezone.excity.America/Kralendijk", "കാർലൻഡിജെക്ക്" },
            { "timezone.excity.America/Louisville", "ലൂയിസ്‌വില്ലെ" },
            { "timezone.excity.America/Martinique", "മാർട്ടിനിക്" },
            { "timezone.excity.America/Metlakatla", "മെഡ്‌ലകട്‌ലെ" },
            { "timezone.excity.America/Montevideo", "മൊണ്ടെ‌വീഡിയോ" },
            { "timezone.excity.America/Montserrat", "മൊണ്ടെസരത്ത്" },
            { "timezone.excity.America/Paramaribo", "പരാമാരിബോ" },
            { "timezone.excity.America/Rio_Branco", "റിയോ ബ്രാങ്കോ" },
            { "timezone.excity.America/St_Vincent", "സെന്റ് വിൻസെന്റ്" },
            { "timezone.excity.America/Whitehorse", "വൈറ്റ്ഹോഴ്സ്" },
            { "timezone.excity.Antarctica/McMurdo", "മാക്മർഡോ" },
            { "timezone.excity.Antarctica/Rothera", "റൊതീറ" },
            { "timezone.excity.Asia/Srednekolymsk", "സ്രിഡ്‌നികോളിംസ്ക്" },
            { "timezone.excity.Asia/Yekaterinburg", "യാകാറ്റെറിൻബർഗ്" },
            { "timezone.excity.Atlantic/Reykjavik", "റേയ്‌ജാവിക്" },
            { "timezone.excity.Atlantic/St_Helena", "സെന്റ് ഹെലെന" },
            { "timezone.excity.Australia/Adelaide", "അഡിലെയ്‌ഡ്" },
            { "timezone.excity.Australia/Brisbane", "ബ്രിസ്‌ബെയിൻ" },
            { "timezone.excity.Australia/Lindeman", "ലിൻഡെമാൻ" },
            { "timezone.excity.Europe/Isle_of_Man", "ഐൽ‌ ഓഫ് മാൻ‌" },
            { "timezone.excity.Europe/Kaliningrad", "കലിനിൻഗ്രാഡ്" },
            { "timezone.excity.Pacific/Kiritimati", "കിരിറ്റിമാറ്റി" },
            { "timezone.excity.Africa/Johannesburg", "ജോഹന്നാസ്ബർ‌ഗ്" },
            { "timezone.excity.America/El_Salvador", "എൽ സാൽ‌വദോർ" },
            { "timezone.excity.America/Fort_Nelson", "ഫോർട്ട് നെൽസൺ" },
            { "timezone.excity.America/Los_Angeles", "ലോസ് എയ്ഞ്ചലസ്" },
            { "timezone.excity.America/Mexico_City", "മെക്സിക്കോ സിറ്റി" },
            { "timezone.excity.America/Porto_Velho", "പോർട്ടോ വെല്ലോ" },
            { "timezone.excity.America/Puerto_Rico", "പ്യൂർട്ടോ റിക്കോ" },
            { "timezone.excity.America/Tegucigalpa", "ടെഗൂസിഗാൽപ" },
            { "timezone.excity.Arctic/Longyearbyen", "ലംഗ്‍യെർബിൻ" },
            { "timezone.excity.Atlantic/Cape_Verde", "കേപ് വെർദെ" },
            { "timezone.excity.Australia/Lord_Howe", "ലോഡ് ഹോവ്" },
            { "timezone.excity.Australia/Melbourne", "മെൽബൺ" },
            { "timezone.excity.Indian/Antananarivo", "അൻറാനനറിവോ" },
            { "timezone.excity.Pacific/Guadalcanal", "ഗ്വാഡൽകനാൽ" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ദാർ എസ് സലാം" },
            { "timezone.excity.America/Blanc-Sablon", "ബ്ലാങ്ക് സാബ്ലോൺ" },
            { "timezone.excity.America/Buenos_Aires", "ബ്യൂണസ് ഐറിസ്" },
            { "timezone.excity.America/Campo_Grande", "ക്യാമ്പോ ഗ്രാൻഡെ" },
            { "timezone.excity.America/Danmarkshavn", "ഡാൻമാർക്ക്ഷാവ്ൻ" },
            { "timezone.excity.America/Dawson_Creek", "ഡോവ്സൺ ക്രീക്ക്" },
            { "timezone.excity.America/Indiana/Knox", "നോക്സ്, ഇൻഡ്യാന" },
            { "timezone.excity.America/Indianapolis", "ഇൻഡ്യാനാപോളിസ്" },
            { "timezone.excity.America/Punta_Arenas", "പുന്റ അരീനസ്" },
            { "timezone.excity.America/Rankin_Inlet", "റാങ്കിൻ ഇൻലെറ്റ്" },
            { "timezone.excity.America/Scoresbysund", "ഇറ്റ്വാഖ്വാർടൂർമിറ്റ്" },
            { "timezone.excity.Antarctica/Macquarie", "മക്വയറി" },
            { "timezone.excity.Pacific/Bougainville", "ബോഗൺവില്ലെ" },
            { "timezone.excity.Pacific/Port_Moresby", "പോർട്ട് മോഴ്‌സ്ബൈ" },
            { "timezone.excity.America/Cambridge_Bay", "കേംബ്രിഡ്‌ജ് ബേ" },
            { "timezone.excity.America/Ciudad_Juarez", "സിയുഡാഡ് ഹുവാരസ്" },
            { "timezone.excity.America/Coral_Harbour", "ഏറ്റികോക്കൺ" },
            { "timezone.excity.America/Indiana/Vevay", "വിവെയ്, ഇൻഡ്യാന" },
            { "timezone.excity.America/Lower_Princes", "ലോവർ പ്രിൻസസ് ക്വാർട്ടർ" },
            { "timezone.excity.America/Port_of_Spain", "പോർ‌ട്ട് ഓഫ് സ്‌പെയിൻ‌" },
            { "timezone.excity.America/Santo_Domingo", "സാന്തോ ഡോമിംഗോ" },
            { "timezone.excity.America/St_Barthelemy", "സെന്റ് ബർത്തലെമി" },
            { "timezone.excity.America/Swift_Current", "സ്വിഫ്‌റ്റ് കറന്റ്" },
            { "timezone.excity.Australia/Broken_Hill", "ബ്രോക്കൺ ഹിൽ" },
            { "timezone.excity.America/Bahia_Banderas", "ബഹിയ ബൻഡാരസ്" },
            { "timezone.excity.America/Port-au-Prince", "പോർട്ടോപ്രിൻസ്" },
            { "timezone.excity.Atlantic/South_Georgia", "ദക്ഷിണ ജോർജിയ" },
            { "timezone.excity.America/Argentina/Salta", "സാൽട്ട" },
            { "timezone.excity.America/Indiana/Marengo", "മരെങ്കോ, ഇൻഡ്യാന" },
            { "timezone.excity.America/Indiana/Winamac", "വിനാമാക്, ഇൻഡ്യാന" },
            { "timezone.excity.America/Argentina/Tucuman", "റ്റുകുമാൻ" },
            { "timezone.excity.America/Argentina/Ushuaia", "ഉഷിയ" },
            { "timezone.excity.America/Indiana/Tell_City", "റ്റെൽ സിറ്റി, ഇൻഡ്യാന" },
            { "timezone.excity.America/Indiana/Vincennes", "വിൻസെൻസ്, ഇൻഡ്യാന" },
            { "timezone.excity.Antarctica/DumontDUrville", "ഡ്യൂമണ്ട് ഡി യുർവിൽ" },
            { "timezone.excity.America/Argentina/La_Rioja", "ലാ റിയോജ" },
            { "timezone.excity.America/Argentina/San_Juan", "സാൻ ജുവാൻ" },
            { "timezone.excity.America/Argentina/San_Luis", "സാൻ ലൂയിസ്" },
            { "timezone.excity.America/Indiana/Petersburg", "പീറ്റേഴ്സ്ബർഗ്, ഇൻഡ്യാന" },
            { "timezone.excity.America/Kentucky/Monticello", "മോണ്ടിസെല്ലോ, കെന്റക്കി" },
            { "timezone.excity.America/North_Dakota/Beulah", "ബ്യൂല, വടക്കൻ ഡെക്കോട്ട" },
            { "timezone.excity.America/North_Dakota/Center", "സെന്റർ, വടക്കൻ ഡെക്കോട്ട" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "റിയോ ഗ്യാലഗോസ്" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ന്യൂ സെയ്‌ലം, വടക്കൻ ഡെക്കോട്ട" },
        };
        return data;
    }
}
