//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Valid values for expectedSendSize and expectedReceiveSize
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckoperationgrouptransfersize?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKOperationGroupTransferSize(pub NSInteger);
impl CKOperationGroupTransferSize {
    #[doc(alias = "CKOperationGroupTransferSizeUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "CKOperationGroupTransferSizeKilobytes")]
    pub const Kilobytes: Self = Self(1);
    #[doc(alias = "CKOperationGroupTransferSizeMegabytes")]
    pub const Megabytes: Self = Self(2);
    #[doc(alias = "CKOperationGroupTransferSizeTensOfMegabytes")]
    pub const TensOfMegabytes: Self = Self(3);
    #[doc(alias = "CKOperationGroupTransferSizeHundredsOfMegabytes")]
    pub const HundredsOfMegabytes: Self = Self(4);
    #[doc(alias = "CKOperationGroupTransferSizeGigabytes")]
    pub const Gigabytes: Self = Self(5);
    #[doc(alias = "CKOperationGroupTransferSizeTensOfGigabytes")]
    pub const TensOfGigabytes: Self = Self(6);
    #[doc(alias = "CKOperationGroupTransferSizeHundredsOfGigabytes")]
    pub const HundredsOfGigabytes: Self = Self(7);
}

unsafe impl Encode for CKOperationGroupTransferSize {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKOperationGroupTransferSize {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A mechanism for your app to group several operations at the granularity of a user action.
    ///
    ///
    /// For example, when building a Calendar application, these things might warrant being their own operation groups:
    /// - an initial fetch of data from the server, consisting of many queries, fetchChanges, and fetch operations
    /// - doing an incremental fetch of data in response to a push notification
    /// - saving several records due to a user saving a calendar event
    ///
    /// You associate
    /// `CKOperationGroup`s with
    /// `CKOperation`s by setting the
    /// `CKOperation.group`property.  Create a new
    /// `CKOperationGroup`instance for each distinct user action.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckoperationgroup?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKOperationGroup;
);

extern_conformance!(
    unsafe impl NSCoding for CKOperationGroup {}
);

extern_conformance!(
    unsafe impl NSCopying for CKOperationGroup {}
);

unsafe impl CopyingHelper for CKOperationGroup {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKOperationGroup {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKOperationGroup {}
);

impl CKOperationGroup {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `a_decoder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, a_decoder: &NSCoder) -> Retained<Self>;

        /// This is an identifier unique to this
        /// `CKOperationGroup`
        ///
        /// This value is chosen by the system, and will be unique to this instance of a
        /// `CKOperationGroup.`This identifier will be sent to Apple's servers, and can be used to identify any server-side logging associated with this operation group.
        #[unsafe(method(operationGroupID))]
        #[unsafe(method_family = none)]
        pub unsafe fn operationGroupID(&self) -> Retained<NSString>;

        #[cfg(feature = "CKOperation")]
        /// This is the default configuration applied to operations in this operation group.
        ///
        ///
        /// If an operation associated with this operation group has its own configuration, then any explicitly-set properties in that operation's configuration will override these default configuration values.  See the example in CKOperation.h
        #[unsafe(method(defaultConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultConfiguration(&self) -> Retained<CKOperationConfiguration>;

        #[cfg(feature = "CKOperation")]
        /// Setter for [`defaultConfiguration`][Self::defaultConfiguration].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDefaultConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultConfiguration(
            &self,
            default_configuration: Option<&CKOperationConfiguration>,
        );

        /// Describes the user action attributed to the operation group.
        ///
        ///
        /// `name`should describe the type of work being done.  Some examples:
        /// "Initial Fetch"
        /// "Incremental Fetch"
        /// "Saving User-Entered Record"
        /// This string will be sent to Apple servers to provide aggregate reporting for
        /// `CKOperationGroup`s and therefore must not include personally identifying data.
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Option<Retained<NSString>>;

        /// Setter for [`name`][Self::name].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setName(&self, name: Option<&NSString>);

        /// Describes an application-specific "number of elements" associated with the operation group.
        ///
        ///
        /// `quantity`is intended to show the app-specific count of items contained within the operation group.  It is your job to assign meaning to this value.  For example, if an app created an operation group to save 3 calendar events the user had created, the app might want to set this to "3".  This value is not shown to your users, it's meant to aid your development and debugging.  This value will be reported in the CloudKit Dashboard's log entries for all operations associated with this operation group.
        #[unsafe(method(quantity))]
        #[unsafe(method_family = none)]
        pub unsafe fn quantity(&self) -> NSUInteger;

        /// Setter for [`quantity`][Self::quantity].
        #[unsafe(method(setQuantity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setQuantity(&self, quantity: NSUInteger);

        /// Estimated size of traffic being uploaded to the CloudKit Server
        ///
        ///
        /// Inform the system how much data you plan on transferring.  Obviously, these won't be exact.  Be as accurate as possible, but even an order-of-magnitude estimate is better than no value.  The system will consult these values when scheduling discretionary network requests (see the description of
        /// `CKOperationConfiguration.qualityOfService).`Overestimating your workload means that an operation group issuing discretionary network requests may be delayed until network conditions are good.
        /// Underestimating your workload may cause the system to oversaturate a constrained connection, leading to network failures.
        /// You may update after the
        /// `CKOperationGroup`is created.  If it is increased, then subsequent
        /// `CKOperation`s associated with this operation group may be delayed until network conditions are good.
        /// Defaults to
        /// `CKOperationGroupTransferSizeUnknown`
        #[unsafe(method(expectedSendSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn expectedSendSize(&self) -> CKOperationGroupTransferSize;

        /// Setter for [`expectedSendSize`][Self::expectedSendSize].
        #[unsafe(method(setExpectedSendSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExpectedSendSize(&self, expected_send_size: CKOperationGroupTransferSize);

        /// Estimated size of traffic being downloaded from the CloudKit Server
        ///
        ///
        /// Inform the system how much data you plan on transferring.  Obviously, these won't be exact.  Be as accurate as possible, but even an order-of-magnitude estimate is better than no value.  The system will consult these values when scheduling discretionary network requests (see the description of
        /// `CKOperationConfiguration.qualityOfService).`Overestimating your workload means that an operation group issuing discretionary network requests may be delayed until network conditions are good.
        /// Underestimating your workload may cause the system to oversaturate a constrained connection, leading to network failures.
        /// You may update after the
        /// `CKOperationGroup`is created.  If it is increased, then subsequent
        /// `CKOperation`s associated with this operation group may be delayed until network conditions are good.
        /// Defaults to
        /// `CKOperationGroupTransferSizeUnknown`
        #[unsafe(method(expectedReceiveSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn expectedReceiveSize(&self) -> CKOperationGroupTransferSize;

        /// Setter for [`expectedReceiveSize`][Self::expectedReceiveSize].
        #[unsafe(method(setExpectedReceiveSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExpectedReceiveSize(
            &self,
            expected_receive_size: CKOperationGroupTransferSize,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl CKOperationGroup {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
