//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/filter/network/http_connection_manager/v2/http_connection_manager.proto

package http_connection_managerv2

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on HttpConnectionManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HttpConnectionManager) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpConnectionManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HttpConnectionManagerMultiError, or nil if none found.
func (m *HttpConnectionManager) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpConnectionManager) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := HttpConnectionManager_CodecType_name[int32(m.GetCodecType())]; !ok {
		err := HttpConnectionManagerValidationError{
			field:  "CodecType",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetStatPrefix()) < 1 {
		err := HttpConnectionManagerValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetHttpFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  fmt.Sprintf("HttpFilters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  fmt.Sprintf("HttpFilters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  fmt.Sprintf("HttpFilters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetAddUserAgent()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "AddUserAgent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "AddUserAgent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAddUserAgent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "AddUserAgent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTracing()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTracing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "Tracing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCommonHttpProtocolOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "CommonHttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "CommonHttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCommonHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "CommonHttpProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHttpProtocolOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "HttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "HttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "HttpProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHttp2ProtocolOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "Http2ProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "Http2ProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttp2ProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "Http2ProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ServerName

	if _, ok := HttpConnectionManager_ServerHeaderTransformation_name[int32(m.GetServerHeaderTransformation())]; !ok {
		err := HttpConnectionManagerValidationError{
			field:  "ServerHeaderTransformation",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if wrapper := m.GetMaxRequestHeadersKb(); wrapper != nil {

		if val := wrapper.GetValue(); val <= 0 || val > 8192 {
			err := HttpConnectionManagerValidationError{
				field:  "MaxRequestHeadersKb",
				reason: "value must be inside range (0, 8192]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetIdleTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "IdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "IdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetIdleTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "IdleTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetStreamIdleTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "StreamIdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "StreamIdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetStreamIdleTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "StreamIdleTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRequestTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "RequestTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "RequestTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRequestTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "RequestTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDrainTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "DrainTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "DrainTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDrainTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "DrainTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDelayedCloseTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "DelayedCloseTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "DelayedCloseTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDelayedCloseTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "DelayedCloseTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetAccessLog() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  fmt.Sprintf("AccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  fmt.Sprintf("AccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  fmt.Sprintf("AccessLog[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetUseRemoteAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "UseRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "UseRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUseRemoteAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "UseRemoteAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for XffNumTrustedHops

	if all {
		switch v := interface{}(m.GetInternalAddressConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "InternalAddressConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "InternalAddressConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetInternalAddressConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "InternalAddressConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for SkipXffAppend

	// no validation rules for Via

	if all {
		switch v := interface{}(m.GetGenerateRequestId()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "GenerateRequestId",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "GenerateRequestId",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGenerateRequestId()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "GenerateRequestId",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for PreserveExternalRequestId

	if _, ok := HttpConnectionManager_ForwardClientCertDetails_name[int32(m.GetForwardClientCertDetails())]; !ok {
		err := HttpConnectionManagerValidationError{
			field:  "ForwardClientCertDetails",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSetCurrentClientCertDetails()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "SetCurrentClientCertDetails",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "SetCurrentClientCertDetails",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSetCurrentClientCertDetails()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "SetCurrentClientCertDetails",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Proxy_100Continue

	// no validation rules for RepresentIpv4RemoteAddressAsIpv4MappedIpv6

	for idx, item := range m.GetUpgradeConfigs() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  fmt.Sprintf("UpgradeConfigs[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  fmt.Sprintf("UpgradeConfigs[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  fmt.Sprintf("UpgradeConfigs[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetNormalizePath()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "NormalizePath",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "NormalizePath",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetNormalizePath()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "NormalizePath",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for MergeSlashes

	if all {
		switch v := interface{}(m.GetRequestIdExtension()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "RequestIdExtension",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManagerValidationError{
					field:  "RequestIdExtension",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRequestIdExtension()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "RequestIdExtension",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofRouteSpecifierPresent := false
	switch v := m.RouteSpecifier.(type) {
	case *HttpConnectionManager_Rds:
		if v == nil {
			err := HttpConnectionManagerValidationError{
				field:  "RouteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRouteSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetRds()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  "Rds",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  "Rds",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRds()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  "Rds",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HttpConnectionManager_RouteConfig:
		if v == nil {
			err := HttpConnectionManagerValidationError{
				field:  "RouteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRouteSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetRouteConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  "RouteConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  "RouteConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRouteConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  "RouteConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HttpConnectionManager_ScopedRoutes:
		if v == nil {
			err := HttpConnectionManagerValidationError{
				field:  "RouteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRouteSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetScopedRoutes()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  "ScopedRoutes",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpConnectionManagerValidationError{
						field:  "ScopedRoutes",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetScopedRoutes()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  "ScopedRoutes",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofRouteSpecifierPresent {
		err := HttpConnectionManagerValidationError{
			field:  "RouteSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return HttpConnectionManagerMultiError(errors)
	}

	return nil
}

// HttpConnectionManagerMultiError is an error wrapping multiple validation
// errors returned by HttpConnectionManager.ValidateAll() if the designated
// constraints aren't met.
type HttpConnectionManagerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpConnectionManagerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpConnectionManagerMultiError) AllErrors() []error { return m }

// HttpConnectionManagerValidationError is the validation error returned by
// HttpConnectionManager.Validate if the designated constraints aren't met.
type HttpConnectionManagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpConnectionManagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpConnectionManagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpConnectionManagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManagerValidationError) ErrorName() string {
	return "HttpConnectionManagerValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManagerValidationError{}

// Validate checks the field values on Rds with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Rds) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Rds with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in RdsMultiError, or nil if none found.
func (m *Rds) ValidateAll() error {
	return m.validate(true)
}

func (m *Rds) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetConfigSource() == nil {
		err := RdsValidationError{
			field:  "ConfigSource",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetConfigSource()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RdsValidationError{
					field:  "ConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RdsValidationError{
					field:  "ConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RdsValidationError{
				field:  "ConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetRouteConfigName()) < 1 {
		err := RdsValidationError{
			field:  "RouteConfigName",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RdsMultiError(errors)
	}

	return nil
}

// RdsMultiError is an error wrapping multiple validation errors returned by
// Rds.ValidateAll() if the designated constraints aren't met.
type RdsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RdsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RdsMultiError) AllErrors() []error { return m }

// RdsValidationError is the validation error returned by Rds.Validate if the
// designated constraints aren't met.
type RdsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RdsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RdsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RdsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RdsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RdsValidationError) ErrorName() string { return "RdsValidationError" }

// Error satisfies the builtin error interface
func (e RdsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRds.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RdsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RdsValidationError{}

// Validate checks the field values on ScopedRouteConfigurationsList with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ScopedRouteConfigurationsList) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ScopedRouteConfigurationsList with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// ScopedRouteConfigurationsListMultiError, or nil if none found.
func (m *ScopedRouteConfigurationsList) ValidateAll() error {
	return m.validate(true)
}

func (m *ScopedRouteConfigurationsList) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetScopedRouteConfigurations()) < 1 {
		err := ScopedRouteConfigurationsListValidationError{
			field:  "ScopedRouteConfigurations",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetScopedRouteConfigurations() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScopedRouteConfigurationsListValidationError{
						field:  fmt.Sprintf("ScopedRouteConfigurations[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScopedRouteConfigurationsListValidationError{
						field:  fmt.Sprintf("ScopedRouteConfigurations[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRouteConfigurationsListValidationError{
					field:  fmt.Sprintf("ScopedRouteConfigurations[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ScopedRouteConfigurationsListMultiError(errors)
	}

	return nil
}

// ScopedRouteConfigurationsListMultiError is an error wrapping multiple
// validation errors returned by ScopedRouteConfigurationsList.ValidateAll()
// if the designated constraints aren't met.
type ScopedRouteConfigurationsListMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScopedRouteConfigurationsListMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScopedRouteConfigurationsListMultiError) AllErrors() []error { return m }

// ScopedRouteConfigurationsListValidationError is the validation error
// returned by ScopedRouteConfigurationsList.Validate if the designated
// constraints aren't met.
type ScopedRouteConfigurationsListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRouteConfigurationsListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRouteConfigurationsListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRouteConfigurationsListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRouteConfigurationsListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRouteConfigurationsListValidationError) ErrorName() string {
	return "ScopedRouteConfigurationsListValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRouteConfigurationsListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRouteConfigurationsList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRouteConfigurationsListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRouteConfigurationsListValidationError{}

// Validate checks the field values on ScopedRoutes with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ScopedRoutes) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ScopedRoutes with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ScopedRoutesMultiError, or
// nil if none found.
func (m *ScopedRoutes) ValidateAll() error {
	return m.validate(true)
}

func (m *ScopedRoutes) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) < 1 {
		err := ScopedRoutesValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetScopeKeyBuilder() == nil {
		err := ScopedRoutesValidationError{
			field:  "ScopeKeyBuilder",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetScopeKeyBuilder()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ScopedRoutesValidationError{
					field:  "ScopeKeyBuilder",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ScopedRoutesValidationError{
					field:  "ScopeKeyBuilder",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetScopeKeyBuilder()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ScopedRoutesValidationError{
				field:  "ScopeKeyBuilder",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetRdsConfigSource() == nil {
		err := ScopedRoutesValidationError{
			field:  "RdsConfigSource",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRdsConfigSource()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ScopedRoutesValidationError{
					field:  "RdsConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ScopedRoutesValidationError{
					field:  "RdsConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRdsConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ScopedRoutesValidationError{
				field:  "RdsConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofConfigSpecifierPresent := false
	switch v := m.ConfigSpecifier.(type) {
	case *ScopedRoutes_ScopedRouteConfigurationsList:
		if v == nil {
			err := ScopedRoutesValidationError{
				field:  "ConfigSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofConfigSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetScopedRouteConfigurationsList()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScopedRoutesValidationError{
						field:  "ScopedRouteConfigurationsList",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScopedRoutesValidationError{
						field:  "ScopedRouteConfigurationsList",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetScopedRouteConfigurationsList()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutesValidationError{
					field:  "ScopedRouteConfigurationsList",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ScopedRoutes_ScopedRds:
		if v == nil {
			err := ScopedRoutesValidationError{
				field:  "ConfigSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofConfigSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetScopedRds()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScopedRoutesValidationError{
						field:  "ScopedRds",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScopedRoutesValidationError{
						field:  "ScopedRds",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetScopedRds()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutesValidationError{
					field:  "ScopedRds",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofConfigSpecifierPresent {
		err := ScopedRoutesValidationError{
			field:  "ConfigSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ScopedRoutesMultiError(errors)
	}

	return nil
}

// ScopedRoutesMultiError is an error wrapping multiple validation errors
// returned by ScopedRoutes.ValidateAll() if the designated constraints aren't met.
type ScopedRoutesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScopedRoutesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScopedRoutesMultiError) AllErrors() []error { return m }

// ScopedRoutesValidationError is the validation error returned by
// ScopedRoutes.Validate if the designated constraints aren't met.
type ScopedRoutesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRoutesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRoutesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRoutesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRoutesValidationError) ErrorName() string { return "ScopedRoutesValidationError" }

// Error satisfies the builtin error interface
func (e ScopedRoutesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutesValidationError{}

// Validate checks the field values on ScopedRds with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ScopedRds) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ScopedRds with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ScopedRdsMultiError, or nil
// if none found.
func (m *ScopedRds) ValidateAll() error {
	return m.validate(true)
}

func (m *ScopedRds) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetScopedRdsConfigSource() == nil {
		err := ScopedRdsValidationError{
			field:  "ScopedRdsConfigSource",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetScopedRdsConfigSource()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ScopedRdsValidationError{
					field:  "ScopedRdsConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ScopedRdsValidationError{
					field:  "ScopedRdsConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetScopedRdsConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ScopedRdsValidationError{
				field:  "ScopedRdsConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ScopedRdsMultiError(errors)
	}

	return nil
}

// ScopedRdsMultiError is an error wrapping multiple validation errors returned
// by ScopedRds.ValidateAll() if the designated constraints aren't met.
type ScopedRdsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScopedRdsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScopedRdsMultiError) AllErrors() []error { return m }

// ScopedRdsValidationError is the validation error returned by
// ScopedRds.Validate if the designated constraints aren't met.
type ScopedRdsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRdsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRdsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRdsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRdsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRdsValidationError) ErrorName() string { return "ScopedRdsValidationError" }

// Error satisfies the builtin error interface
func (e ScopedRdsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRds.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRdsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRdsValidationError{}

// Validate checks the field values on HttpFilter with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HttpFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpFilter with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HttpFilterMultiError, or
// nil if none found.
func (m *HttpFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) < 1 {
		err := HttpFilterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *HttpFilter_Config:
		if v == nil {
			err := HttpFilterValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpFilterValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpFilterValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpFilterValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HttpFilter_TypedConfig:
		if v == nil {
			err := HttpFilterValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpFilterValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpFilterValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpFilterValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return HttpFilterMultiError(errors)
	}

	return nil
}

// HttpFilterMultiError is an error wrapping multiple validation errors
// returned by HttpFilter.ValidateAll() if the designated constraints aren't met.
type HttpFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpFilterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpFilterMultiError) AllErrors() []error { return m }

// HttpFilterValidationError is the validation error returned by
// HttpFilter.Validate if the designated constraints aren't met.
type HttpFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpFilterValidationError) ErrorName() string { return "HttpFilterValidationError" }

// Error satisfies the builtin error interface
func (e HttpFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpFilterValidationError{}

// Validate checks the field values on RequestIDExtension with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RequestIDExtension) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RequestIDExtension with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RequestIDExtensionMultiError, or nil if none found.
func (m *RequestIDExtension) ValidateAll() error {
	return m.validate(true)
}

func (m *RequestIDExtension) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTypedConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RequestIDExtensionValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RequestIDExtensionValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RequestIDExtensionValidationError{
				field:  "TypedConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RequestIDExtensionMultiError(errors)
	}

	return nil
}

// RequestIDExtensionMultiError is an error wrapping multiple validation errors
// returned by RequestIDExtension.ValidateAll() if the designated constraints
// aren't met.
type RequestIDExtensionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RequestIDExtensionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RequestIDExtensionMultiError) AllErrors() []error { return m }

// RequestIDExtensionValidationError is the validation error returned by
// RequestIDExtension.Validate if the designated constraints aren't met.
type RequestIDExtensionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RequestIDExtensionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RequestIDExtensionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RequestIDExtensionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RequestIDExtensionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RequestIDExtensionValidationError) ErrorName() string {
	return "RequestIDExtensionValidationError"
}

// Error satisfies the builtin error interface
func (e RequestIDExtensionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRequestIDExtension.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RequestIDExtensionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RequestIDExtensionValidationError{}

// Validate checks the field values on HttpConnectionManager_Tracing with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HttpConnectionManager_Tracing) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpConnectionManager_Tracing with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// HttpConnectionManager_TracingMultiError, or nil if none found.
func (m *HttpConnectionManager_Tracing) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpConnectionManager_Tracing) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := HttpConnectionManager_Tracing_OperationName_name[int32(m.GetOperationName())]; !ok {
		err := HttpConnectionManager_TracingValidationError{
			field:  "OperationName",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetClientSampling()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "ClientSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "ClientSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetClientSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "ClientSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRandomSampling()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "RandomSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "RandomSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRandomSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "RandomSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOverallSampling()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "OverallSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "OverallSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOverallSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "OverallSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Verbose

	if all {
		switch v := interface{}(m.GetMaxPathTagLength()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "MaxPathTagLength",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "MaxPathTagLength",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxPathTagLength()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "MaxPathTagLength",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetCustomTags() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpConnectionManager_TracingValidationError{
						field:  fmt.Sprintf("CustomTags[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpConnectionManager_TracingValidationError{
						field:  fmt.Sprintf("CustomTags[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManager_TracingValidationError{
					field:  fmt.Sprintf("CustomTags[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetProvider()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "Provider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManager_TracingValidationError{
					field:  "Provider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetProvider()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "Provider",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return HttpConnectionManager_TracingMultiError(errors)
	}

	return nil
}

// HttpConnectionManager_TracingMultiError is an error wrapping multiple
// validation errors returned by HttpConnectionManager_Tracing.ValidateAll()
// if the designated constraints aren't met.
type HttpConnectionManager_TracingMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpConnectionManager_TracingMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpConnectionManager_TracingMultiError) AllErrors() []error { return m }

// HttpConnectionManager_TracingValidationError is the validation error
// returned by HttpConnectionManager_Tracing.Validate if the designated
// constraints aren't met.
type HttpConnectionManager_TracingValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManager_TracingValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpConnectionManager_TracingValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpConnectionManager_TracingValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpConnectionManager_TracingValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManager_TracingValidationError) ErrorName() string {
	return "HttpConnectionManager_TracingValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManager_TracingValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager_Tracing.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManager_TracingValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManager_TracingValidationError{}

// Validate checks the field values on
// HttpConnectionManager_InternalAddressConfig with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HttpConnectionManager_InternalAddressConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// HttpConnectionManager_InternalAddressConfig with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// HttpConnectionManager_InternalAddressConfigMultiError, or nil if none found.
func (m *HttpConnectionManager_InternalAddressConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpConnectionManager_InternalAddressConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UnixSockets

	if len(errors) > 0 {
		return HttpConnectionManager_InternalAddressConfigMultiError(errors)
	}

	return nil
}

// HttpConnectionManager_InternalAddressConfigMultiError is an error wrapping
// multiple validation errors returned by
// HttpConnectionManager_InternalAddressConfig.ValidateAll() if the designated
// constraints aren't met.
type HttpConnectionManager_InternalAddressConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpConnectionManager_InternalAddressConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpConnectionManager_InternalAddressConfigMultiError) AllErrors() []error { return m }

// HttpConnectionManager_InternalAddressConfigValidationError is the validation
// error returned by HttpConnectionManager_InternalAddressConfig.Validate if
// the designated constraints aren't met.
type HttpConnectionManager_InternalAddressConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManager_InternalAddressConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpConnectionManager_InternalAddressConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpConnectionManager_InternalAddressConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpConnectionManager_InternalAddressConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManager_InternalAddressConfigValidationError) ErrorName() string {
	return "HttpConnectionManager_InternalAddressConfigValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManager_InternalAddressConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager_InternalAddressConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManager_InternalAddressConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManager_InternalAddressConfigValidationError{}

// Validate checks the field values on
// HttpConnectionManager_SetCurrentClientCertDetails with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HttpConnectionManager_SetCurrentClientCertDetails) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// HttpConnectionManager_SetCurrentClientCertDetails with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// HttpConnectionManager_SetCurrentClientCertDetailsMultiError, or nil if none found.
func (m *HttpConnectionManager_SetCurrentClientCertDetails) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpConnectionManager_SetCurrentClientCertDetails) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetSubject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManager_SetCurrentClientCertDetailsValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManager_SetCurrentClientCertDetailsValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_SetCurrentClientCertDetailsValidationError{
				field:  "Subject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Cert

	// no validation rules for Chain

	// no validation rules for Dns

	// no validation rules for Uri

	if len(errors) > 0 {
		return HttpConnectionManager_SetCurrentClientCertDetailsMultiError(errors)
	}

	return nil
}

// HttpConnectionManager_SetCurrentClientCertDetailsMultiError is an error
// wrapping multiple validation errors returned by
// HttpConnectionManager_SetCurrentClientCertDetails.ValidateAll() if the
// designated constraints aren't met.
type HttpConnectionManager_SetCurrentClientCertDetailsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpConnectionManager_SetCurrentClientCertDetailsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpConnectionManager_SetCurrentClientCertDetailsMultiError) AllErrors() []error { return m }

// HttpConnectionManager_SetCurrentClientCertDetailsValidationError is the
// validation error returned by
// HttpConnectionManager_SetCurrentClientCertDetails.Validate if the
// designated constraints aren't met.
type HttpConnectionManager_SetCurrentClientCertDetailsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) ErrorName() string {
	return "HttpConnectionManager_SetCurrentClientCertDetailsValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager_SetCurrentClientCertDetails.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManager_SetCurrentClientCertDetailsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManager_SetCurrentClientCertDetailsValidationError{}

// Validate checks the field values on HttpConnectionManager_UpgradeConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *HttpConnectionManager_UpgradeConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpConnectionManager_UpgradeConfig
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// HttpConnectionManager_UpgradeConfigMultiError, or nil if none found.
func (m *HttpConnectionManager_UpgradeConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpConnectionManager_UpgradeConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UpgradeType

	for idx, item := range m.GetFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpConnectionManager_UpgradeConfigValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpConnectionManager_UpgradeConfigValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManager_UpgradeConfigValidationError{
					field:  fmt.Sprintf("Filters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpConnectionManager_UpgradeConfigValidationError{
					field:  "Enabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpConnectionManager_UpgradeConfigValidationError{
					field:  "Enabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_UpgradeConfigValidationError{
				field:  "Enabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return HttpConnectionManager_UpgradeConfigMultiError(errors)
	}

	return nil
}

// HttpConnectionManager_UpgradeConfigMultiError is an error wrapping multiple
// validation errors returned by
// HttpConnectionManager_UpgradeConfig.ValidateAll() if the designated
// constraints aren't met.
type HttpConnectionManager_UpgradeConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpConnectionManager_UpgradeConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpConnectionManager_UpgradeConfigMultiError) AllErrors() []error { return m }

// HttpConnectionManager_UpgradeConfigValidationError is the validation error
// returned by HttpConnectionManager_UpgradeConfig.Validate if the designated
// constraints aren't met.
type HttpConnectionManager_UpgradeConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManager_UpgradeConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpConnectionManager_UpgradeConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpConnectionManager_UpgradeConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpConnectionManager_UpgradeConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManager_UpgradeConfigValidationError) ErrorName() string {
	return "HttpConnectionManager_UpgradeConfigValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManager_UpgradeConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager_UpgradeConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManager_UpgradeConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManager_UpgradeConfigValidationError{}

// Validate checks the field values on ScopedRoutes_ScopeKeyBuilder with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ScopedRoutes_ScopeKeyBuilder) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ScopedRoutes_ScopeKeyBuilder with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ScopedRoutes_ScopeKeyBuilderMultiError, or nil if none found.
func (m *ScopedRoutes_ScopeKeyBuilder) ValidateAll() error {
	return m.validate(true)
}

func (m *ScopedRoutes_ScopeKeyBuilder) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetFragments()) < 1 {
		err := ScopedRoutes_ScopeKeyBuilderValidationError{
			field:  "Fragments",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetFragments() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScopedRoutes_ScopeKeyBuilderValidationError{
						field:  fmt.Sprintf("Fragments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScopedRoutes_ScopeKeyBuilderValidationError{
						field:  fmt.Sprintf("Fragments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutes_ScopeKeyBuilderValidationError{
					field:  fmt.Sprintf("Fragments[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ScopedRoutes_ScopeKeyBuilderMultiError(errors)
	}

	return nil
}

// ScopedRoutes_ScopeKeyBuilderMultiError is an error wrapping multiple
// validation errors returned by ScopedRoutes_ScopeKeyBuilder.ValidateAll() if
// the designated constraints aren't met.
type ScopedRoutes_ScopeKeyBuilderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScopedRoutes_ScopeKeyBuilderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScopedRoutes_ScopeKeyBuilderMultiError) AllErrors() []error { return m }

// ScopedRoutes_ScopeKeyBuilderValidationError is the validation error returned
// by ScopedRoutes_ScopeKeyBuilder.Validate if the designated constraints
// aren't met.
type ScopedRoutes_ScopeKeyBuilderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) ErrorName() string {
	return "ScopedRoutes_ScopeKeyBuilderValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes_ScopeKeyBuilder.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutes_ScopeKeyBuilderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutes_ScopeKeyBuilderValidationError{}

// Validate checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilderMultiError, or nil if none found.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) ValidateAll() error {
	return m.validate(true)
}

func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofTypePresent := false
	switch v := m.Type.(type) {
	case *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_:
		if v == nil {
			err := ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if all {
			switch v := interface{}(m.GetHeaderValueExtractor()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{
						field:  "HeaderValueExtractor",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{
						field:  "HeaderValueExtractor",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHeaderValueExtractor()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{
					field:  "HeaderValueExtractor",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofTypePresent {
		err := ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{
			field:  "Type",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ScopedRoutes_ScopeKeyBuilder_FragmentBuilderMultiError(errors)
	}

	return nil
}

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilderMultiError is an error wrapping
// multiple validation errors returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder.ValidateAll() if the
// designated constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScopedRoutes_ScopeKeyBuilder_FragmentBuilderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScopedRoutes_ScopeKeyBuilder_FragmentBuilderMultiError) AllErrors() []error { return m }

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError is the
// validation error returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder.Validate if the designated
// constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) ErrorName() string {
	return "ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes_ScopeKeyBuilder_FragmentBuilder.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{}

// Validate checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorMultiError,
// or nil if none found.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) ValidateAll() error {
	return m.validate(true)
}

func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) < 1 {
		err := ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for ElementSeparator

	switch v := m.ExtractType.(type) {
	case *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Index:
		if v == nil {
			err := ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{
				field:  "ExtractType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Index
	case *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Element:
		if v == nil {
			err := ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{
				field:  "ExtractType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetElement()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{
						field:  "Element",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{
						field:  "Element",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetElement()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{
					field:  "Element",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorMultiError(errors)
	}

	return nil
}

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorMultiError
// is an error wrapping multiple validation errors returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor.ValidateAll()
// if the designated constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorMultiError) AllErrors() []error {
	return m
}

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError
// is the validation error returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor.Validate
// if the designated constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) ErrorName() string {
	return "ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{}

// Validate checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementMultiError,
// or nil if none found.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) ValidateAll() error {
	return m.validate(true)
}

func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetSeparator()) < 1 {
		err := ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError{
			field:  "Separator",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetKey()) < 1 {
		err := ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError{
			field:  "Key",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementMultiError(errors)
	}

	return nil
}

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementMultiError
// is an error wrapping multiple validation errors returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement.ValidateAll()
// if the designated constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementMultiError) AllErrors() []error {
	return m
}

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError
// is the validation error returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement.Validate
// if the designated constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) ErrorName() string {
	return "ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError{}
