// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: pbconnectca/ca.proto

package pbconnectca

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type WatchRootsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchRootsRequest) Reset() {
	*x = WatchRootsRequest{}
	mi := &file_pbconnectca_ca_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchRootsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchRootsRequest) ProtoMessage() {}

func (x *WatchRootsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbconnectca_ca_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchRootsRequest.ProtoReflect.Descriptor instead.
func (*WatchRootsRequest) Descriptor() ([]byte, []int) {
	return file_pbconnectca_ca_proto_rawDescGZIP(), []int{0}
}

type WatchRootsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// active_root_id is the ID of a root in Roots that is the active CA root.
	// Other roots are still valid if they're in the Roots list but are in the
	// process of being rotated out.
	ActiveRootId string `protobuf:"bytes,1,opt,name=active_root_id,json=activeRootId,proto3" json:"active_root_id,omitempty"`
	// trust_domain is the identification root for this Consul cluster. All
	// certificates signed by the cluster's CA must have their identifying URI
	// in this domain.
	//
	// This does not include the protocol (currently spiffe://) since we may
	// implement other protocols in future with equivalent semantics. It should
	// be compared against the "authority" section of a URI (i.e. host:port).
	TrustDomain string `protobuf:"bytes,2,opt,name=trust_domain,json=trustDomain,proto3" json:"trust_domain,omitempty"`
	// roots is a list of root CA certs to trust.
	Roots         []*CARoot `protobuf:"bytes,3,rep,name=roots,proto3" json:"roots,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchRootsResponse) Reset() {
	*x = WatchRootsResponse{}
	mi := &file_pbconnectca_ca_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchRootsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchRootsResponse) ProtoMessage() {}

func (x *WatchRootsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbconnectca_ca_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchRootsResponse.ProtoReflect.Descriptor instead.
func (*WatchRootsResponse) Descriptor() ([]byte, []int) {
	return file_pbconnectca_ca_proto_rawDescGZIP(), []int{1}
}

func (x *WatchRootsResponse) GetActiveRootId() string {
	if x != nil {
		return x.ActiveRootId
	}
	return ""
}

func (x *WatchRootsResponse) GetTrustDomain() string {
	if x != nil {
		return x.TrustDomain
	}
	return ""
}

func (x *WatchRootsResponse) GetRoots() []*CARoot {
	if x != nil {
		return x.Roots
	}
	return nil
}

type CARoot struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// id is a globally unique ID (UUID) representing this CA root.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// name is a human-friendly name for this CA root. This value is opaque to
	// Consul and is not used for anything internally.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// serial_number is the x509 serial number of the certificate.
	SerialNumber uint64 `protobuf:"varint,3,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	// signing_key_id is the connect.HexString encoded id of the public key that
	// corresponds to the private key used to sign leaf certificates in the
	// local datacenter.
	//
	// The value comes from x509.Certificate.SubjectKeyId of the local leaf
	// signing cert.
	//
	// See https://www.rfc-editor.org/rfc/rfc3280#section-4.2.1.1 for more detail.
	SigningKeyId string `protobuf:"bytes,4,opt,name=signing_key_id,json=signingKeyId,proto3" json:"signing_key_id,omitempty"`
	// root_cert is the PEM-encoded public certificate.
	RootCert string `protobuf:"bytes,5,opt,name=root_cert,json=rootCert,proto3" json:"root_cert,omitempty"`
	// intermediate_certs is a list of PEM-encoded intermediate certs to
	// attach to any leaf certs signed by this CA.
	IntermediateCerts []string `protobuf:"bytes,6,rep,name=intermediate_certs,json=intermediateCerts,proto3" json:"intermediate_certs,omitempty"`
	// active is true if this is the current active CA. This must only
	// be true for exactly one CA.
	Active bool `protobuf:"varint,7,opt,name=active,proto3" json:"active,omitempty"`
	// rotated_out_at is the time at which this CA was removed from the state.
	// This will only be set on roots that have been rotated out from being the
	// active root.
	RotatedOutAt  *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=rotated_out_at,json=rotatedOutAt,proto3" json:"rotated_out_at,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CARoot) Reset() {
	*x = CARoot{}
	mi := &file_pbconnectca_ca_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CARoot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CARoot) ProtoMessage() {}

func (x *CARoot) ProtoReflect() protoreflect.Message {
	mi := &file_pbconnectca_ca_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CARoot.ProtoReflect.Descriptor instead.
func (*CARoot) Descriptor() ([]byte, []int) {
	return file_pbconnectca_ca_proto_rawDescGZIP(), []int{2}
}

func (x *CARoot) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CARoot) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CARoot) GetSerialNumber() uint64 {
	if x != nil {
		return x.SerialNumber
	}
	return 0
}

func (x *CARoot) GetSigningKeyId() string {
	if x != nil {
		return x.SigningKeyId
	}
	return ""
}

func (x *CARoot) GetRootCert() string {
	if x != nil {
		return x.RootCert
	}
	return ""
}

func (x *CARoot) GetIntermediateCerts() []string {
	if x != nil {
		return x.IntermediateCerts
	}
	return nil
}

func (x *CARoot) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

func (x *CARoot) GetRotatedOutAt() *timestamppb.Timestamp {
	if x != nil {
		return x.RotatedOutAt
	}
	return nil
}

type SignRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// csr is the PEM-encoded Certificate Signing Request (CSR).
	//
	// The CSR's SAN must include a SPIFFE ID that identifies a service or agent
	// to which the ACL token provided in the `x-consul-token` metadata has write
	// access.
	Csr           string `protobuf:"bytes,1,opt,name=csr,proto3" json:"csr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SignRequest) Reset() {
	*x = SignRequest{}
	mi := &file_pbconnectca_ca_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SignRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignRequest) ProtoMessage() {}

func (x *SignRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbconnectca_ca_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignRequest.ProtoReflect.Descriptor instead.
func (*SignRequest) Descriptor() ([]byte, []int) {
	return file_pbconnectca_ca_proto_rawDescGZIP(), []int{3}
}

func (x *SignRequest) GetCsr() string {
	if x != nil {
		return x.Csr
	}
	return ""
}

type SignResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cert_pem is the PEM-encoded leaf certificate.
	CertPem       string `protobuf:"bytes,2,opt,name=cert_pem,json=certPem,proto3" json:"cert_pem,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SignResponse) Reset() {
	*x = SignResponse{}
	mi := &file_pbconnectca_ca_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SignResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignResponse) ProtoMessage() {}

func (x *SignResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbconnectca_ca_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignResponse.ProtoReflect.Descriptor instead.
func (*SignResponse) Descriptor() ([]byte, []int) {
	return file_pbconnectca_ca_proto_rawDescGZIP(), []int{4}
}

func (x *SignResponse) GetCertPem() string {
	if x != nil {
		return x.CertPem
	}
	return ""
}

var File_pbconnectca_ca_proto protoreflect.FileDescriptor

const file_pbconnectca_ca_proto_rawDesc = "" +
	"\n" +
	"\x14pbconnectca/ca.proto\x12\x1ahashicorp.consul.connectca\x1a%annotations/ratelimit/ratelimit.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\x13\n" +
	"\x11WatchRootsRequest\"\x97\x01\n" +
	"\x12WatchRootsResponse\x12$\n" +
	"\x0eactive_root_id\x18\x01 \x01(\tR\factiveRootId\x12!\n" +
	"\ftrust_domain\x18\x02 \x01(\tR\vtrustDomain\x128\n" +
	"\x05roots\x18\x03 \x03(\v2\".hashicorp.consul.connectca.CARootR\x05roots\"\x9d\x02\n" +
	"\x06CARoot\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12#\n" +
	"\rserial_number\x18\x03 \x01(\x04R\fserialNumber\x12$\n" +
	"\x0esigning_key_id\x18\x04 \x01(\tR\fsigningKeyId\x12\x1b\n" +
	"\troot_cert\x18\x05 \x01(\tR\brootCert\x12-\n" +
	"\x12intermediate_certs\x18\x06 \x03(\tR\x11intermediateCerts\x12\x16\n" +
	"\x06active\x18\a \x01(\bR\x06active\x12@\n" +
	"\x0erotated_out_at\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\frotatedOutAt\"\x1f\n" +
	"\vSignRequest\x12\x10\n" +
	"\x03csr\x18\x01 \x01(\tR\x03csr\")\n" +
	"\fSignResponse\x12\x19\n" +
	"\bcert_pem\x18\x02 \x01(\tR\acertPem2\xf0\x01\n" +
	"\x10ConnectCAService\x12w\n" +
	"\n" +
	"WatchRoots\x12-.hashicorp.consul.connectca.WatchRootsRequest\x1a..hashicorp.consul.connectca.WatchRootsResponse\"\b\xe2\x86\x04\x04\b\x02\x10\x030\x01\x12c\n" +
	"\x04Sign\x12'.hashicorp.consul.connectca.SignRequest\x1a(.hashicorp.consul.connectca.SignResponse\"\b\xe2\x86\x04\x04\b\x03\x10\x03B\xe9\x01\n" +
	"\x1ecom.hashicorp.consul.connectcaB\aCaProtoP\x01Z4github.com/hashicorp/consul/proto-public/pbconnectca\xa2\x02\x03HCC\xaa\x02\x1aHashicorp.Consul.Connectca\xca\x02\x1aHashicorp\\Consul\\Connectca\xe2\x02&Hashicorp\\Consul\\Connectca\\GPBMetadata\xea\x02\x1cHashicorp::Consul::Connectcab\x06proto3"

var (
	file_pbconnectca_ca_proto_rawDescOnce sync.Once
	file_pbconnectca_ca_proto_rawDescData []byte
)

func file_pbconnectca_ca_proto_rawDescGZIP() []byte {
	file_pbconnectca_ca_proto_rawDescOnce.Do(func() {
		file_pbconnectca_ca_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_pbconnectca_ca_proto_rawDesc), len(file_pbconnectca_ca_proto_rawDesc)))
	})
	return file_pbconnectca_ca_proto_rawDescData
}

var file_pbconnectca_ca_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_pbconnectca_ca_proto_goTypes = []any{
	(*WatchRootsRequest)(nil),     // 0: hashicorp.consul.connectca.WatchRootsRequest
	(*WatchRootsResponse)(nil),    // 1: hashicorp.consul.connectca.WatchRootsResponse
	(*CARoot)(nil),                // 2: hashicorp.consul.connectca.CARoot
	(*SignRequest)(nil),           // 3: hashicorp.consul.connectca.SignRequest
	(*SignResponse)(nil),          // 4: hashicorp.consul.connectca.SignResponse
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_pbconnectca_ca_proto_depIdxs = []int32{
	2, // 0: hashicorp.consul.connectca.WatchRootsResponse.roots:type_name -> hashicorp.consul.connectca.CARoot
	5, // 1: hashicorp.consul.connectca.CARoot.rotated_out_at:type_name -> google.protobuf.Timestamp
	0, // 2: hashicorp.consul.connectca.ConnectCAService.WatchRoots:input_type -> hashicorp.consul.connectca.WatchRootsRequest
	3, // 3: hashicorp.consul.connectca.ConnectCAService.Sign:input_type -> hashicorp.consul.connectca.SignRequest
	1, // 4: hashicorp.consul.connectca.ConnectCAService.WatchRoots:output_type -> hashicorp.consul.connectca.WatchRootsResponse
	4, // 5: hashicorp.consul.connectca.ConnectCAService.Sign:output_type -> hashicorp.consul.connectca.SignResponse
	4, // [4:6] is the sub-list for method output_type
	2, // [2:4] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_pbconnectca_ca_proto_init() }
func file_pbconnectca_ca_proto_init() {
	if File_pbconnectca_ca_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_pbconnectca_ca_proto_rawDesc), len(file_pbconnectca_ca_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pbconnectca_ca_proto_goTypes,
		DependencyIndexes: file_pbconnectca_ca_proto_depIdxs,
		MessageInfos:      file_pbconnectca_ca_proto_msgTypes,
	}.Build()
	File_pbconnectca_ca_proto = out.File
	file_pbconnectca_ca_proto_goTypes = nil
	file_pbconnectca_ca_proto_depIdxs = nil
}
