/**
 * Integration test for read preference with hedging mode. The more comprehensive unit test can be
 * found in dbtests/read_preference_test.cpp and s/hedge_options_util_test.cpp.
 */
const st = new ShardingTest({shards: 2});
const dbName = "foo";
const collName = "bar";
const ns = dbName + "." + collName;
const testDB = st.s.getDB(dbName);

assert.commandWorked(st.s.adminCommand({shardCollection: ns, key: {x: 1}}));

// Test "hedge" read preference validation.
assert.commandFailedWithCode(
    testDB.runCommand(
        {count: collName, $readPreference: {mode: "primary", hedge: {enabled: true}}}),
    ErrorCodes.InvalidOptions);

assert.commandFailedWithCode(
    testDB.runCommand(
        {count: collName, $readPreference: {mode: "secondaryPreferred", hedge: "_1"}}),
    ErrorCodes.TypeMismatch);

// Test "readHedgingMode" server parameter validation.
assert.commandFailedWithCode(st.s.adminCommand({setParameter: 1, readHedgingMode: "invalidMode"}),
                             ErrorCodes.BadValue);

// Test setting maxTimeMS for hedged reads.
assert.commandWorked(st.s.adminCommand({setParameter: 1, maxTimeMSForHedgedReads: 1000}));

// Test hedging with maxTimeMS.
assert.commandWorked(st.s.getDB(dbName).runCommand({
    find: collName,
    maxTimeMS: 10000,
    $readPreference: {mode: "nearest", hedge: {enabled: true}}
}));

// Test hedging without maxTimeMS.
assert.commandWorked(st.s.getDB(dbName).runCommand(
    {count: collName, $readPreference: {mode: "secondaryPreferred", hedge: {enabled: true}}}));

// Set "readHedgingMode" to "off", expect no hedging.
st.s.adminCommand({setParameter: 1, readHedgingMode: "off"});

assert.commandWorked(st.s.getDB(dbName).runCommand({
    distinct: collName,
    key: "x",
    $readPreference: {mode: "primaryPreferred", hedge: {enabled: true}}
}));

st.stop();
