/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.providersupport.shared;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.providersupport.internal.ProviderRegistry;
import org.openhab.core.automation.module.script.providersupport.shared.ScriptedItemProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemNotUniqueException;
import org.openhab.core.items.ItemRegistry;

@NonNullByDefault
public class ProviderItemRegistryDelegate
implements ItemRegistry,
ProviderRegistry {
    private final ItemRegistry itemRegistry;
    private final Set<String> items = new HashSet<String>();
    private final ScriptedItemProvider scriptedProvider;

    public ProviderItemRegistryDelegate(ItemRegistry itemRegistry, ScriptedItemProvider scriptedProvider) {
        this.itemRegistry = itemRegistry;
        this.scriptedProvider = scriptedProvider;
    }

    public void addRegistryChangeListener(RegistryChangeListener<Item> listener) {
        this.itemRegistry.addRegistryChangeListener(listener);
    }

    public Collection<Item> getAll() {
        return this.itemRegistry.getAll();
    }

    public Stream<Item> stream() {
        return this.itemRegistry.stream();
    }

    public @Nullable Item get(String key) {
        return (Item)this.itemRegistry.get((Object)key);
    }

    public void removeRegistryChangeListener(RegistryChangeListener<Item> listener) {
        this.itemRegistry.removeRegistryChangeListener(listener);
    }

    public Item add(Item element) {
        String itemName = element.getName();
        if (this.get(itemName) != null) {
            throw new IllegalArgumentException("Cannot add item, because an item with same name (" + itemName + ") already exists.");
        }
        this.scriptedProvider.add(element);
        this.items.add(itemName);
        return element;
    }

    public Item addPermanent(Item element) {
        return (Item)this.itemRegistry.add((Identifiable)element);
    }

    public @Nullable Item update(Item element) {
        if (this.items.contains(element.getName())) {
            return this.scriptedProvider.update(element);
        }
        return (Item)this.itemRegistry.update((Identifiable)element);
    }

    public @Nullable Item remove(String key) {
        if (this.items.remove(key)) {
            return this.scriptedProvider.remove(key);
        }
        return (Item)this.itemRegistry.remove((Object)key);
    }

    public Item getItem(String name) throws ItemNotFoundException {
        return this.itemRegistry.getItem(name);
    }

    public Item getItemByPattern(String name) throws ItemNotFoundException, ItemNotUniqueException {
        return this.itemRegistry.getItemByPattern(name);
    }

    public Collection<Item> getItems() {
        return this.itemRegistry.getItems();
    }

    public Collection<Item> getItemsOfType(String type) {
        return this.itemRegistry.getItemsOfType(type);
    }

    public Collection<Item> getItems(String pattern) {
        return this.itemRegistry.getItems(pattern);
    }

    public Collection<Item> getItemsByTag(String ... tags) {
        return this.itemRegistry.getItemsByTag(tags);
    }

    public Collection<Item> getItemsByTagAndType(String type, String ... tags) {
        return this.itemRegistry.getItemsByTagAndType(type, tags);
    }

    public <T extends Item> Collection<T> getItemsByTag(Class<T> typeFilter, String ... tags) {
        return this.itemRegistry.getItemsByTag(typeFilter, tags);
    }

    public @Nullable Item remove(String itemName, boolean recursive) {
        Item item = this.get(itemName);
        if (recursive && item instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)item;
            for (String member : this.getMemberNamesRecursively(groupItem, this.getAll())) {
                this.remove(member);
            }
        }
        if (item != null) {
            this.remove(item.getName());
            return item;
        }
        return null;
    }

    @Override
    public void removeAllAddedByScript() {
        for (String item : this.items) {
            this.scriptedProvider.remove(item);
        }
        this.items.clear();
    }

    private List<String> getMemberNamesRecursively(GroupItem groupItem, Collection<Item> allItems) {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (Item item : allItems) {
            if (!item.getGroupNames().contains(groupItem.getName())) continue;
            memberNames.add(item.getName());
            if (!(item instanceof GroupItem)) continue;
            GroupItem groupItem1 = (GroupItem)item;
            memberNames.addAll(this.getMemberNamesRecursively(groupItem1, allItems));
        }
        return memberNames;
    }
}

