/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssStubElementTypes;
import com.intellij.psi.css.inspections.CssApiBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public final class CssInvalidNestedSelectorInspection
extends CssApiBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidNestedSelectorInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssSelectorList(CssSelectorList selectorList) {
                PsiElement parent = selectorList.getParent();
                PsiElement grandParent = parent.getParent();
                PsiElement grandGrandParent = grandParent.getParent();
                if (parent.getNode().getElementType() == CssStubElementTypes.CSS_RULESET && grandParent.getNode().getElementType() == CssElementTypes.CSS_DECLARATION_BLOCK && grandGrandParent.getNode().getElementType() == CssStubElementTypes.CSS_RULESET) {
                    for (CssSelector selector : selectorList.getSelectors()) {
                        CssSimpleSelector firstSimpleSelector;
                        ASTNode[] children;
                        if (selector.getSimpleSelectors().length == 0 || (children = (firstSimpleSelector = selector.getSimpleSelectors()[0]).getNode().getChildren(TokenSet.ANY)).length != 2 || children[0].getText().equals("&") || children[0].getText().equals("*")) continue;
                        holder.registerProblem((PsiElement)firstSimpleSelector, CssBundle.message("css.inspections.invalid.nested.selector.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{CssFixFactory.getInstance().wrapNestedSelectorQuickFix(), CssFixFactory.getInstance().addAmpersandBeforeNestedSelectorQuickFix()});
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidNestedSelectorInspection", "buildVisitor"));
    }
}

