/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLineFileDescriptor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8StackTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.TableWithFixedWidth;
import java.io.IOException;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackTraceTable
extends TableWithFixedWidth
implements UiDataProvider {
    private final Project myProject;

    public StackTraceTable(Project project, V8StackTableModel model) throws IOException {
        super(model);
        this.myProject = project;
        this.setSelectionMode(0);
    }

    @Nullable
    public V8CpuLogCall getCall() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return ((V8StackTableModel)this.getModel()).getCall(row);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        V8CpuLogCall call;
        if (sink == null) {
            StackTraceTable.$$$reportNull$$$0(0);
        }
        V8ProfileLineFileDescriptor descriptor = (call = this.getCall()) == null ? null : call.getDescriptor();
        sink.set(V8Utils.NAVIGATION_POSITION, descriptor == null ? null : Pair.create((Object)descriptor.getRow(), (Object)descriptor.getCol()));
        sink.set(V8Utils.IS_NAVIGATABLE, call == null ? null : Boolean.valueOf(call.getDescriptor() != null));
        sink.set(V8Utils.SELECTED_CALL, (Object)call);
        if (call == null) {
            return;
        }
        sink.lazy(V8Utils.NAVIGATABLE_ONLY_FOR_ACTION, () -> call.getNavigatables(this.myProject));
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return ((V8StackTableModel)this.getModel()).getCellRenderer(row, column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/StackTraceTable", "uiDataSnapshot"));
    }
}

