/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.SizeOffset;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class LinksWriter<T>
implements Closeable {
    private final File myNumFile;
    private final File myLinksFile;
    private final RawSerializer<T> mySerializer;
    private final SequentialRawWriter<SizeOffset> myNumLinksWriter;
    private final SequentialRawWriter<T> myLinksWriter;
    private long myOffset;

    public LinksWriter(File numFile, File linksFile, RawSerializer<T> serializer) throws FileNotFoundException {
        this.myNumFile = numFile;
        this.myLinksFile = linksFile;
        this.mySerializer = serializer;
        this.myNumLinksWriter = new SequentialRawWriter<SizeOffset>(this.myNumFile, SizeOffset.MySerializer.getInstance());
        this.myLinksWriter = new SequentialRawWriter<T>(this.myLinksFile, serializer);
        this.myOffset = 0L;
    }

    public void write(@NotNull Collection<T> coll) throws IOException {
        if (coll == null) {
            LinksWriter.$$$reportNull$$$0(0);
        }
        for (T t : coll) {
            this.myLinksWriter.write(t);
        }
        this.myNumLinksWriter.write(new SizeOffset(coll.size(), this.myOffset));
        this.myOffset += (long)coll.size();
    }

    public void writeVariableValue(@NotNull T t) throws IOException {
        if (t == null) {
            LinksWriter.$$$reportNull$$$0(1);
        }
        int size = this.myLinksWriter.write(t);
        this.myNumLinksWriter.write(new SizeOffset(size, this.myOffset));
        this.myOffset += (long)size;
    }

    @Override
    public void close() throws IOException {
        this.myLinksWriter.close();
        this.myNumLinksWriter.close();
    }

    public LinksReaderFactory<T> getFactory() {
        return new LinksReaderFactory<T>(this.mySerializer, this.myNumFile, this.myLinksFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coll";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/io/LinksWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeVariableValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

