/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.libraries.nuxt.library;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.libraries.nuxt.library.NuxtFolderEntity;
import org.jetbrains.vuejs.libraries.nuxt.library.NuxtFolderLibrary;
import org.jetbrains.vuejs.libraries.nuxt.library.NuxtFolderManagerState;

@Service(value={Service.Level.PROJECT})
@State(name="DotNuxtFolderManager", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002#$B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\nJ\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManagerState;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "folders", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "", "nuxtFolders", "", "getNuxtFolders", "()Ljava/util/List;", "getState", "loadState", "", "state", "isAccepted", "nuxtFolder", "asNewFolder", "addIfMissing", "addExcludeEntity", "addOrUpdateLibraryEntity", "doCreateLibrary", "findEntities", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "nuxtFolderUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "dispose", "Companion", "NuxtFileListener", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nNuxtFolderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n774#2:195\n865#2,2:196\n1563#2:198\n1634#2,3:199\n1617#2,9:202\n1869#2:211\n1870#2:213\n1626#2:214\n1869#2,2:215\n1869#2,2:217\n1#3:212\n*S KotlinDebug\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager\n*L\n36#1:195\n36#1:196,2\n43#1:198\n43#1:199,3\n47#1:202,9\n47#1:211\n47#1:213\n47#1:214\n85#1:215,2\n112#1:217,2\n47#1:212\n*E\n"})
public final class NuxtFolderManager
implements PersistentStateComponent<NuxtFolderManagerState>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final ConcurrentHashMap.KeySetView<VirtualFile, Boolean> folders;

    public NuxtFolderManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.folders = ConcurrentHashMap.newKeySet();
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new NuxtFileListener(), (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> getNuxtFolders() {
        void $this$filterTo$iv$iv;
        ConcurrentHashMap.KeySetView<VirtualFile, Boolean> keySetView = this.folders;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"folders");
        Iterable $this$filter$iv = keySetView;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NuxtFolderManagerState getState() {
        void $this$mapTo$iv$iv;
        ConcurrentHashMap.KeySetView<VirtualFile, Boolean> keySetView = this.folders;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"folders");
        Iterable $this$map$iv = keySetView;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void folder;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = folder.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            collection.add(string);
        }
        List list = (List)destination$iv$iv;
        return new NuxtFolderManagerState(list);
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull NuxtFolderManagerState state2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Iterable $this$mapNotNull$iv = state2.folders;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(it);
            if ((file != null && this.isAccepted(file, false) ? file : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newFolders = (List)destination$iv$iv;
        this.folders.clear();
        this.folders.addAll(newFolders);
    }

    private final boolean isAccepted(VirtualFile nuxtFolder, boolean asNewFolder) {
        if (nuxtFolder.isValid() && NuxtFolderManager.Companion.isNuxtFolder(nuxtFolder)) {
            boolean bl;
            if (asNewFolder) {
                ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                ProjectFileIndex projectFileIndex2 = projectFileIndex;
                Object object = ReadAction.compute(() -> NuxtFolderManager.isAccepted$lambda$3(projectFileIndex2, nuxtFolder));
                Intrinsics.checkNotNull((Object)object);
                bl = (Boolean)object;
            } else {
                Object object = ReadAction.compute(() -> NuxtFolderManager.isAccepted$lambda$4(this, nuxtFolder));
                Intrinsics.checkNotNull((Object)object);
                bl = (Boolean)object;
            }
            return bl;
        }
        return false;
    }

    public final void addIfMissing(@NotNull VirtualFile nuxtFolder) {
        Intrinsics.checkNotNullParameter((Object)nuxtFolder, (String)"nuxtFolder");
        if (!this.folders.contains(nuxtFolder) && this.isAccepted(nuxtFolder, true) && this.folders.add(nuxtFolder)) {
            this.addExcludeEntity(nuxtFolder);
            this.addOrUpdateLibraryEntity(nuxtFolder);
        }
    }

    private final void addExcludeEntity(VirtualFile nuxtFolder) {
        Companion.invokeUnderWriteAction(this.project, () -> NuxtFolderManager.addExcludeEntity$lambda$6(this, nuxtFolder));
    }

    private final void addOrUpdateLibraryEntity(VirtualFile nuxtFolder) {
        Function0 runnable = () -> NuxtFolderManager.addOrUpdateLibraryEntity$lambda$7(this, nuxtFolder);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || !application.isDispatchThread() && !application.isReadAccessAllowed()) {
            runnable.invoke();
        } else {
            Future future = application.executeOnPooledThread(() -> NuxtFolderManager.addOrUpdateLibraryEntity$lambda$8(runnable));
            Intrinsics.checkNotNull((Object)future);
        }
    }

    private final void doCreateLibrary(VirtualFile nuxtFolder) {
        NuxtFolderLibrary library = new NuxtFolderLibrary(nuxtFolder);
        Companion.invokeUnderWriteAction(this.project, () -> NuxtFolderManager.doCreateLibrary$lambda$11(this, nuxtFolder, library));
    }

    private final List<WorkspaceEntity> findEntities(EntityStorage storage, VirtualFileUrl nuxtFolderUrl) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)storage.getVirtualFileUrlIndex().findEntitiesByUrl(nuxtFolderUrl), arg_0 -> NuxtFolderManager.findEntities$lambda$12(nuxtFolderUrl, arg_0)));
    }

    public void dispose() {
    }

    private static final Boolean isAccepted$lambda$3(ProjectFileIndex $projectFileIndex, VirtualFile $nuxtFolder) {
        return $projectFileIndex.isInContent($nuxtFolder);
    }

    private static final Boolean isAccepted$lambda$4(NuxtFolderManager this$0, VirtualFile $nuxtFolder) {
        return JSLibraryUtil.isInProjectAndOutsideOfLibraryRoots((Project)this$0.project, (VirtualFile)$nuxtFolder);
    }

    private static final Unit addExcludeEntity$lambda$6$lambda$5(WorkspaceModel $workspaceModel, VirtualFile $nuxtFolder, NuxtFolderManager this$0, MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        VirtualFileUrlManager virtualFileUrlManager = $workspaceModel.getVirtualFileUrlManager();
        VirtualFileUrl nuxtFolderUrl = VirtualFileUrls.toVirtualFileUrl((VirtualFile)$nuxtFolder, (VirtualFileUrlManager)virtualFileUrlManager);
        List<WorkspaceEntity> entities = this$0.findEntities((EntityStorage)storage, nuxtFolderUrl);
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntity p0 = (WorkspaceEntity)element$iv;
            boolean bl = false;
            storage.removeEntity(p0);
        }
        storage.addEntity((WorkspaceEntity.Builder)NuxtFolderEntity.Companion.create$default(NuxtFolderEntity.Companion, nuxtFolderUrl, CollectionsKt.emptyList(), NuxtFolderEntity.MyEntitySource.INSTANCE, null, 8, null));
        return Unit.INSTANCE;
    }

    private static final void addExcludeEntity$lambda$6(NuxtFolderManager this$0, VirtualFile $nuxtFolder) {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this$0.project);
        workspaceModel.updateProjectModel("Exclude .nuxt/ for " + $nuxtFolder.getPath(), arg_0 -> NuxtFolderManager.addExcludeEntity$lambda$6$lambda$5(workspaceModel, $nuxtFolder, this$0, arg_0));
    }

    private static final Unit addOrUpdateLibraryEntity$lambda$7(NuxtFolderManager this$0, VirtualFile $nuxtFolder) {
        this$0.doCreateLibrary($nuxtFolder);
        return Unit.INSTANCE;
    }

    private static final void addOrUpdateLibraryEntity$lambda$8(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit doCreateLibrary$lambda$11$lambda$10(WorkspaceModel $workspaceModel, VirtualFile $nuxtFolder, NuxtFolderManager this$0, NuxtFolderLibrary $library, MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        VirtualFileUrlManager virtualFileUrlManager = $workspaceModel.getVirtualFileUrlManager();
        VirtualFileUrl nuxtFolderUrl = VirtualFileUrls.toVirtualFileUrl((VirtualFile)$nuxtFolder, (VirtualFileUrlManager)virtualFileUrlManager);
        List<WorkspaceEntity> entities = this$0.findEntities((EntityStorage)storage, nuxtFolderUrl);
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntity p0 = (WorkspaceEntity)element$iv;
            boolean bl = false;
            storage.removeEntity(p0);
        }
        storage.addEntity((WorkspaceEntity.Builder)Companion.createEntity$intellij_vuejs($library, virtualFileUrlManager));
        return Unit.INSTANCE;
    }

    private static final void doCreateLibrary$lambda$11(NuxtFolderManager this$0, VirtualFile $nuxtFolder, NuxtFolderLibrary $library) {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this$0.project);
        workspaceModel.updateProjectModel("Include library files from .nuxt/ for " + $nuxtFolder.getPath(), arg_0 -> NuxtFolderManager.doCreateLibrary$lambda$11$lambda$10(workspaceModel, $nuxtFolder, this$0, $library, arg_0));
    }

    private static final boolean findEntities$lambda$12(VirtualFileUrl $nuxtFolderUrl, WorkspaceEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof NuxtFolderEntity && Intrinsics.areEqual((Object)((NuxtFolderEntity)it).getNuxtFolderUrl(), (Object)$nuxtFolderUrl);
    }

    public static final /* synthetic */ void access$addOrUpdateLibraryEntity(NuxtFolderManager $this, VirtualFile nuxtFolder) {
        $this.addOrUpdateLibraryEntity(nuxtFolder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager;", "project", "Lcom/intellij/openapi/project/Project;", "isNuxtFolder", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "invokeUnderWriteAction", "", "runnable", "Ljava/lang/Runnable;", "createEntity", "Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderEntity$Builder;", "library", "Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderLibrary;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "createEntity$intellij_vuejs", "intellij.vuejs"})
    @SourceDebugExtension(value={"SMAP\nNuxtFolderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n30#2,2:195\n1563#3:197\n1634#3,3:198\n*S KotlinDebug\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$Companion\n*L\n129#1:195,2\n150#1:197\n150#1:198,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NuxtFolderManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NuxtFolderManager> serviceClass$iv = NuxtFolderManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NuxtFolderManager)object;
        }

        private final boolean isNuxtFolder(VirtualFile file) {
            return file.isDirectory() && Intrinsics.areEqual((Object)file.getName(), (Object)".nuxt");
        }

        public final void invokeUnderWriteAction(@NotNull Project project, @NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                WriteAction.runAndWait(() -> Companion.invokeUnderWriteAction$lambda$0(runnable));
            }
            Function0 runnableUnderWriteAction = () -> Companion.invokeUnderWriteAction$lambda$1(application, runnable);
            if (application.isWriteIntentLockAcquired()) {
                runnableUnderWriteAction.invoke();
            } else {
                application.invokeLater(() -> Companion.invokeUnderWriteAction$lambda$2(runnableUnderWriteAction), application.getDefaultModalityState(), project.getDisposed());
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NuxtFolderEntity.Builder createEntity$intellij_vuejs(@NotNull NuxtFolderLibrary library, @NotNull VirtualFileUrlManager virtualFileUrlManager) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
            Iterable $this$map$iv = library.getLibraryFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VirtualFileUrls.toVirtualFileUrl((VirtualFile)it, (VirtualFileUrlManager)virtualFileUrlManager));
            }
            List fileUrls = (List)destination$iv$iv;
            return NuxtFolderEntity.Companion.create$default(NuxtFolderEntity.Companion, VirtualFileUrls.toVirtualFileUrl((VirtualFile)library.getNuxtFolder(), (VirtualFileUrlManager)virtualFileUrlManager), fileUrls, NuxtFolderEntity.MyEntitySource.INSTANCE, null, 8, null);
        }

        private static final void invokeUnderWriteAction$lambda$0(Runnable $runnable) {
            $runnable.run();
        }

        private static final Unit invokeUnderWriteAction$lambda$1(Application $application, Runnable $runnable) {
            $application.runWriteAction($runnable);
            return Unit.INSTANCE;
        }

        private static final void invokeUnderWriteAction$lambda$2(Function0 $tmp0) {
            $tmp0.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$NuxtFileListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "(Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager;)V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "findNuxtFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "isRelevantEvent", "", "event", "intellij.vuejs"})
    @SourceDebugExtension(value={"SMAP\nNuxtFolderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$NuxtFileListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n774#2:195\n865#2,2:196\n*S KotlinDebug\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$NuxtFileListener\n*L\n157#1:195\n157#1:196,2\n*E\n"})
    private final class NuxtFileListener
    implements AsyncFileListener {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$filter$iv = events;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VFileEvent it = (VFileEvent)element$iv$iv;
                boolean bl = false;
                if (!this.isRelevantEvent(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List relevantEvents = (List)destination$iv$iv;
            return relevantEvents.isEmpty() ? null : (AsyncFileListener.ChangeApplier)new AsyncFileListener.ChangeApplier(relevantEvents, this, NuxtFolderManager.this){
                final /* synthetic */ List<VFileEvent> $relevantEvents;
                final /* synthetic */ NuxtFileListener this$0;
                final /* synthetic */ NuxtFolderManager this$1;
                {
                    this.$relevantEvents = $relevantEvents;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void afterVfsChange() {
                    for (VFileEvent event : this.$relevantEvents) {
                        VirtualFile virtualFile;
                        if (!(event instanceof VFileCreateEvent)) continue;
                        VirtualFile virtualFile2 = ((VFileCreateEvent)event).getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
                        if (NuxtFileListener.access$findNuxtFolder(this.this$0, virtualFile2) == null) continue;
                        NuxtFolderManager nuxtFolderManager = this.this$1;
                        VirtualFile it = virtualFile;
                        boolean bl = false;
                        NuxtFolderManager.access$addOrUpdateLibraryEntity(nuxtFolderManager, it);
                    }
                }
            };
        }

        private final VirtualFile findNuxtFolder(VirtualFile file) {
            return (VirtualFile)JSProjectUtil.traverseUpAndFindFirst((VirtualFile)file, arg_0 -> NuxtFileListener.findNuxtFolder$lambda$2(arg_0 -> NuxtFileListener.findNuxtFolder$lambda$1(NuxtFolderManager.this, arg_0), arg_0));
        }

        private final boolean isRelevantEvent(VFileEvent event) {
            if (event instanceof VFileCreateEvent) {
                VirtualFile virtualFile = ((VFileCreateEvent)event).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
                return this.findNuxtFolder(virtualFile) != null;
            }
            return false;
        }

        private static final VirtualFile findNuxtFolder$lambda$1(NuxtFolderManager this$0, VirtualFile it) {
            return this$0.folders.contains(it) ? it : null;
        }

        private static final VirtualFile findNuxtFolder$lambda$2(Function1 $tmp0, Object p0) {
            return (VirtualFile)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ VirtualFile access$findNuxtFolder(NuxtFileListener $this, VirtualFile file) {
            return $this.findNuxtFolder(file);
        }
    }
}

