/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVarStatementAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private Alignment myEqualsSignAlignment;
    private Alignment myIdentifierAlignment;
    @JSCodeStyleSettings.VarStatementAlignment
    private final int mySettingsValue;

    public JSVarStatementAlignmentFactory(JSCodeStyleSettings jsCodeStyleSettings) {
        this.resetAlignments();
        this.mySettingsValue = jsCodeStyleSettings.ALIGN_VAR_STATEMENTS;
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        ASTNode parent;
        if (child == null) {
            JSVarStatementAlignmentFactory.$$$reportNull$$$0(0);
        }
        IElementType childType = child.getElementType();
        if (this.mySettingsValue != 0 && (parent = child.getTreeParent()) != null) {
            ASTNode statement;
            IElementType parentType = parent.getElementType();
            if ((JSExtendedLanguagesTokenSetProvider.BODY_VARIABLES.contains(parentType) || JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS.contains(parentType)) && child.getElementType() == JSTokenTypes.EQ) {
                return this.myEqualsSignAlignment;
            }
            if (JSElementTypes.VAR_STATEMENTS.contains(parentType)) {
                this.resetAlignmentIfNeeded(parent, child);
                if (!JSTokenTypes.VAR_MODIFIERS.contains(childType) && childType != JSTokenTypes.SEMICOLON && childType != JSTokenTypes.COMMA && parent.getFirstChildNode() != child) {
                    return this.myIdentifierAlignment;
                }
            } else if (this.mySettingsValue == 2 && parentType == JSStubElementTypes.ASSIGNMENT_EXPRESSION && JSVarStatementAlignmentFactory.isAssignmentExpression(statement = parent.getTreeParent())) {
                this.resetAlignmentIfNeeded(statement, child);
                if (childType == JSTokenTypes.EQ) {
                    return this.myEqualsSignAlignment;
                }
            }
        }
        return null;
    }

    private void resetAlignmentIfNeeded(@NotNull ASTNode statement, @NotNull ASTNode child) {
        ASTNode beforeStatement;
        int statementStart;
        if (statement == null) {
            JSVarStatementAlignmentFactory.$$$reportNull$$$0(1);
        }
        if (child == null) {
            JSVarStatementAlignmentFactory.$$$reportNull$$$0(2);
        }
        if ((statementStart = JSVarStatementAlignmentFactory.getStatementStartSkipComments(statement)) == -1) {
            return;
        }
        if (statementStart != child.getTextRange().getStartOffset()) {
            return;
        }
        if (JSElementTypes.VAR_STATEMENTS.contains(statement.getElementType())) {
            this.myIdentifierAlignment = Alignment.createAlignment();
            if (this.mySettingsValue == 1) {
                this.myEqualsSignAlignment = Alignment.createAlignment((boolean)true);
                return;
            }
        }
        if ((beforeStatement = JSVarStatementAlignmentFactory.getPreviousSiblingIfClose(statement)) == null || !JSVarStatementAlignmentFactory.isAssignmentExpression(beforeStatement) && !JSElementTypes.VAR_STATEMENTS.contains(beforeStatement.getElementType())) {
            this.resetAlignments();
        }
    }

    @Nullable
    protected static ASTNode getPreviousSiblingIfClose(@NotNull ASTNode statement) {
        ASTNode prev;
        if (statement == null) {
            JSVarStatementAlignmentFactory.$$$reportNull$$$0(3);
        }
        if ((prev = statement.getTreePrev()) instanceof PsiWhiteSpace) {
            if (StringUtil.getLineBreakCount((CharSequence)prev.getChars()) > 1) {
                return null;
            }
            prev = prev.getTreePrev();
        }
        if (prev != null) {
            if (prev.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && (prev = prev.getTreePrev()) instanceof PsiWhiteSpace) {
                if (StringUtil.getLineBreakCount((CharSequence)prev.getChars()) > 1) {
                    return null;
                }
                prev = prev.getTreePrev();
            }
            return prev;
        }
        return null;
    }

    private static boolean isAssignmentExpression(@NotNull ASTNode node) {
        if (node == null) {
            JSVarStatementAlignmentFactory.$$$reportNull$$$0(4);
        }
        if (node.getElementType() == JSElementTypes.EXPRESSION_STATEMENT) {
            ASTNode child = node.getFirstChildNode();
            return child != null && child.getElementType() == JSStubElementTypes.ASSIGNMENT_EXPRESSION;
        }
        return false;
    }

    private void resetAlignments() {
        this.myEqualsSignAlignment = Alignment.createAlignment((boolean)true);
        this.myIdentifierAlignment = Alignment.createAlignment();
    }

    private static int getStatementStartSkipComments(@NotNull ASTNode statement) {
        if (statement == null) {
            JSVarStatementAlignmentFactory.$$$reportNull$$$0(5);
        }
        for (ASTNode child = statement.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiElement psiElement = child.getPsi();
            if (psiElement instanceof PsiComment || psiElement instanceof PsiWhiteSpace) continue;
            return child.getTextRange().getStartOffset();
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/alignment/JSVarStatementAlignmentFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlignment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resetAlignmentIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviousSiblingIfClose";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignmentExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementStartSkipComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

