/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public final class JSDocReferenceSet
extends JSReferenceSet {
    private static final String GLOBAL_PREFIX = "global#";
    private final boolean myAddEventPrefix;
    private final boolean myAddModulePrefix;
    private boolean myOnlyDefaultPackage;

    public JSDocReferenceSet(@NotNull PsiElement element2, String text, int offset, boolean soft) {
        if (element2 == null) {
            JSDocReferenceSet.$$$reportNull$$$0(0);
        }
        this(element2, text, offset, soft, false, false);
    }

    public JSDocReferenceSet(@NotNull PsiElement element2, String text, int offset, boolean soft, boolean addEventPrefix, boolean addModulePrefix) {
        if (element2 == null) {
            JSDocReferenceSet.$$$reportNull$$$0(1);
        }
        super(element2, soft);
        this.myAddEventPrefix = addEventPrefix;
        this.myAddModulePrefix = addModulePrefix;
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myReferences = this.reparse(text, offset);
    }

    public boolean isOnlyDefaultPackage() {
        return this.myOnlyDefaultPackage;
    }

    @Override
    protected PsiReference @NotNull [] reparse(@NotNull String value, int offset) {
        if (value == null) {
            JSDocReferenceSet.$$$reportNull$$$0(2);
        }
        if (value.startsWith(GLOBAL_PREFIX)) {
            value = value.substring(GLOBAL_PREFIX.length());
            offset += GLOBAL_PREFIX.length();
            this.myOnlyDefaultPackage = true;
        }
        SmartList refs = new SmartList();
        int dotPos = -1;
        int lastPos = 0;
        int lastLength = -1;
        while (dotPos < value.length()) {
            int startOffset;
            int nextDotPos;
            if (dotPos == -1) {
                if (!value.isEmpty() && StringUtil.containsChar((String)".#~", (char)value.charAt(0))) {
                    ++dotPos;
                }
            } else if (!StringUtil.containsChar((String)".#~", (char)value.charAt(dotPos))) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    JSDocReferenceSet.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            if ((nextDotPos = JSDocumentationUtils.findNextNamepathSeparator(value, startOffset = dotPos + 1)) == -1) break;
            if (lastLength > 0) {
                refs.add(new JSDocReference(this, value.substring(lastPos, lastPos + lastLength), TextRange.from((int)(offset + lastPos), (int)lastLength), false));
            }
            lastPos = startOffset;
            lastLength = nextDotPos - startOffset;
            dotPos = nextDotPos;
        }
        if (lastLength > 0) {
            Object s = value.substring(lastPos, lastPos + lastLength);
            int index = 0;
            boolean isMethodRef = lastPos > 0 && value.charAt(lastPos - 1) == '#';
            TextRange range = TextRange.from((int)(offset + lastPos + index), (int)((String)s).length());
            if (this.myAddEventPrefix && !((String)s).startsWith("event:")) {
                s = "event:" + (String)s;
            }
            if (this.myAddModulePrefix && !((String)s).startsWith("module:")) {
                s = "module:" + (String)s;
            }
            refs.add(new JSDocReference(this, (String)s, range, isMethodRef));
        }
        PsiReference[] psiReferenceArray = !refs.isEmpty() ? refs.toArray(PsiReference.EMPTY_ARRAY) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            JSDocReferenceSet.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReferenceSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reparse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

