/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.QueueProcessor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDependencyFinder {
    public static final ExtensionPointName<FileDependencyFinder> EP_NAME = ExtensionPointName.create((String)"com.intellij.plugins.watcher.dependency.finder");
    private static final QueueProcessor<Runnable> QUEUE_PROCESSOR = QueueProcessor.createRunnableQueueProcessor((QueueProcessor.ThreadToUse)QueueProcessor.ThreadToUse.POOLED);

    public abstract boolean accept(@Nullable String var1);

    public boolean trackAllDependentFiles() {
        return true;
    }

    public boolean updateGeneratedFilesOfDependencies() {
        return false;
    }

    @NotNull
    public Set<VirtualFile> findDependentFiles(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            FileDependencyFinder.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            FileDependencyFinder.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            FileDependencyFinder.$$$reportNull$$$0(2);
        }
        if (DumbService.isDumb((Project)project)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileDependencyFinder.$$$reportNull$$$0(3);
            }
            return set;
        }
        if (!virtualFile.isValid()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileDependencyFinder.$$$reportNull$$$0(4);
            }
            return set;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileDependencyFinder.$$$reportNull$$$0(5);
            }
            return set;
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        FileIncludeManager.getManager((Project)project).processIncludingFiles(psiFile, pair -> {
            VirtualFile file = (VirtualFile)pair.getFirst();
            if (scope.contains(file)) {
                result.add(file);
            }
            return true;
        });
        HashSet<VirtualFile> hashSet = result;
        if (hashSet == null) {
            FileDependencyFinder.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public void findDependenciesAsync(@NotNull Project project, @NotNull VirtualFile file, @NotNull GlobalSearchScope scope, boolean recursively, @NotNull Consumer<Set<VirtualFile>> dependenciesConsumer) {
        if (project == null) {
            FileDependencyFinder.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileDependencyFinder.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            FileDependencyFinder.$$$reportNull$$$0(9);
        }
        if (dependenciesConsumer == null) {
            FileDependencyFinder.$$$reportNull$$$0(10);
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> QUEUE_PROCESSOR.add(() -> ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed() || !file.isValid()) {
                dependenciesConsumer.accept(Collections.emptySet());
                return;
            }
            VirtualFile[] dependencyArray = FileIncludeManager.getManager((Project)project).getIncludedFiles(file, true, recursively);
            if (dependencyArray == null || dependencyArray.length == 0) {
                dependenciesConsumer.accept(Collections.emptySet());
                return;
            }
            HashSet<VirtualFile> result = new HashSet<VirtualFile>(dependencyArray.length);
            for (VirtualFile dependency : dependencyArray) {
                if (!scope.accept(dependency)) continue;
                result.add(dependency);
            }
            dependenciesConsumer.accept(result);
        })), ModalityState.any());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/config/FileDependencyFinder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/config/FileDependencyFinder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependentFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDependentFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDependenciesAsync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

