/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.fus;

import com.intellij.dbt.console.commands.DbtCommand;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/dbt/fus/DbtRunConfigurationCounterCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "DBT_COMMANDS", "", "", "getDBT_COMMANDS", "()Ljava/util/List;", "RUN_CONFIGURATION_INVOKED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "logRunEvent", "", "command", "Lcom/intellij/dbt/console/commands/DbtCommand;", "intellij.dbt"})
public final class DbtRunConfigurationCounterCollector
extends CounterUsagesCollector {
    @NotNull
    public static final DbtRunConfigurationCounterCollector INSTANCE = new DbtRunConfigurationCounterCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("dbt.run.configuration.invocation", 1, null, 4, null);
    @NotNull
    private static final List<String> DBT_COMMANDS;
    @NotNull
    private static final EventId1<String> RUN_CONFIGURATION_INVOKED_EVENT;

    private DbtRunConfigurationCounterCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final List<String> getDBT_COMMANDS() {
        return DBT_COMMANDS;
    }

    public final void logRunEvent(@NotNull DbtCommand command) {
        Intrinsics.checkNotNullParameter((Object)((Object)command), (String)"command");
        String commandName = command.toString();
        if (DBT_COMMANDS.contains(commandName)) {
            RUN_CONFIGURATION_INVOKED_EVENT.log((Object)commandName);
        }
    }

    static {
        Object[] objectArray = new String[]{"build", "clone", "compile", "debug", "deps", "docs", "list", "retry", "run", "run-operation", "seed", "show", "snapshot", "source", "test"};
        DBT_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
        RUN_CONFIGURATION_INVOKED_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"run.configuration.invoked", (EventField)((EventField)EventFields.String((String)"name", DBT_COMMANDS)), null, (int)4, null);
    }
}

