/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.PseudoCylindricalProjection;

public class BoggsProjection
extends PseudoCylindricalProjection {
    private static final int NITER = 20;
    private static final double EPS = 1.0E-7;
    private static final double ONETOL = 1.000001;
    private static final double FXC = 2.00276;
    private static final double FXC2 = 1.11072;
    private static final double FYC = 0.49931;
    private static final double FYC2 = 1.4142135623730951;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double theta = lpphi;
        if (Math.abs(Math.abs(lpphi) - 1.5707963267948966) < 1.0E-7) {
            out.x = 0.0;
        } else {
            double c2 = Math.sin(theta) * Math.PI;
            for (int i2 = 20; i2 > 0; --i2) {
                double th1 = (theta + Math.sin(theta) - c2) / (1.0 + Math.cos(theta));
                theta -= th1;
                if (Math.abs(th1) < 1.0E-7) break;
            }
            out.x = 2.00276 * lplam / (1.0 / Math.cos(lpphi) + 1.11072 / Math.cos(theta *= 0.5));
        }
        out.y = 0.49931 * (lpphi + 1.4142135623730951 * Math.sin(theta));
        return out;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return false;
    }

    @Override
    public String toString() {
        return "Boggs Eumorphic";
    }
}

