/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NioTrackingFileManager
implements TrackingFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioTrackingFileManager.class);

    NioTrackingFileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties read(@NotNull File file) {
        if (file == null) {
            NioTrackingFileManager.$$$reportNull$$$0(0);
        }
        Object object = NioTrackingFileManager.getMutex(file);
        synchronized (object) {
            return NioTrackingFileManager.read(file.toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties update(@NotNull File file, @NotNull @NotNull Map<@NotNull String, @Nullable String> updates) {
        if (file == null) {
            NioTrackingFileManager.$$$reportNull$$$0(1);
        }
        if (updates == null) {
            NioTrackingFileManager.$$$reportNull$$$0(2);
        }
        Object object = NioTrackingFileManager.getMutex(file);
        synchronized (object) {
            return NioTrackingFileManager.update(file.toPath(), updates);
        }
    }

    @Nullable
    private static Properties read(@NotNull Path path) {
        Properties properties;
        block10: {
            if (path == null) {
                NioTrackingFileManager.$$$reportNull$$$0(3);
            }
            if (!Files.isReadable(path)) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.ISO_8859_1);
            try {
                Properties properties2 = new Properties();
                properties2.load(reader);
                properties = properties2;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to read tracking file '{}'", (Object)path, (Object)e);
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return properties;
    }

    @NotNull
    private static Properties update(@NotNull Path path, @NotNull @NotNull Map<@NotNull String, @Nullable String> updates) {
        if (path == null) {
            NioTrackingFileManager.$$$reportNull$$$0(4);
        }
        if (updates == null) {
            NioTrackingFileManager.$$$reportNull$$$0(5);
        }
        Properties properties = NioTrackingFileManager.getUpdatedProperties(path, updates);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create tracking file parent '{}'", (Object)path, (Object)e);
            throw new UncheckedIOException(e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.ISO_8859_1, new OpenOption[0]);){
            properties.store(writer, null);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write tracking file '{}'", (Object)path, (Object)e);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            NioTrackingFileManager.$$$reportNull$$$0(6);
        }
        return properties2;
    }

    @NotNull
    private static Properties getUpdatedProperties(@NotNull Path path, @NotNull @NotNull Map<@NotNull String, @Nullable String> updates) {
        if (path == null) {
            NioTrackingFileManager.$$$reportNull$$$0(7);
        }
        if (updates == null) {
            NioTrackingFileManager.$$$reportNull$$$0(8);
        }
        Properties properties = Objects.requireNonNullElseGet(NioTrackingFileManager.read(path), () -> new Properties());
        if (updates.isEmpty()) {
            Properties properties2 = properties;
            if (properties2 == null) {
                NioTrackingFileManager.$$$reportNull$$$0(9);
            }
            return properties2;
        }
        for (Map.Entry<String, String> update : updates.entrySet()) {
            if (update.getValue() == null) {
                properties.remove(update.getKey());
                continue;
            }
            properties.setProperty(update.getKey(), update.getValue());
        }
        Properties properties3 = properties;
        if (properties3 == null) {
            NioTrackingFileManager.$$$reportNull$$$0(10);
        }
        return properties3;
    }

    @NotNull
    private static Object getMutex(@NotNull File file) {
        String string;
        if (file == null) {
            NioTrackingFileManager.$$$reportNull$$$0(11);
        }
        try {
            string = file.getCanonicalPath().intern();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to canonicalize path {}", (Object)file, (Object)e);
            String string2 = file.getAbsolutePath().intern();
            if (string2 == null) {
                NioTrackingFileManager.$$$reportNull$$$0(13);
            }
            return string2;
        }
        if (string == null) {
            NioTrackingFileManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/aether/NioTrackingFileManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/aether/NioTrackingFileManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedProperties";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMutex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

