/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.css.util.CssTermTypeUtil;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.lexer.SASSLexer;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;
import org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;

public class SASSHighlighterLexer
extends CssHighlighterLexer {
    private static final int MY_AFTER_AFTER_VARIABLE_FLAG = 1;
    private static final int MY_AFTER_VARIABLE_FLAG = 2;
    private static final int MY_AFTER_EQUALS_FLAG = 4;
    private static final int MY_AFTER_NUMBER_FLAG = 8;
    private static final int MY_AFTER_AFTER_COLON_FLAG = 16;
    private static final int MY_AFTER_IDENT_FLAG = 32;
    private static final int MY_AFTER_AFTER_WHITESPACE_FLAG = 64;
    private static final int MY_AFTER_WHITESPACE_FLAG = 128;
    private static final int MY_AFTER_ESCAPED_COLON_FLAG = 256;
    private boolean myAfterEscapedColon;
    private boolean myAfterAfterVariable;
    private boolean myAfterVariable;
    private boolean myAfterEquals;
    private boolean myAfterNumber;
    private boolean myAfterAfterColon;
    private boolean myAfterIdent;
    private boolean myAfterWhitespace;
    private boolean myAfterAfterWhitespace;
    private final SASSLexer lookAheadLexer;

    @Deprecated
    public SASSHighlighterLexer(@NotNull Set<String> propertyValues) {
        if (propertyValues == null) {
            SASSHighlighterLexer.$$$reportNull$$$0(0);
        }
        super((Lexer)new SASSLexer());
        this.myAfterEscapedColon = false;
        this.myAfterAfterVariable = false;
        this.myAfterVariable = false;
        this.myAfterEquals = false;
        this.myAfterNumber = false;
        this.myAfterAfterColon = false;
        this.myAfterIdent = false;
        this.myAfterWhitespace = true;
        this.myAfterAfterWhitespace = true;
        this.lookAheadLexer = new SASSLexer();
    }

    public SASSHighlighterLexer() {
        super((Lexer)new SASSLexer());
        this.myAfterEscapedColon = false;
        this.myAfterAfterVariable = false;
        this.myAfterVariable = false;
        this.myAfterEquals = false;
        this.myAfterNumber = false;
        this.myAfterAfterColon = false;
        this.myAfterIdent = false;
        this.myAfterWhitespace = true;
        this.myAfterAfterWhitespace = true;
        this.lookAheadLexer = new SASSLexer();
    }

    protected void initState(int initialState) {
        super.initState(initialState);
        int state = initialState >> 24;
        this.myAfterEscapedColon = (state & 0x100) != 0;
        this.myAfterAfterVariable = (state & 1) != 0;
        this.myAfterVariable = (state & 2) != 0;
        this.myAfterEquals = (state & 4) != 0;
        this.myAfterNumber = (state & 8) != 0;
        this.myAfterAfterColon = (state & 0x10) != 0;
        this.myAfterIdent = (state & 0x20) != 0;
        this.myAfterWhitespace = (state & 0x80) != 0;
        this.myAfterAfterWhitespace = (state & 0x40) != 0;
    }

    public int getState() {
        int state = 0;
        state |= this.myAfterEscapedColon ? 256 : 0;
        state |= this.myAfterAfterVariable ? 1 : 0;
        state |= this.myAfterVariable ? 2 : 0;
        state |= this.myAfterEquals ? 4 : 0;
        state |= this.myAfterNumber ? 8 : 0;
        state |= this.myAfterAfterColon ? 16 : 0;
        state |= this.myAfterIdent ? 32 : 0;
        state |= this.myAfterAfterWhitespace ? 64 : 0;
        return super.getState() | (state |= this.myAfterWhitespace ? 128 : 0) << 24;
    }

    public boolean isSelectorAllowed() {
        return (this.myAfterEscapedColon || !this.spaceColon() && !this.colonSpace()) && !this.isPropertyValueAllowed();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            SASSHighlighterLexer.$$$reportNull$$$0(1);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.lookAheadLexer.start(this.getDelegate().getBufferSequence(), this.getDelegate().getTokenStart(), this.getDelegate().getBufferEnd(), this.getDelegate().getState());
    }

    public boolean isPropertyValueAllowed() {
        if (this.myAfterNumber && CssTermTypeUtil.getTypeBySuffix((String)this.getCurrentTokenText()) != CssTermType.UNKNOWN) {
            return true;
        }
        return this.myFunctionNestingDepth > 0 || (this.myAfterWhitespace || this.myAfterAfterVariable) && (this.myAfterColon || this.colonIdentifier());
    }

    public boolean isPropertyNameAllowed() {
        return !(this.myAfterEscapedColon || !this.myInsideBlock && !this.myAfterMediaOrSupports || !this.spaceColon() && !this.colonSpace());
    }

    public void advance() {
        IElementType tokenType = this.getTokenType();
        this.myAfterAfterWhitespace = this.myAfterWhitespace;
        this.myAfterAfterVariable = this.myAfterVariable;
        this.myAfterWhitespace = SASSHighlighterLexer.isWhitespace(tokenType);
        if (!SASSHighlighterLexer.isWhitespace(tokenType)) {
            this.myAfterAfterColon = this.myJustAfterColon;
            this.myAfterIdent = tokenType == SASSTokenTypes.IDENTIFIER;
            this.myAfterVariable = tokenType == SASSTokenTypes.VARIABLE;
        }
        this.myAfterEquals = tokenType == SASSTokenTypes.EQUALS;
        this.myAfterNumber = tokenType == SASSTokenTypes.NUMBER;
        this.myAfterEscapedColon = tokenType == CssElementTypes.CSS_COLON && "\\:".equals(this.getTokenText());
        super.advance();
        if (tokenType == SASSTokenTypes.EOL) {
            this.myInsideBlock = false;
            this.myAfterColon = false;
        } else if (tokenType == SASSTokenTypes.INDENT) {
            this.myInsideBlock = true;
        }
    }

    protected void updateMyInsideBlock() {
    }

    public IElementType getTokenType() {
        String tokenText;
        if (this.lastElementType != null) {
            return this.lastElementType;
        }
        IElementType type = this.getDelegate().getTokenType();
        if (type == SASSTokenTypes.IDENTIFIER && this.myAfterEquals) {
            this.lastElementType = SASSTokenTypes.MIXIN;
            return this.lastElementType;
        }
        if (SCSSTokenTypes.KEYWORDS.contains(type)) {
            this.lastElementType = type;
            return this.lastElementType;
        }
        if (type == CssElementTypes.CSS_PERCENT && this.lookAhead(1, false) == CssElementTypes.CSS_IDENT) {
            return CssElementTypes.CSS_IDENT;
        }
        if (type == CssElementTypes.CSS_IDENT && !this.myInKeyframes && ("from".equals(tokenText = this.getCurrentTokenText()) || "through".equals(tokenText) || "to".equals(tokenText))) {
            this.lastElementType = SASSTokenTypes.KEYWORD;
            return this.lastElementType;
        }
        if (type == CssElementTypes.CSS_IDENT && this.lookAhead(1, false) == SASSTokenTypes.WHITE_SPACE && this.lookAhead(2, false) == CssElementTypes.CSS_LPAREN) {
            return CssElementTypes.CSS_FUNCTION_TOKEN;
        }
        return super.getTokenType();
    }

    protected Lexer getLookAheadLexer() {
        return this.lookAheadLexer;
    }

    private boolean colonIdentifier() {
        return this.myAfterAfterColon && this.myAfterIdent;
    }

    private boolean colonSpace() {
        return this.lookAhead(1, false) == SASSTokenTypes.COLON && SASSHighlighterLexer.isWhitespace(this.lookAhead(2, false));
    }

    private boolean spaceColon() {
        return this.myJustAfterColon && this.myAfterAfterWhitespace;
    }

    private static boolean isWhitespace(@Nullable IElementType tokenType) {
        return SASSTokenTypes.WHITESPACE_TOKENS.contains(tokenType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValues";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/sass/lexer/SASSHighlighterLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

