/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceAction;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010\u0015\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J.\u0010\u0016\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "dump", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "elements", "", "Lcom/intellij/database/psi/DbElement;", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "chooseSqlDataSource", "createSqlDataSourceAndDump", "instantiateSqlDataSource", "compatibleSqlDataSources", "isCompatible", "", "Configured", "LayoutAction", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDumpToDdlDataSourceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpToDdlDataSourceAction.kt\ncom/intellij/database/actions/DumpToDdlDataSourceAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,376:1\n1869#2,2:377\n1617#2,9:379\n1869#2:388\n1870#2:390\n1626#2:391\n1617#2,9:393\n1869#2:402\n1870#2:405\n1626#2:406\n1#3:389\n1#3:392\n1#3:404\n19#4:403\n*S KotlinDebug\n*F\n+ 1 DumpToDdlDataSourceAction.kt\ncom/intellij/database/actions/DumpToDdlDataSourceAction\n*L\n125#1:377,2\n129#1:379,9\n129#1:388\n129#1:390\n129#1:391\n188#1:393,9\n188#1:402\n188#1:405\n188#1:406\n129#1:389\n188#1:404\n189#1:403\n*E\n"})
public final class DumpToDdlDataSourceAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Map byDs = DumpToDdlDataSourceActionKt.access$getElementsByDs(e);
        byDs.entrySet().removeIf(arg_0 -> DumpToDdlDataSourceAction.update$lambda$0(update.1.INSTANCE, arg_0));
        e.getPresentation().setEnabledAndVisible(byDs.size() == 1);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Map byDs = DumpToDdlDataSourceActionKt.access$getElementsByDs(e);
        Map.Entry entry = (Map.Entry)SequencesKt.singleOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)byDs.entrySet()), DumpToDdlDataSourceAction::actionPerformed$lambda$1));
        if (entry == null) {
            return;
        }
        Map.Entry entry2 = entry;
        DasDataSource ds = (DasDataSource)entry2.getKey();
        List elements = (List)entry2.getValue();
        Intrinsics.checkNotNull((Object)ds, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.LocalDataSource");
        LocalDataSource cfr_ignored_0 = (LocalDataSource)ds;
        SqlDataSource sqlDs = (SqlDataSource)SequencesKt.singleOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)byDs.keySet()), DumpToDdlDataSourceAction::actionPerformed$lambda$2), arg_0 -> DumpToDdlDataSourceAction.actionPerformed$lambda$3(this, ds, arg_0)));
        if (sqlDs != null) {
            this.dump(project2, (LocalDataSource)ds, elements, sqlDs);
        } else {
            this.chooseSqlDataSource(project2, e, (LocalDataSource)ds, elements);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dump(Project project, LocalDataSource ds, List<? extends DbElement> elements, SqlDataSource sqlDs) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        DasModel dasModel = ds.getModel();
        BasicModel basicModel = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (basicModel == null) {
            return;
        }
        BasicModel model = basicModel;
        DetailsSyncHelper syncHelper = DetailsSyncHelper.of(sqlDs.getProject(), (DasDataSource)ds, null);
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbElement p0 = (DbElement)element$iv;
            boolean bl = false;
            syncHelper.check(p0);
        }
        if (syncHelper.askAbortIfSyncRequired(DatabaseBundle.message((String)"button.dump", (Object[])new Object[0]))) {
            return;
        }
        $this$forEach$iv = elements;
        TreePattern treePattern = ds.getIntrospectionScope();
        BasicModel basicModel2 = model;
        SqlDataSource sqlDataSource = sqlDs;
        Project project2 = project;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            BasicElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DbElement it = (DbElement)element$iv$iv;
            boolean bl2 = false;
            if (DbImplUtil.getMaybeBasicElement((DasObject)((DasObject)it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        DumpToDdlDataSourceActionKt.expandAndDump(project2, sqlDataSource, basicModel2, treePattern, list, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void chooseSqlDataSource(Project project, AnActionEvent e, LocalDataSource ds, List<? extends DbElement> elements) {
        Object object;
        JBPopupFactory jBPopupFactory;
        SqlDataSource newOne;
        block5: {
            List<SqlDataSource> sqlDataSources;
            block4: {
                void it;
                newOne = this.instantiateSqlDataSource(project);
                sqlDataSources = this.compatibleSqlDataSources(project, ds);
                if (sqlDataSources.isEmpty() && newOne != null) {
                    this.createSqlDataSourceAndDump(project, ds, elements, newOne);
                    return;
                }
                jBPopupFactory = JBPopupFactory.getInstance();
                object = newOne;
                if (object == null) break block4;
                SqlDataSource sqlDataSource = object;
                JBPopupFactory jBPopupFactory2 = jBPopupFactory;
                boolean bl = false;
                List list = CollectionsKt.plus((Collection)sqlDataSources, (Object)it);
                jBPopupFactory = jBPopupFactory2;
                object = list;
                if (list != null) break block5;
            }
            object = sqlDataSources;
        }
        jBPopupFactory.createPopupChooserBuilder((List)object).setRenderer((ListCellRenderer)new ColoredListCellRenderer<SqlDataSource>(newOne, project, ds){
            final /* synthetic */ SqlDataSource $newOne;
            final /* synthetic */ Project $project;
            final /* synthetic */ LocalDataSource $ds;
            {
                this.$newOne = $newOne;
                this.$project = $project;
                this.$ds = $ds;
            }

            protected void customizeCellRenderer(JList<? extends SqlDataSource> list, SqlDataSource value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                if (Intrinsics.areEqual((Object)value, (Object)this.$newOne)) {
                    this.setIcon(AllIcons.General.Add);
                    v0 = this.append(DatabaseBundle.message((String)"create.ddl.data.source", (Object[])new Object[0]));
                } else {
                    Icon icon;
                    SqlDataSource sqlDataSource = value;
                    if (DdlMappingsManager.getInstance((Project)this.$project).findByDataSources(this.$ds.getUniqueId(), sqlDataSource != null ? sqlDataSource.getUniqueId() : null).isNotEmpty()) {
                        icon = AllIcons.Nodes.Favorite;
                    } else {
                        SqlDataSource sqlDataSource2 = value;
                        icon = sqlDataSource2 != null ? sqlDataSource2.getIcon(0) : null;
                    }
                    this.setIcon(icon);
                    Object object = value;
                    if (object == null || (object = object.getName()) == null) {
                        object = "";
                    }
                    v0 = this.append((String)object);
                }
            }
        }).setSelectionMode(0).setItemChosenCallback(arg_0 -> DumpToDdlDataSourceAction.chooseSqlDataSource$lambda$7(arg_0 -> DumpToDdlDataSourceAction.chooseSqlDataSource$lambda$6(newOne, this, project, ds, elements, arg_0), arg_0)).createPopup().showInBestPositionFor(e.getDataContext());
    }

    private final void createSqlDataSourceAndDump(Project project, LocalDataSource ds, List<? extends DbElement> elements, SqlDataSource sqlDs) {
        sqlDs.setName(ds.getName() + " (DDL)");
        sqlDs.setCodeStyleName(ds.getCodeStyleName());
        sqlDs.setDefinedDbms(ds.getDbms());
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)dbPsiFacade, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbPsiFacadeImpl");
        DbPsiFacadeImpl facade = (DbPsiFacadeImpl)dbPsiFacade;
        RawDataSource rawDataSource = (RawDataSource)sqlDs;
        DataSourceManager dataSourceManager = DataSourceManager.byDataSource((Project)project, SqlDataSource.class);
        Intrinsics.checkNotNull((Object)dataSourceManager);
        DbDataSource dbDataSource = facade.createDataSourceWrapperElement(rawDataSource, dataSourceManager);
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"createDataSourceWrapperElement(...)");
        DbDataSource wr = dbDataSource;
        DataSourceManagerDialog.showDialog(facade, (Object)CollectionsKt.listOf((Object)wr), null);
        DbDataSource created = DbPsiFacade.getInstance((Project)project).findDataSource(sqlDs.getUniqueId());
        if (created != null) {
            this.dump(project, ds, elements, sqlDs);
        }
    }

    private final SqlDataSource instantiateSqlDataSource(Project project) {
        Ref.ObjectRef sqlDs;
        block1: {
            sqlDs = new Ref.ObjectRef();
            DataSourceManager dataSourceManager = DataSourceManager.byDataSource((Project)project, SqlDataSource.class);
            if (dataSourceManager == null) {
                return null;
            }
            DataSourceManager manager = dataSourceManager;
            AnAction createAction = manager.getCreateDataSourceAction(arg_0 -> DumpToDdlDataSourceAction.instantiateSqlDataSource$lambda$9(arg_0 -> DumpToDdlDataSourceAction.instantiateSqlDataSource$lambda$8(sqlDs, arg_0), arg_0));
            AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)SimpleDataContext.getProjectContext((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
            AnActionEvent fakeEvent = anActionEvent;
            AnAction anAction = createAction;
            if (anAction == null) break block1;
            anAction.actionPerformed(fakeEvent);
        }
        return (SqlDataSource)sqlDs.element;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SqlDataSource> compatibleSqlDataSources(Project project, LocalDataSource ds) {
        void $this$mapNotNullTo$iv$iv;
        List list = DbPsiFacade.getInstance((Project)project).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbDataSource it = (DbDataSource)element$iv$iv;
            boolean bl2 = false;
            RawDataSource $this$asSafely$iv = it.getDelegate();
            boolean $i$f$asSafely = false;
            RawDataSource rawDataSource = $this$asSafely$iv;
            if (!(rawDataSource instanceof SqlDataSource)) {
                rawDataSource = null;
            }
            if ((SqlDataSource)rawDataSource != null) {
                SqlDataSource sqlDataSource;
                SqlDataSource sds = sqlDataSource;
                boolean bl3 = false;
                object = this.isCompatible(sds, ds) ? sqlDataSource : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            SqlDataSource it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isCompatible(SqlDataSource sqlDs, LocalDataSource ds) {
        return Intrinsics.areEqual((Object)sqlDs.getModel().getMetaModel(), (Object)ds.getModel().getMetaModel());
    }

    private static final boolean update$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean actionPerformed$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() instanceof LocalDataSource;
    }

    private static final SqlDataSource actionPerformed$lambda$2(DasDataSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof SqlDataSource ? (SqlDataSource)it : null;
    }

    private static final boolean actionPerformed$lambda$3(DumpToDdlDataSourceAction this$0, DasDataSource $ds, SqlDataSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isCompatible(it, (LocalDataSource)$ds);
    }

    private static final Unit chooseSqlDataSource$lambda$6(SqlDataSource $newOne, DumpToDdlDataSourceAction this$0, Project $project, LocalDataSource $ds, List $elements, SqlDataSource it) {
        if (Intrinsics.areEqual((Object)it, (Object)$newOne) && $newOne != null) {
            this$0.createSqlDataSourceAndDump($project, $ds, $elements, $newOne);
        } else {
            Intrinsics.checkNotNull((Object)it);
            this$0.dump($project, $ds, $elements, it);
        }
        return Unit.INSTANCE;
    }

    private static final void chooseSqlDataSource$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit instantiateSqlDataSource$lambda$8(Ref.ObjectRef $sqlDs, SqlDataSource it) {
        $sqlDs.element = it;
        return Unit.INSTANCE;
    }

    private static final void instantiateSqlDataSource$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceAction$Configured;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getMappings", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/dataSource/DdlMapping;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDumpToDdlDataSourceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpToDdlDataSourceAction.kt\ncom/intellij/database/actions/DumpToDdlDataSourceAction$Configured\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1761#2,3:377\n1634#2,3:380\n1#3:383\n*S KotlinDebug\n*F\n+ 1 DumpToDdlDataSourceAction.kt\ncom/intellij/database/actions/DumpToDdlDataSourceAction$Configured\n*L\n72#1:377,3\n92#1:380,3\n*E\n"})
    public static final class Configured
    extends AnAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            List list = this.getMappings(e).take(2).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            List pairs = list;
            if (pairs.size() == 1) {
                String string;
                boolean bl;
                DdlMapping p2;
                DbPsiFacade dbFacade;
                block7: {
                    Project project = e.getProject();
                    Intrinsics.checkNotNull((Object)project);
                    DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
                    dbFacade = dbPsiFacade;
                    p2 = (DdlMapping)pairs.get(0);
                    DataContext dataContext = e.getDataContext();
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    Iterable $this$any$iv = (Iterable)DatabaseContextFun.getSelectedDataSources(dataContext);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            RawDataSource it = (RawDataSource)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)p2.getDataSourceId())) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                boolean byLds = bl;
                Presentation presentation = e.getPresentation();
                if (byLds) {
                    var6_5 = new Object[1];
                    DbDataSource dbDataSource = dbFacade.findDataSource(p2.getDdlDataSourceId());
                    var6_5[0] = dbDataSource != null ? dbDataSource.getName() : null;
                    string = DatabaseBundle.message((String)"action.dump.to.text", (Object[])var6_5);
                } else {
                    var6_5 = new Object[1];
                    DbDataSource dbDataSource = dbFacade.findDataSource(p2.getDataSourceId());
                    var6_5[0] = dbDataSource != null ? dbDataSource.getName() : null;
                    string = DatabaseBundle.message((String)"action.update.from.text", (Object[])var6_5);
                }
                presentation.setText(string);
            } else {
                e.getPresentation().setText(this.getTemplateText());
            }
            e.getPresentation().setEnabledAndVisible(!((Collection)pairs).isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            JBIterable<DdlMapping> mappings = this.getMappings(e);
            DumpToDdlDataSourceActionKt.dump(project2, (Iterable)mappings, true);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final JBIterable<DdlMapping> getMappings(@NotNull AnActionEvent e) {
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            Project project2 = project;
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Iterable iterable = (Iterable)DatabaseContextFun.getSelectedDataSources(dataContext);
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                RawDataSource rawDataSource = (RawDataSource)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(it.getUniqueId());
            }
            HashSet dataSources = (HashSet)destination$iv;
            DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
            DbPsiFacade dbFacade = dbPsiFacade;
            JBIterable jBIterable = JBIterable.from((Iterable)DdlMappingsManager.getInstance((Project)project2).getMappings()).filter(arg_0 -> Configured.getMappings$lambda$4(arg_0 -> Configured.getMappings$lambda$3(dataSources, dbFacade, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            return jBIterable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean getMappings$lambda$3(HashSet $dataSources, DbPsiFacade $dbFacade, DdlMapping it) {
            if (!CollectionsKt.contains((Iterable)$dataSources, (Object)it.getDataSourceId())) {
                if (!CollectionsKt.contains((Iterable)$dataSources, (Object)it.getDdlDataSourceId())) return false;
            }
            DbDataSource it2 = $dbFacade.findDataSource(it.getDataSourceId());
            boolean bl = false;
            DbDataSource dbDataSource = it2;
            if (!((dbDataSource != null ? dbDataSource.getModel() : null) instanceof BasicModel)) return false;
            if ($dbFacade.findDataSource(it.getDdlDataSourceId()) == null) return false;
            if (it.getScope() == null) return false;
            return true;
        }

        private static final boolean getMappings$lambda$4(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceAction$LayoutAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDumpToDdlDataSourceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpToDdlDataSourceAction.kt\ncom/intellij/database/actions/DumpToDdlDataSourceAction$LayoutAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1761#2,3:377\n1617#2,9:380\n1869#2:389\n1870#2:391\n1626#2:392\n1#3:390\n*S KotlinDebug\n*F\n+ 1 DumpToDdlDataSourceAction.kt\ncom/intellij/database/actions/DumpToDdlDataSourceAction$LayoutAction\n*L\n200#1:377,3\n206#1:380,9\n206#1:389\n206#1:391\n206#1:392\n206#1:390\n*E\n"})
    public static final class LayoutAction
    extends AnAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        /*
         * WARNING - void declaration
         */
        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            Presentation presentation;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable iterable = DumpToDdlDataSourceActionKt.access$getElementsByDs(e).keySet();
                presentation = e.getPresentation();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DasDataSource it = (DasDataSource)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof SqlDataSource)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean bl3 = bl;
            presentation.setEnabledAndVisible(bl3);
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Map items = DumpToDdlDataSourceActionKt.access$getElementsByDs(e);
            for (Map.Entry entry : items.entrySet()) {
                Project project;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                DasDataSource ds = (DasDataSource)entry.getKey();
                List elements = (List)entry.getValue();
                if (!(ds instanceof SqlDataSource)) continue;
                Intrinsics.checkNotNull((Object)e.getProject());
                SqlDataSource sqlDataSource = (SqlDataSource)ds;
                DasModel dasModel = ((SqlDataSource)ds).getModel();
                Intrinsics.checkNotNull((Object)dasModel, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModel");
                Iterable iterable = elements;
                TreePattern treePattern = null;
                BasicModel basicModel = (BasicModel)dasModel;
                SqlDataSource sqlDataSource2 = sqlDataSource;
                boolean $i$f$mapNotNull = false;
                void var9_9 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    BasicElement it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    DbElement it = (DbElement)element$iv$iv;
                    boolean bl2 = false;
                    if (DbImplUtil.getMaybeBasicElement((DasObject)((DasObject)it)) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                DumpToDdlDataSourceActionKt.expandAndDump(project, sqlDataSource2, basicModel, treePattern, list, true);
            }
        }
    }
}

