/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class DbSrcToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final String TOOLWINDOW_ID = "Database Changes";

    public void init(@NotNull ToolWindow window) {
        if (window == null) {
            DbSrcToolWindowFactory.$$$reportNull$$$0(0);
        }
        window.setStripeShortTitleProvider(DatabaseBundle.messagePointer((String)"toolwindow.stripe.Database_Changes.shortName", (Object[])new Object[0]));
        DbSrcToolWindowFactory.initToolwindowListener(window.getProject());
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            DbSrcToolWindowFactory.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            DbSrcToolWindowFactory.$$$reportNull$$$0(2);
        }
        DbSrcChangesBrowser browser = new DbSrcChangesBrowser(project);
        Content content = ContentFactory.getInstance().createContent((JComponent)((Object)browser), null, true);
        toolWindow.getContentManager().addContent(content);
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        if (project == null) {
            DbSrcToolWindowFactory.$$$reportNull$$$0(3);
        }
        return DbSrcToolWindowFactory.hasDataSources(project);
    }

    private static void initToolwindowListener(@NotNull Project project) {
        if (project == null) {
            DbSrcToolWindowFactory.$$$reportNull$$$0(4);
        }
        final Runnable runnable = () -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
            ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
            if (toolWindow != null) {
                DbSrcToolWindowFactory.setAvailable(toolWindow, DbSrcToolWindowFactory.hasDataSources(project));
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any(), project.getDisposed());
        project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                runnable.run();
            }

            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcToolWindowFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void setAvailable(ToolWindow toolWindow, boolean available) {
        toolWindow.setAvailable(available);
        if (!available) {
            toolWindow.setShowStripeButton(false);
        }
    }

    private static boolean hasDataSources(@NotNull Project project) {
        if (project == null) {
            DbSrcToolWindowFactory.$$$reportNull$$$0(5);
        }
        return !DataSourceStorage.getProjectStorage((Project)project).getDataSources().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBeAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initToolwindowListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDataSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

