/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.psi.DbBookmarkNode;
import com.intellij.database.psi.DbBookmarkProvider;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fH\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0013\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/intellij/database/psi/DbBookmark;", "Lcom/intellij/ide/bookmark/Bookmark;", "provider", "Lcom/intellij/database/psi/DbBookmarkProvider;", "dataSourceId", "", "path", "Lcom/intellij/database/util/ObjectPath;", "<init>", "(Lcom/intellij/database/psi/DbBookmarkProvider;Ljava/lang/String;Lcom/intellij/database/util/ObjectPath;)V", "getProvider", "()Lcom/intellij/database/psi/DbBookmarkProvider;", "getDataSourceId", "()Ljava/lang/String;", "getPath", "()Lcom/intellij/database/util/ObjectPath;", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "getDataSource", "()Lcom/intellij/database/psi/DbDataSource;", "element", "Lcom/intellij/database/psi/DbElement;", "getElement", "()Lcom/intellij/database/psi/DbElement;", "attributes", "", "getAttributes", "()Ljava/util/Map;", "createNode", "Lcom/intellij/database/psi/DbBookmarkNode;", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "hashCode", "", "equals", "other", "", "toString", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbBookmark.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbBookmark.kt\ncom/intellij/database/psi/DbBookmark\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class DbBookmark
implements Bookmark {
    @NotNull
    private final DbBookmarkProvider provider;
    @NotNull
    private final String dataSourceId;
    @Nullable
    private final ObjectPath path;

    public DbBookmark(@NotNull DbBookmarkProvider provider, @NotNull String dataSourceId, @Nullable ObjectPath path) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
        this.provider = provider;
        this.dataSourceId = dataSourceId;
        this.path = path;
    }

    @NotNull
    public DbBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final String getDataSourceId() {
        return this.dataSourceId;
    }

    @Nullable
    public final ObjectPath getPath() {
        return this.path;
    }

    @Nullable
    public final DbDataSource getDataSource() {
        return DbPsiFacade.getInstance((Project)this.getProvider().getProject()).findDataSource(this.dataSourceId);
    }

    @Nullable
    public final DbElement getElement() {
        DbElement dbElement;
        DbDataSource dbDataSource = this.getDataSource();
        if (dbDataSource != null) {
            DbDataSource it = dbDataSource;
            boolean bl = false;
            dbElement = this.path == null ? (DbElement)it : it.findElement(this.path);
        } else {
            dbElement = null;
        }
        return dbElement;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"url", (Object)DatabaseElementVirtualFileImpl.getUrl((String)this.dataSourceId, (ObjectPath)this.path, null, (boolean)true)));
    }

    @NotNull
    public DbBookmarkNode createNode() {
        return new DbBookmarkNode(this.getProvider().getProject(), this);
    }

    public boolean canNavigate() {
        DbElement dbElement = this.getElement();
        return dbElement != null ? dbElement.canNavigate() : false;
    }

    public boolean canNavigateToSource() {
        DbElement dbElement = this.getElement();
        return dbElement != null ? dbElement.canNavigateToSource() : false;
    }

    public void navigate(boolean requestFocus) {
        block0: {
            DbElement dbElement = this.getElement();
            if (dbElement == null) break block0;
            DbElement it = dbElement;
            boolean bl = false;
            DbNavigationUtils.createFromTreeNavigatable(it).navigate(requestFocus);
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProvider(), this.dataSourceId, this.path};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof DbBookmark && Intrinsics.areEqual((Object)((DbBookmark)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((DbBookmark)other).dataSourceId, (Object)this.dataSourceId) && Intrinsics.areEqual((Object)((DbBookmark)other).path, (Object)this.path);
    }

    @NotNull
    public String toString() {
        return "DbBookmark(dataSourceId=" + this.dataSourceId + ",path=" + this.path + ")";
    }
}

