/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!SqlCopyPasteProcessor.isSupportedFile(file)) {
            return null;
        }
        Object type = SqlStringLiteralManipulator.LiteralType.QUOTED;
        for (int i = 0; i < startOffsets.length && type != null; ++i) {
            int startOffset = startOffsets[i];
            PsiElement element = SqlStringLiteralManipulator.getStringElement((PsiElement)file.findElementAt(startOffset));
            TextRange range = element == null ? null : element.getTextRange();
            type = range != null && startOffset >= range.getStartOffset() && endOffsets[i] <= range.getEndOffset() ? SqlStringLiteralManipulator.getStringLiteralType((PsiElement)element) : null;
        }
        return type == null ? null : SqlStringLiteralManipulator.unescapeSqlStringCharacters((String)text, (SqlStringLiteralManipulator.LiteralType)type);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor2, String text, RawText rawText) {
        if (!SqlCopyPasteProcessor.isSupportedFile(file)) {
            String string = text;
            if (string == null) {
                SqlCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        Document document = editor2.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caretOffset = editor2.getCaretModel().getOffset();
        PsiElement element = SqlStringLiteralManipulator.getStringElement((PsiElement)file.findElementAt(caretOffset));
        if (element != null) {
            int start2 = element.getTextOffset();
            int end = start2 + element.getTextLength();
            TextRange selectionRange = EditorUtil.getSelectionInAnyMode((Editor)editor2);
            if (selectionRange.getStartOffset() > start2 && selectionRange.getEndOffset() <= end) {
                SqlStringLiteralManipulator.LiteralType type = SqlStringLiteralManipulator.getStringLiteralType((PsiElement)element);
                String string = SqlStringLiteralManipulator.escapeSqlStringCharacters((String)text, (SqlStringLiteralManipulator.LiteralType)type);
                if (string == null) {
                    SqlCopyPasteProcessor.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    SqlCopyPasteProcessor.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = text;
        if (string == null) {
            SqlCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isSupportedFile(PsiFile file) {
        return file instanceof SqlFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlCopyPasteProcessor", "preprocessOnPaste"));
    }
}

