/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/intentions/SqlConvertBetweenToComparisonIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "getTargetExpression", "Lcom/intellij/sql/psi/SqlBetweenExpression;", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertBetweenToComparisonIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertBetweenToComparisonIntention.kt\ncom/intellij/sql/intentions/SqlConvertBetweenToComparisonIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1761#2,3:59\n*S KotlinDebug\n*F\n+ 1 SqlConvertBetweenToComparisonIntention.kt\ncom/intellij/sql/intentions/SqlConvertBetweenToComparisonIntention\n*L\n30#1:59,3\n*E\n"})
public final class SqlConvertBetweenToComparisonIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.between.expression.with.comparisons", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getTargetExpression(element) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        boolean bl;
        SqlExpression upperBound;
        SqlExpression lowerBound;
        SqlExpression subject;
        SqlLanguageDialectEx dialect;
        SqlBetweenExpression betweenExpr;
        block9: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            SqlBetweenExpression sqlBetweenExpression = this.getTargetExpression(element);
            if (sqlBetweenExpression == null) {
                return;
            }
            betweenExpr = sqlBetweenExpression;
            dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)betweenExpr));
            SqlExpression sqlExpression = betweenExpr.getSubject();
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getSubject(...)");
            subject = sqlExpression;
            lowerBound = betweenExpr.getLowerBound();
            upperBound = betweenExpr.getUpperBound();
            JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)betweenExpr.getOperation());
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"sqlChildren(...)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)SqlCommonKeywords.SQL_NOT)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean isNot = bl;
        boolean needsParentheses = isNot || betweenExpr.getParent() instanceof SqlOperatorExpression;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, (SqlLanguageDialect)dialect).withDialect(dialect.getDatabaseDialect());
        if (isNot) {
            builder.keyword("not ");
        }
        if (needsParentheses) {
            builder.symbol("(");
        }
        builder.plain(subject.getText());
        builder.symbol(" >= ");
        Object object = lowerBound;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        builder.plain((String)object);
        builder.plain(" and ");
        builder.plain(subject.getText());
        builder.symbol(" <= ");
        Object object2 = upperBound;
        if (object2 == null || (object2 = object2.getText()) == null) {
            object2 = "";
        }
        builder.plain((String)object2);
        if (needsParentheses) {
            builder.symbol(")");
        }
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText((String)builder.getStatement(), (SqlLanguageDialect)((SqlLanguageDialect)dialect), (Project)project, null);
        Intrinsics.checkNotNull((Object)sqlExpression);
        SqlExpression comparisonExpr = sqlExpression;
        betweenExpr.replace((PsiElement)comparisonExpr);
    }

    private final SqlBetweenExpression getTargetExpression(PsiElement element) {
        JBIterable jBIterable = SqlImplUtil.sqlParents((PsiElement)element).filter(SqlBetweenExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return (SqlBetweenExpression)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
    }
}

