/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.definition;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jxmpp.jid.BareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public interface OpenPgpKeyStore {
    public PGPPublicKeyRingCollection getPublicKeysOf(BareJid var1) throws IOException, PGPException;

    public PGPSecretKeyRingCollection getSecretKeysOf(BareJid var1) throws IOException, PGPException;

    public PGPPublicKeyRing getPublicKeyRing(BareJid var1, OpenPgpV4Fingerprint var2) throws IOException, PGPException;

    public PGPSecretKeyRing getSecretKeyRing(BareJid var1, OpenPgpV4Fingerprint var2) throws IOException, PGPException;

    public void deletePublicKeyRing(BareJid var1, OpenPgpV4Fingerprint var2) throws IOException, PGPException;

    public void deleteSecretKeyRing(BareJid var1, OpenPgpV4Fingerprint var2) throws IOException, PGPException;

    public PGPSecretKeyRing generateKeyRing(BareJid var1) throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException;

    public void importSecretKey(BareJid var1, PGPSecretKeyRing var2) throws IOException, PGPException, MissingUserIdOnKeyException;

    public void importPublicKey(BareJid var1, PGPPublicKeyRing var2) throws IOException, PGPException, MissingUserIdOnKeyException;

    public Map<OpenPgpV4Fingerprint, Date> getPublicKeyFetchDates(BareJid var1) throws IOException;

    public void setPublicKeyFetchDates(BareJid var1, Map<OpenPgpV4Fingerprint, Date> var2) throws IOException;
}

