/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.actions;

import com.intellij.ide.IdeView;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

final class JavaFxTemplateManager {
    JavaFxTemplateManager() {
    }

    static boolean isJavaFxTemplateAvailable(DataContext dataContext, Set<? extends JpsModuleSourceRootType<?>> requiredRootTypes) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null) {
            return false;
        }
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 0) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        boolean underRoot = Arrays.stream(directories).map(PsiDirectory::getVirtualFile).anyMatch(virtualFile -> index.isUnderSourceRootOfType(virtualFile, requiredRootTypes));
        if (!underRoot) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directories[0].getVirtualFile(), (Project)project);
        return JavaFxTemplateManager.hasJavaFxDependency(module);
    }

    private static boolean hasJavaFxDependency(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            boolean hasClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javafx.application.Application", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
            return CachedValueProvider.Result.create((Object)hasClass, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
    }
}

