/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ReportSection;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludePatternsSection
extends ReportSection {
    @Override
    public int getId() {
        return 4;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isEngaged(ProjectData projectData, InstrumentationOptions options) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict, int version) throws IOException {
        void var2_2;
        void var1_1;
        projectData.setIncludePatterns(this.readPatterns(in));
        projectData.setExcludePatterns(this.readPatterns(in));
        var1_1.setAnnotationsToIgnore(this.readPatterns((DataInputStream)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void saveInternal(ProjectData projectData, DataOutput out, TObjectIntHashMap<String> dict) throws IOException {
        void var1_1;
        void var2_2;
        this.dumpPatterns(out, projectData.getIncludePatterns());
        this.dumpPatterns(out, projectData.getExcludePatterns());
        this.dumpPatterns((DataOutput)var2_2, var1_1.getAnnotationsToIgnore());
    }

    /*
     * WARNING - void declaration
     */
    private void dumpPatterns(DataOutput out, List<Pattern> patterns) throws IOException {
        Iterator iterator;
        int size = patterns == null ? 0 : patterns.size();
        CoverageIOUtil.writeINT(out, size);
        if (size == 0) {
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Pattern pattern = (Pattern)iterator.next();
            CoverageIOUtil.writeUTF(out, var3_4.pattern());
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Pattern> readPatterns(DataInputStream in) throws IOException {
        void var3_3;
        int size = CoverageIOUtil.readINT(in);
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        for (int i = 0; i < size; ++i) {
            String pattern = CoverageIOUtil.readUTFFast(in);
            result.add(Pattern.compile(pattern));
        }
        return var3_3;
    }
}

