/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

final class IntIntPersistentMultiMaplet
extends IntIntMultiMaplet {
    private static final IntSet NULL_COLLECTION = IntSets.emptySet();
    private static final int CACHE_SIZE = 256;
    private final PersistentHashMap<Integer, IntSet> map;
    private final LoadingCache<Integer, IntSet> cache;

    IntIntPersistentMultiMaplet(@NotNull File file, KeyDescriptor<Integer> keyExternalizer) throws IOException {
        if (file == null) {
            IntIntPersistentMultiMaplet.$$$reportNull$$$0(0);
        }
        this.map = new PersistentHashMap(file.toPath(), keyExternalizer, (DataExternalizer)new IntSetExternalizer());
        this.cache = Caffeine.newBuilder().maximumSize(256L).build(key -> {
            try {
                IntSet collection = (IntSet)this.map.get(key);
                return collection == null ? NULL_COLLECTION : collection;
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        });
    }

    @Override
    public boolean containsKey(int key) {
        try {
            return this.map.containsMapping((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public IntSet get(int key) {
        IntSet collection = (IntSet)this.cache.get((Object)key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(int key, IntSet value) {
        try {
            this.cache.invalidate((Object)key);
            if (value == null || value.isEmpty()) {
                this.map.remove((Object)key);
            } else {
                this.map.put((Object)key, (Object)value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, final IntSet value) {
        try {
            this.cache.invalidate((Object)key);
            this.map.appendData((Object)key, new AppendablePersistentMap.ValueDataAppender(){

                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    IntIterator iterator = value.iterator();
                    while (iterator.hasNext()) {
                        int value1 = iterator.nextInt();
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)value1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$1", "append"));
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, final int value) {
        try {
            this.cache.invalidate((Object)key);
            this.map.appendData((Object)key, new AppendablePersistentMap.ValueDataAppender(){

                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$2", "append"));
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeAll(int key, IntSet values) {
        try {
            IntSet collection = (IntSet)this.cache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.removeAll((IntCollection)values)) {
                this.cache.invalidate((Object)key);
                if (collection.isEmpty()) {
                    this.map.remove((Object)key);
                } else {
                    this.map.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(int key, int value) {
        try {
            IntSet collection = (IntSet)this.cache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.cache.invalidate((Object)key);
                if (collection.isEmpty()) {
                    this.map.remove((Object)key);
                } else {
                    this.map.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(int key) {
        try {
            this.cache.invalidate((Object)key);
            this.map.remove((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(IntIntMultiMaplet m) {
        m.forEachEntry((integers, value) -> this.put(value, (IntSet)integers));
    }

    @Override
    public void replaceAll(IntIntMultiMaplet m) {
        m.forEachEntry((integers, value) -> this.replace(value, (IntSet)integers));
    }

    @Override
    public void close() {
        try {
            this.cache.invalidateAll();
            this.map.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.map.isDirty()) {
                this.map.dropMemoryCaches();
            }
        } else {
            this.map.force();
        }
    }

    @Override
    public void forEachEntry(ObjIntConsumer<? super IntSet> procedure) {
        try {
            this.map.processKeysWithExistingMapping(key -> {
                try {
                    procedure.accept((IntSet)this.map.get(key), (int)key);
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
                return true;
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet", "<init>"));
    }

    private static final class IntSetExternalizer
    implements DataExternalizer<IntSet> {
        private IntSetExternalizer() {
        }

        public void save(@NotNull DataOutput out, IntSet value) throws IOException {
            if (out == null) {
                IntSetExternalizer.$$$reportNull$$$0(0);
            }
            IntIterator iterator = value.iterator();
            while (iterator.hasNext()) {
                int elem = iterator.nextInt();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)elem);
            }
        }

        public IntSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                IntSetExternalizer.$$$reportNull$$$0(1);
            }
            IntOpenHashSet result = new IntOpenHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$IntSetExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

