/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.DifferentiateStrategy;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmDifferentiateStrategy;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.util.Iterators;

public final class GeneralJvmDifferentiateStrategy
implements DifferentiateStrategy {
    private static final Logger LOG = Logger.getLogger("#org.jetbrains.jps.dependency.java.GeneralJvmDifferentiateStrategy");
    private static final Iterable<JvmDifferentiateStrategy> ourExtensions = Iterators.collect(ServiceLoader.load(JvmDifferentiateStrategy.class), new ArrayList());

    @Override
    public boolean isIncremental(DifferentiateContext context, Node<?, ?> affectedNode) {
        for (JvmDifferentiateStrategy extension : ourExtensions) {
            if (extension.isIncremental(context, affectedNode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean differentiate(final DifferentiateContext context, Iterable<Node<?, ?>> nodesBefore, Iterable<Node<?, ?>> nodesAfter, Iterable<Node<?, ?>> nodesWithErrors) {
        List errNodes;
        Utils future = new Utils(context, true);
        final Utils present = new Utils(context, false);
        final Delta delta = context.getDelta();
        if (delta.isSourceOnly()) {
            new Object(){
                private final Predicate<? super NodeSource> inCurrentChunk;
                private final Set<NodeSource> baseSources;
                {
                    this.inCurrentChunk = context.getParams().belongsToCurrentCompilationChunk();
                    this.baseSources = delta.getBaseSources();
                }

                private boolean isMarked(NodeSource src) {
                    return this.isMarked(Collections.singleton(src));
                }

                private boolean isMarked(Iterable<NodeSource> sources) {
                    return Iterators.find(sources, this.baseSources::contains) != null;
                }

                boolean traverse(JvmClass cl, boolean isRoot) {
                    boolean parentsMarked = false;
                    if (cl.isLibrary()) {
                        return parentsMarked;
                    }
                    for (JvmClass superCl : present.allDirectSupertypes(cl)) {
                        parentsMarked |= this.traverse(superCl, false);
                    }
                    if (isRoot) {
                        return true;
                    }
                    Iterable<NodeSource> nodeSources = present.getNodeSources(cl.getReferenceID());
                    if (parentsMarked) {
                        for (NodeSource source : Iterators.filter(nodeSources, s -> !this.isMarked((NodeSource)s) && this.inCurrentChunk.test((NodeSource)s))) {
                            LOG.log(Level.FINE, "Intermediate class in a class hierarchy is not marked for compilation, while one of its subclasses and superclasses are going to be recompiled. Affecting  " + source.toString());
                            context.affectNodeSource(source);
                        }
                    }
                    return parentsMarked || this.isMarked(nodeSources);
                }

                void markSources() {
                    Graph graph = context.getGraph();
                    for (JvmClass cls : Iterators.flat((Iterable)Iterators.map(this.baseSources, s -> graph.getNodes((NodeSource)s, JvmClass.class)))) {
                        this.traverse(cls, true);
                    }
                }
            }.markSources();
        }
        Difference.Specifier classesDiff = Difference.deepDiff(Graph.getNodesOfType(nodesBefore, JvmClass.class), Graph.getNodesOfType(nodesAfter, JvmClass.class));
        Difference.Specifier modulesDiff = Difference.deepDiff(Graph.getNodesOfType(nodesBefore, JvmModule.class), Graph.getNodesOfType(nodesAfter, JvmModule.class));
        if (!classesDiff.unchanged() || !modulesDiff.unchanged()) {
            for (JvmDifferentiateStrategy strategy : ourExtensions) {
                if (!strategy.processRemovedClasses(context, classesDiff.removed(), future, present)) {
                    return false;
                }
                if (!strategy.processAddedClasses(context, classesDiff.added(), future, present)) {
                    return false;
                }
                if (!strategy.processChangedClasses(context, classesDiff.changed(), future, present)) {
                    return false;
                }
                if (!strategy.processRemovedModules(context, modulesDiff.removed(), future, present)) {
                    return false;
                }
                if (!strategy.processAddedModules(context, modulesDiff.added(), future, present)) {
                    return false;
                }
                if (strategy.processChangedModules(context, modulesDiff.changed(), future, present)) continue;
                return false;
            }
        }
        if (!(errNodes = (List)Iterators.collect((Iterable)Iterators.filter((Iterable)Iterators.map(nodesWithErrors, n -> n instanceof JVMClassNode ? (JVMClassNode)n : null), Objects::nonNull), new ArrayList())).isEmpty()) {
            for (JvmDifferentiateStrategy strategy : ourExtensions) {
                if (strategy.processNodesWithErrors(context, errNodes, present)) continue;
                return false;
            }
        }
        return true;
    }
}

