/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.outputs.export;

import com.intellij.kotlin.jupyter.core.jupyter.outputs.export.SingleFlavorTransferableFactory;
import com.intellij.kotlin.jupyter.core.util.CachesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.system.OS;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"ImageTransferableFactory", "Lcom/intellij/kotlin/jupyter/core/jupyter/outputs/export/SingleFlavorTransferableFactory;", "Ljava/awt/Image;", "FileTransferableFactory", "", "Ljava/io/File;", "createImageDataTransferable", "Ljava/awt/datatransfer/Transferable;", "project", "Lcom/intellij/openapi/project/Project;", "imageData", "", "fileName", "", "isIntermediateFileWorkaroundNeeded", "", "intellij.kotlin.jupyter.core"})
public final class CopyImplKt {
    @NotNull
    private static final SingleFlavorTransferableFactory<Image> ImageTransferableFactory;
    @NotNull
    private static final SingleFlavorTransferableFactory<List<File>> FileTransferableFactory;

    @NotNull
    public static final Transferable createImageDataTransferable(@NotNull Project project, @NotNull byte[] imageData, @NotNull String fileName) {
        Transferable transferable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (CopyImplKt.isIntermediateFileWorkaroundNeeded()) {
            File plotFile = CachesKt.getKotlinNotebookCacheDirectory(project).resolve("plotExport").resolve(fileName).toFile();
            plotFile.getParentFile().mkdirs();
            Intrinsics.checkNotNull((Object)plotFile);
            FilesKt.writeBytes((File)plotFile, (byte[])imageData);
            transferable = FileTransferableFactory.createTransferable(CollectionsKt.listOf((Object)plotFile));
        } else {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            Intrinsics.checkNotNull((Object)image);
            transferable = ImageTransferableFactory.createTransferable(image);
        }
        return transferable;
    }

    private static final boolean isIntermediateFileWorkaroundNeeded() {
        OS os = OS.CURRENT;
        if (os != OS.macOS) {
            return false;
        }
        String string = os.version;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version");
        String version = string;
        String majorVersionString = StringsKt.substringBefore$default((String)version, (String)".", null, (int)2, null);
        Integer n = StringsKt.toIntOrNull((String)majorVersionString);
        if (n == null) {
            return true;
        }
        int majorVersion = n;
        return majorVersion <= 14;
    }

    static {
        DataFlavor dataFlavor = DataFlavor.imageFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"imageFlavor");
        ImageTransferableFactory = new SingleFlavorTransferableFactory(dataFlavor);
        DataFlavor dataFlavor2 = DataFlavor.javaFileListFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor2, (String)"javaFileListFlavor");
        FileTransferableFactory = new SingleFlavorTransferableFactory(dataFlavor2);
    }
}

