/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.actions;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.jupyter.core.jupyter.editor.actions.JupyterCellModificationUtilKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.codeInsight.editorActions.moveUpDown.PyStatementMover;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J(\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J(\u0010\u0016\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J(\u0010\u0016\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/py/editor/actions/JupyterPyStatementMover;", "Lcom/intellij/codeInsight/editorActions/moveUpDown/LineMover;", "<init>", "()V", "mover", "Lcom/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover;", "checkAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "info", "Lcom/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover$MoveInfo;", "down", "beforeMove", "", "moveInScope", "source", "Lcom/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$MyLineRange;", "scopeRange", "Lcom/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$ScopeRange;", "move", "dest", "Lcom/intellij/codeInsight/editorActions/moveUpDown/LineRange;", "sourceLines", "Lkotlin/ranges/IntRange;", "destLines", "intellij.jupyter.py"})
final class JupyterPyStatementMover
extends LineMover {
    @NotNull
    private final PyStatementMover mover = new PyStatementMover();

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!JupyterEditorExtensionsKt.isJupyter((Editor)editor)) {
            return false;
        }
        return this.mover.checkAvailable(editor, file, info, down);
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        LineRange lineRange = info.toMove;
        PyStatementMover.MyLineRange myLineRange = lineRange instanceof PyStatementMover.MyLineRange ? (PyStatementMover.MyLineRange)lineRange : null;
        if (myLineRange != null) {
            PyStatementMover.MyLineRange source = myLineRange;
            boolean bl = false;
            LineRange dest = info.toMove2;
            if (dest instanceof PyStatementMover.ScopeRange) {
                this.moveInScope(editor, source, (PyStatementMover.ScopeRange)dest, down);
            } else if (dest != null) {
                this.move(editor, source, dest, down);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        info.toMove2 = info.toMove;
    }

    private final void moveInScope(Editor editor, PyStatementMover.MyLineRange source, PyStatementMover.ScopeRange scopeRange, boolean down) {
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (scopeRange.isTheSameLevel()) {
            TextRange destRange = scopeRange.getAnchor().getTextRange();
            IntRange dest = new IntRange(document2.getLineNumber(destRange.getStartOffset()), document2.getLineNumber(destRange.getEndOffset()));
            this.move(editor, RangesKt.until((int)source.startLine, (int)source.endLine), dest, down);
            return;
        }
    }

    private final void move(Editor editor, PyStatementMover.MyLineRange source, LineRange dest, boolean down) {
        this.move(editor, RangesKt.until((int)source.startLine, (int)source.endLine), RangesKt.until((int)dest.startLine, (int)dest.endLine), down);
    }

    private final void move(Editor editor, IntRange sourceLines, IntRange destLines, boolean down) {
        NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get(editor);
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)SequencesKt.singleOrNull((Sequence)NotebookVisualizationUiUtilKt.getCells((NotebookCellLines)notebookCellLines, (IntRange)sourceLines));
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval sourceCell = interval;
        if (down) {
            NotebookCellLines.Interval targetCell = (NotebookCellLines.Interval)notebookCellLines.intervalsIterator(destLines.getFirst()).next();
            if (Intrinsics.areEqual((Object)targetCell, (Object)sourceCell)) {
                int shift = destLines.getLast() - sourceLines.getLast();
                JupyterCellModificationUtilKt.swapNeighbourLinesInOneCell((Editor)editor, (NotebookCellLines.Interval)sourceCell, (IntRange)sourceLines, (IntRange)new IntRange(sourceLines.getLast() + 1, sourceLines.getLast() + shift));
            } else if (sourceLines.getLast() < sourceCell.getLines().getLast()) {
                JupyterCellModificationUtilKt.swapNeighbourLinesInOneCell((Editor)editor, (NotebookCellLines.Interval)sourceCell, (IntRange)sourceLines, (IntRange)new IntRange(sourceLines.getLast() + 1, sourceCell.getLines().getLast()));
            } else {
                JupyterCellModificationUtilKt.tryMoveLinesToAnotherCell((Editor)editor, (IntRange)sourceLines, (NotebookCellLines)notebookCellLines, (NotebookCellLines.Interval)sourceCell, (boolean)false);
            }
        } else {
            NotebookCellLines.Interval targetCell = (NotebookCellLines.Interval)notebookCellLines.intervalsIterator(destLines.getFirst()).next();
            if (Intrinsics.areEqual((Object)targetCell, (Object)sourceCell)) {
                if (destLines.getFirst() >= targetCell.getFirstContentLine()) {
                    JupyterCellModificationUtilKt.swapNeighbourLinesInOneCell((Editor)editor, (NotebookCellLines.Interval)sourceCell, (IntRange)sourceLines, (IntRange)RangesKt.until((int)destLines.getFirst(), (int)sourceLines.getFirst()));
                }
            } else if (sourceLines.getFirst() > sourceCell.getFirstContentLine()) {
                JupyterCellModificationUtilKt.swapNeighbourLinesInOneCell((Editor)editor, (NotebookCellLines.Interval)sourceCell, (IntRange)sourceLines, (IntRange)RangesKt.until((int)sourceCell.getFirstContentLine(), (int)sourceLines.getFirst()));
            } else {
                JupyterCellModificationUtilKt.tryMoveLinesToAnotherCell((Editor)editor, (IntRange)sourceLines, (NotebookCellLines)notebookCellLines, (NotebookCellLines.Interval)sourceCell, (boolean)true);
            }
        }
    }
}

