/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jbonlymac;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.CollapsedProfilerDumpWriter;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBase;
import com.intellij.profiler.dtrace.DTraceScript;
import com.intellij.profiler.dtrace.DTraceScriptKt;
import com.intellij.profiler.dtrace.FullDumpParser;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.profiler.model.JVMThread;
import com.intellij.profiler.model.NativeThread;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.model.Transformation;
import com.intellij.profiler.sudo.SudoProcessHandler;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ultimate.AttachResult;
import com.intellij.profiler.ultimate.JavaCallStackElementRenderer;
import com.intellij.profiler.ultimate.JavaTargetProcess;
import com.intellij.profiler.ultimate.NativeAgentAttachKt;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcessKt;
import com.intellij.profiler.ultimate.jbonlymac.CallsMappingStatistics;
import com.intellij.profiler.ultimate.jbonlymac.CompiledMethod;
import com.intellij.profiler.ultimate.jbonlymac.CompiledMethodsStorageKt;
import com.intellij.profiler.ultimate.jbonlymac.JVMDTraceProfilerProcess;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRangeWithData;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRangesStorage;
import com.intellij.profiler.ultimate.jbonlymac.configurations.JVMDTraceProfilerConfigurationState;
import com.intellij.profiler.ultimate.model.JavaCachingStackElementReader;
import com.intellij.profiler.ultimate.model.UnknownMemoryJavaCall;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0014J\b\u0010#\u001a\u00020$H\u0014J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cH\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess;", "Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "attachedTimestamp", "", "dtraceProcessHandler", "Lcom/intellij/profiler/sudo/SudoProcessHandler;", "jvmAgentPath", "", "jitLogFilePath", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/AttachableTargetProcess;Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;JLcom/intellij/profiler/sudo/SudoProcessHandler;Ljava/lang/String;Ljava/lang/String;)V", "getProfilerConfiguration", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "eventLogDataFuture", "Ljava/util/concurrent/Future;", "Lcom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess$Companion$EventLogData;", "createDumpParser", "Lcom/intellij/profiler/dtrace/FullDumpParser;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "createProfilerData", "Lcom/intellij/profiler/api/NewCallTreeOnlyProfilerData;", "builder", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "createDumpWriter", "Lcom/intellij/profiler/api/CollapsedProfilerDumpWriter;", "data", "helpId", "getHelpId", "()Ljava/lang/String;", "onDTraceStopped", "", "postProcessData", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJVMDTraceProfilerProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMDTraceProfilerProcess.kt\ncom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n24#2:203\n14#2:211\n543#3,6:204\n1#4:210\n*S KotlinDebug\n*F\n+ 1 JVMDTraceProfilerProcess.kt\ncom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess\n*L\n129#1:203\n165#1:211\n122#1:204,6\n*E\n"})
public final class JVMDTraceProfilerProcess
extends DTraceProfilerProcessBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfilerConfigurationState profilerConfiguration;
    @NotNull
    private final String jvmAgentPath;
    @NotNull
    private final String jitLogFilePath;
    @Nullable
    private volatile Future<Companion.EventLogData> eventLogDataFuture;
    @NotNull
    private final String helpId;
    @NotNull
    private static final Logger staticLogger;
    @NotNull
    private static final String AGENT_PATH_PROPERTY = "idea.settings.profiler.agent.path";
    @NotNull
    private static final String BUNDLED_AGENT_PATH = "profiler/macosx/libperfmap.dylib";

    private JVMDTraceProfilerProcess(Project project, AttachableTargetProcess targetProcess, ProfilerConfigurationState profilerConfiguration, long attachedTimestamp, SudoProcessHandler dtraceProcessHandler, String jvmAgentPath, String jitLogFilePath) {
        super(project, targetProcess, attachedTimestamp, dtraceProcessHandler);
        this.profilerConfiguration = profilerConfiguration;
        this.jvmAgentPath = jvmAgentPath;
        this.jitLogFilePath = jitLogFilePath;
        this.helpId = "procedures.profiler";
    }

    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    @NotNull
    protected FullDumpParser<BaseCallStackElement> createDumpParser() {
        JavaCachingStackElementReader cachingStackElementReader = JavaCachingStackElementReader.Companion.getInstance(this.getProject());
        return new FullDumpParser(JVMDTraceProfilerProcess::createDumpParser$lambda$0, arg_0 -> JVMDTraceProfilerProcess.createDumpParser$lambda$1(cachingStackElementReader, arg_0));
    }

    @NotNull
    protected NewCallTreeOnlyProfilerData createProfilerData(@NotNull DummyCallTreeBuilder<BaseCallStackElement> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return new NewCallTreeOnlyProfilerData((CallTreeBuilder)builder, (BaseCallStackElementRenderer)JavaCallStackElementRenderer.Companion.getINSTANCE());
    }

    @NotNull
    protected CollapsedProfilerDumpWriter createDumpWriter(@NotNull NewCallTreeOnlyProfilerData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return AsyncProfilerProcessKt.javaCollapsedDumpWriter((CallTreeBuilder<BaseCallStackElement>)data.getBuilder(), ((AttachableTargetProcess)this.getTargetProcess()).getFullName(), this.getAttachedTimestamp());
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    protected void onDTraceStopped() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> JVMDTraceProfilerProcess.onDTraceStopped$lambda$2(this));
        this.eventLogDataFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> JVMDTraceProfilerProcess.onDTraceStopped$lambda$3(this));
    }

    @NotNull
    protected DummyCallTreeBuilder<BaseCallStackElement> postProcessData(@NotNull DummyCallTreeBuilder<BaseCallStackElement> builder) {
        DummyCallTreeBuilder<BaseCallStackElement> dummyCallTreeBuilder;
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Future<Companion.EventLogData> future = this.eventLogDataFuture;
        if (future == null || (future = future.get()) == null) {
            future = Companion.EventLogData.Companion.getEMPTY();
        }
        Future<Companion.EventLogData> future2 = future;
        MemoryRangesStorage<CompiledMethod> compiledMethods = ((Companion.EventLogData)((Object)future2)).component1();
        List<ThreadInfo> threads = ((Companion.EventLogData)((Object)future2)).component2();
        this.getDumpReadIndicator().checkCanceled();
        CallsMappingStatistics statistics = new CallsMappingStatistics(null, 0, 3, null);
        DummyCallTreeBuilder<BaseCallStackElement> $this$postProcessData_u24lambda_u248 = dummyCallTreeBuilder = builder;
        boolean bl = false;
        $this$postProcessData_u24lambda_u248.transformTreeElements(arg_0 -> JVMDTraceProfilerProcess.postProcessData$lambda$8$lambda$6(compiledMethods, statistics, arg_0));
        $this$postProcessData_u24lambda_u248.renameThreads(arg_0 -> JVMDTraceProfilerProcess.postProcessData$lambda$8$lambda$7(threads, arg_0));
        DummyCallTreeBuilder<BaseCallStackElement> analyzedTree = dummyCallTreeBuilder;
        JVMDTraceProfilerProcess $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JVMDTraceProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Memory range storage: requests out of range: " + compiledMethods.getOutOfRangeRequests() + ", " + (double)compiledMethods.getOutOfRangeRequests() / (double)compiledMethods.getTotalRequests() * 100.0 + "% of all");
        return analyzedTree;
    }

    private static final ThreadInfo createDumpParser$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ThreadInfo)NativeThread.Companion.fromId(it);
    }

    private static final BaseCallStackElement createDumpParser$lambda$1(JavaCachingStackElementReader $cachingStackElementReader, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $cachingStackElementReader.parseDTraceStackElement(it);
    }

    private static final void onDTraceStopped$lambda$2(JVMDTraceProfilerProcess this$0) {
        NativeAgentAttachKt.attachAgentUsingNativeJattach$default(((AttachableTargetProcess)this$0.getTargetProcess()).getPid(), this$0.jvmAgentPath, "shutdown", 5000, null, 16, null);
    }

    private static final Companion.EventLogData onDTraceStopped$lambda$3(JVMDTraceProfilerProcess this$0) {
        JavaCachingStackElementReader reader = JavaCachingStackElementReader.Companion.getInstance(this$0.getProject());
        List threads = new ArrayList();
        List methods = new ArrayList();
        LineByLineParser parser2 = new LineByLineParser(threads, methods, reader){
            private int unloads;
            final /* synthetic */ List<ThreadInfo> $threads;
            final /* synthetic */ List<MemoryRangeWithData<CompiledMethod>> $methods;
            final /* synthetic */ JavaCachingStackElementReader $reader;
            {
                this.$threads = $threads;
                this.$methods = $methods;
                this.$reader = $reader;
            }

            public final int getUnloads() {
                return this.unloads;
            }

            public final void setUnloads(int n) {
                this.unloads = n;
            }

            public void consumeLine(String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String timeStamp = StringsKt.substringBefore$default((String)line, (char)' ', null, (int)2, null);
                String string = line.substring(timeStamp.length() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String event = StringsKt.substringBefore$default((String)string, (char)' ', null, (int)2, null);
                try {
                    String string2 = line.substring(timeStamp.length() + 1 + event.length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String data = string2;
                    switch (event) {
                        case "thread:": {
                            ((Collection)this.$threads).add(com.intellij.profiler.ultimate.jbonlymac.JVMDTraceProfilerProcess$Companion.access$parseThread(JVMDTraceProfilerProcess.Companion, data));
                            break;
                        }
                        case "method_load:": {
                            ((Collection)this.$methods).add(CompiledMethodsStorageKt.parseCompiledMethod(this.$reader, data));
                            break;
                        }
                        case "method_unload:": {
                            int n = this.unloads;
                            this.unloads = n + 1;
                        }
                    }
                }
                catch (Exception e) {
                    onDTraceStopped.2.parser.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(onDTraceStopped.2.parser.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("while parsing `" + line + "`", (Throwable)e);
                }
            }
        };
        parser2.readLargeFile(new File(this$0.jitLogFilePath), (ProgressIndicator)this$0.getDumpReadIndicator());
        return new Companion.EventLogData(new MemoryRangesStorage(methods, 500), threads);
    }

    private static final Transformation<BaseCallStackElement> postProcessData$transformTreeElementsFunction(MemoryRangesStorage<? extends CompiledMethod> compiledMethods, BaseCallStackElement callStackElement) {
        CompiledMethod compiledMethod;
        return callStackElement instanceof UnknownMemoryJavaCall ? ((compiledMethod = CompiledMethodsStorageKt.findBestReplace(compiledMethods, UtilsKt.parseHexLong((String)((UnknownMemoryJavaCall)callStackElement).getAddress()))) == null ? (Transformation)new Transformation.Single((Object)callStackElement) : (Transformation)new Transformation.ListOf(compiledMethod.getAll())) : (Transformation)new Transformation.Single((Object)callStackElement);
    }

    private static final ThreadInfo postProcessData$renameThreadsFunction(List<? extends ThreadInfo> threads, String oldName) {
        ThreadInfo threadInfo;
        ThreadInfo threadInfo2;
        block2: {
            List<? extends ThreadInfo> $this$lastOrNull$iv = threads;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends ThreadInfo> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                ThreadInfo element$iv;
                ThreadInfo it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNativeId(), (Object)oldName)) continue;
                threadInfo2 = element$iv;
                break block2;
            }
            threadInfo2 = null;
        }
        if ((threadInfo = (ThreadInfo)threadInfo2) == null) {
            threadInfo = (ThreadInfo)NativeThread.Companion.fromId(oldName);
        }
        return threadInfo;
    }

    private static final Transformation postProcessData$lambda$8$lambda$6(MemoryRangesStorage $compiledMethods, CallsMappingStatistics $statistics, BaseCallStackElement it) {
        Transformation<BaseCallStackElement> transformation;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Transformation<BaseCallStackElement> i = transformation = JVMDTraceProfilerProcess.postProcessData$transformTreeElementsFunction($compiledMethods, it);
        boolean bl = false;
        $statistics.update(i.getList());
        return transformation;
    }

    private static final ThreadInfo postProcessData$lambda$8$lambda$7(List $threads, ThreadInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JVMDTraceProfilerProcess.postProcessData$renameThreadsFunction($threads, it.getNativeId());
    }

    public /* synthetic */ JVMDTraceProfilerProcess(Project project, AttachableTargetProcess targetProcess, ProfilerConfigurationState profilerConfiguration, long attachedTimestamp, SudoProcessHandler dtraceProcessHandler, String jvmAgentPath, String jitLogFilePath, DefaultConstructorMarker $constructor_marker) {
        this(project, targetProcess, profilerConfiguration, attachedTimestamp, dtraceProcessHandler, jvmAgentPath, jitLogFilePath);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JVMDTraceProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        staticLogger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess$Companion;", "", "<init>", "()V", "attach", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess;", "targetProcess", "Lcom/intellij/profiler/ultimate/JavaTargetProcess;", "configuration", "Lcom/intellij/profiler/ultimate/jbonlymac/configurations/JVMDTraceProfilerConfigurationState;", "timeoutInMilliseconds", "", "project", "Lcom/intellij/openapi/project/Project;", "staticLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "AGENT_PATH_PROPERTY", "", "BUNDLED_AGENT_PATH", "getNativeAgentFile", "Ljava/io/File;", "parseThread", "Lcom/intellij/profiler/model/ThreadInfo;", "string", "EventLogData", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Promise<JVMDTraceProfilerProcess> attach(@NotNull JavaTargetProcess targetProcess, @NotNull JVMDTraceProfilerConfigurationState configuration, int timeoutInMilliseconds, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!targetProcess.getPreserveFramePointer()) {
                String string = UltimateProfilerBundleKt.profilerMessage("dtrace.exceptions.cant.attach", new Object[0]);
                String string2 = UltimateProfilerBundleKt.profilerMessage("dtrace.exceptions.details.link", new Object[0]);
                return Promises.rejectedPromise((Throwable)((Throwable)new MisConfiguredException(project, string, string2){

                    public void fixAction(Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        BrowserUtil.browse((String)"https://medium.com/netflix-techblog/java-in-flames-e763b3d32166");
                    }
                }));
            }
            File jitLoggerAgent = this.getNativeAgentFile();
            if (!jitLoggerAgent.exists()) {
                Object[] objectArray = new Object[]{JVMDTraceProfilerProcess.AGENT_PATH_PROPERTY};
                return Promises.rejectedPromise((Throwable)((Throwable)new AttachFailedException(UltimateProfilerBundleKt.profilerMessage("dtrace.exceptions.cant.find.agent", objectArray))));
            }
            AttachableTargetProcess attachableTargetProcess = targetProcess;
            PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
            Intrinsics.checkNotNullExpressionValue((Object)performInBackgroundOption, (String)"ALWAYS_BACKGROUND");
            return DTraceProfilerProcessBase.Companion.attachBase$default((DTraceProfilerProcessBase.Companion)DTraceProfilerProcessBase.Companion, (AttachableTargetProcess)attachableTargetProcess, (PerformInBackgroundOption)performInBackgroundOption, (DTraceScript)DTraceScriptKt.cpuProfilerScript((SimpleProfilerSettingsState)configuration.getSettings()), (int)timeoutInMilliseconds, (Project)project, null, (arg_0, arg_1) -> Companion.attach$lambda$0(jitLoggerAgent, targetProcess, timeoutInMilliseconds, project, configuration, arg_0, arg_1), (int)32, null);
        }

        private final File getNativeAgentFile() {
            Object object = System.getProperty(JVMDTraceProfilerProcess.AGENT_PATH_PROPERTY);
            if (object != null) {
                String it = object;
                boolean bl = false;
                staticLogger.info("read native agent path from system property: " + it);
                return new File(it);
            }
            if (PluginManagerCore.isRunningFromSources()) {
                return new File(PathManager.getHomePath(), "plugins/profiler/ultimate/jvmti-agent/libperfmap.dylib");
            }
            Object it = object = new File(PathManager.getLibPath(), JVMDTraceProfilerProcess.BUNDLED_AGENT_PATH);
            boolean bl = false;
            staticLogger.info("use bundled native agent from " + (File)it);
            return object;
        }

        private final ThreadInfo parseThread(String string) {
            String threadId = StringsKt.substringBefore$default((String)string, (char)' ', null, (int)2, null);
            int typeStartedAt = StringsKt.indexOf$default((CharSequence)string, (char)' ', (int)(threadId.length() + 1), (boolean)false, (int)4, null) + 1;
            String string2 = string.substring(typeStartedAt);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String threadType = StringsKt.substringBefore$default((String)string2, (char)' ', null, (int)2, null);
            String string3 = string.substring(typeStartedAt + threadType.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String threadName = string3;
            if (Intrinsics.areEqual((Object)threadType, (Object)"java:")) {
                return (ThreadInfo)new JVMThread(threadId, threadName);
            }
            if (Intrinsics.areEqual((Object)threadType, (Object)"native:")) {
                String realName = Intrinsics.areEqual((Object)threadName, (Object)threadId) ? "" : threadName;
                return (ThreadInfo)new NativeThread(threadId, realName);
            }
            throw new IllegalArgumentException("Unknown thread type: '" + threadType + "' in line: '" + string + "'");
        }

        private static final JVMDTraceProfilerProcess attach$lambda$0(File $jitLoggerAgent, JavaTargetProcess $targetProcess, int $timeoutInMilliseconds, Project $project, JVMDTraceProfilerConfigurationState $configuration, SudoProcessHandler handler, ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            String string = $jitLoggerAgent.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            String agentPath = com.intellij.profiler.ultimate.async.UtilsKt.tryToHandleSpacesInAgentPath(string);
            File file = FileUtil.createTempFile((String)("pid-" + $targetProcess.getPid() + "-jvmti-agent-events.log"), (String)"");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File eventLogFile = file;
            staticLogger.info("native agent events log will be written into " + eventLogFile.getAbsolutePath());
            File file2 = FileUtil.createTempFile((String)("pid-" + $targetProcess.getPid() + "-jvmti-agent.log"), (String)"");
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
            File logFile = file2;
            String options = "events_file=" + eventLogFile.getAbsolutePath() + ",log_file=" + logFile.getAbsolutePath();
            AttachResult attachResult = NativeAgentAttachKt.attachAgentUsingNativeJattach($targetProcess.getPid(), agentPath, options, $timeoutInMilliseconds, progressIndicator);
            NativeAgentAttachKt.throwIfFailed(attachResult, $targetProcess);
            AttachableTargetProcess attachableTargetProcess = $targetProcess;
            ProfilerConfigurationState profilerConfigurationState = (ProfilerConfigurationState)$configuration;
            long l = System.currentTimeMillis();
            String string2 = eventLogFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            return new JVMDTraceProfilerProcess($project, attachableTargetProcess, profilerConfigurationState, l, handler, agentPath, string2, null);
        }

        public static final /* synthetic */ ThreadInfo access$parseThread(Companion $this, String string) {
            return $this.parseThread(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B'\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001b\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess$Companion$EventLogData;", "", "compiledMethods", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage;", "Lcom/intellij/profiler/ultimate/jbonlymac/CompiledMethod;", "Lcom/intellij/profiler/ultimate/jbonlymac/CompiledMethodsStorage;", "threads", "", "Lcom/intellij/profiler/model/ThreadInfo;", "<init>", "(Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage;Ljava/util/List;)V", "getCompiledMethods", "()Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage;", "getThreads", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "intellij.profiler.ultimate"})
        private static final class EventLogData {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final MemoryRangesStorage<CompiledMethod> compiledMethods;
            @NotNull
            private final List<ThreadInfo> threads;
            @NotNull
            private static final EventLogData EMPTY = new EventLogData(MemoryRangesStorage.Companion.getEMPTY(), CollectionsKt.emptyList());

            public EventLogData(@NotNull MemoryRangesStorage<? extends CompiledMethod> compiledMethods, @NotNull List<? extends ThreadInfo> threads) {
                Intrinsics.checkNotNullParameter(compiledMethods, (String)"compiledMethods");
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                this.compiledMethods = compiledMethods;
                this.threads = threads;
            }

            @NotNull
            public final MemoryRangesStorage<CompiledMethod> getCompiledMethods() {
                return this.compiledMethods;
            }

            @NotNull
            public final List<ThreadInfo> getThreads() {
                return this.threads;
            }

            @NotNull
            public final MemoryRangesStorage<CompiledMethod> component1() {
                return this.compiledMethods;
            }

            @NotNull
            public final List<ThreadInfo> component2() {
                return this.threads;
            }

            @NotNull
            public final EventLogData copy(@NotNull MemoryRangesStorage<? extends CompiledMethod> compiledMethods, @NotNull List<? extends ThreadInfo> threads) {
                Intrinsics.checkNotNullParameter(compiledMethods, (String)"compiledMethods");
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                return new EventLogData(compiledMethods, threads);
            }

            public static /* synthetic */ EventLogData copy$default(EventLogData eventLogData, MemoryRangesStorage memoryRangesStorage, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    memoryRangesStorage = eventLogData.compiledMethods;
                }
                if ((n & 2) != 0) {
                    list = eventLogData.threads;
                }
                return eventLogData.copy(memoryRangesStorage, list);
            }

            @NotNull
            public String toString() {
                return "EventLogData(compiledMethods=" + this.compiledMethods + ", threads=" + this.threads + ")";
            }

            public int hashCode() {
                int result = this.compiledMethods.hashCode();
                result = result * 31 + ((Object)this.threads).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EventLogData)) {
                    return false;
                }
                EventLogData eventLogData = (EventLogData)other;
                if (!Intrinsics.areEqual(this.compiledMethods, eventLogData.compiledMethods)) {
                    return false;
                }
                return Intrinsics.areEqual(this.threads, eventLogData.threads);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess$Companion$EventLogData$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess$Companion$EventLogData;", "getEMPTY", "()Lcom/intellij/profiler/ultimate/jbonlymac/JVMDTraceProfilerProcess$Companion$EventLogData;", "intellij.profiler.ultimate"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final EventLogData getEMPTY() {
                    return EMPTY;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

