/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiMethodUtil {
    public static final Condition<@NotNull PsiClass> MAIN_CLASS = psiClass -> {
        if (PsiUtil.isLocalOrAnonymousClass(psiClass)) {
            return false;
        }
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.isInterface() && !PsiUtil.isAvailable(JavaFeature.EXTENSION_METHODS, psiClass)) {
            return false;
        }
        return psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static");
    };
    private static final Comparator<PsiMethod> mainCandidateComparator = (o1, o2) -> {
        boolean isO1Static = o1.hasModifierProperty("static");
        boolean isO2Static = o2.hasModifierProperty("static");
        int o1Parameters = o1.getParameterList().getParametersCount();
        int o2Parameters = o2.getParameterList().getParametersCount();
        boolean isInheritedStaticMethodEnabled = PsiUtil.isAvailable(JavaFeature.INHERITED_STATIC_MAIN_METHOD, o1);
        if (isInheritedStaticMethodEnabled) {
            return Integer.compare(o2Parameters, o1Parameters);
        }
        if (isO1Static == isO2Static) {
            return Integer.compare(o2Parameters, o1Parameters);
        }
        if (isO1Static) {
            return -1;
        }
        return 1;
    };

    private PsiMethodUtil() {
    }

    @Nullable
    public static PsiMethod findMainMethod(@NotNull PsiClass aClass) {
        JavaMainMethodProvider mainMethodProvider;
        if (aClass == null) {
            PsiMethodUtil.$$$reportNull$$$0(0);
        }
        if ((mainMethodProvider = PsiMethodUtil.getApplicableMainMethodProvider(aClass)) != null) {
            return mainMethodProvider.findMainInClass(aClass);
        }
        return PsiMethodUtil.findMainMethodInClassOrParent(aClass);
    }

    @Nullable
    public static PsiMethod findMainMethodInClassOrParent(PsiClass aClass) {
        DumbService dumbService = DumbService.getInstance((Project)aClass.getProject());
        try {
            return (PsiMethod)dumbService.computeWithAlternativeResolveEnabled(() -> {
                PsiMethod[] mainMethods = aClass.findMethodsByName("main", true);
                return PsiMethodUtil.findMainMethod(mainMethods, aClass, false);
            });
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    private static PsiMethod findMainMethod(PsiMethod[] mainMethods, PsiClass aClass, boolean first) {
        ArrayList<@NotNull PsiMethod> candidates = new ArrayList<PsiMethod>();
        boolean chooseMainMethodByParametersEnabled = PsiMethodUtil.inheritedStaticMainEnabled(aClass);
        for (PsiMethod mainMethod : mainMethods) {
            PsiClass containingClass;
            if (mainMethod.hasModifierProperty("abstract") || aClass.hasModifierProperty("abstract") && !mainMethod.hasModifierProperty("static") && !chooseMainMethodByParametersEnabled || (containingClass = mainMethod.getContainingClass()) != null && containingClass != aClass && (containingClass.isInterface() && !PsiMethodUtil.instanceMainMethodsEnabled(containingClass) || containingClass.isInterface() && mainMethod.hasModifierProperty("static")) || !PsiMethodUtil.isMainMethod(mainMethod, false)) continue;
            if (first && !chooseMainMethodByParametersEnabled && (mainMethod.hasModifierProperty("static") || PsiMethodUtil.hasDefaultNonPrivateConstructor(aClass))) {
                return mainMethod;
            }
            candidates.add(mainMethod);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        candidates.sort(mainCandidateComparator);
        PsiMethod method = (PsiMethod)candidates.get(0);
        if (!method.hasModifierProperty("static")) {
            if (aClass.hasModifierProperty("abstract")) {
                return null;
            }
            if (!PsiMethodUtil.hasDefaultNonPrivateConstructor(aClass)) {
                return null;
            }
        }
        return method;
    }

    private static boolean hasDefaultNonPrivateConstructor(@NotNull PsiClass clazz) {
        PsiMethod[] constructors;
        if (clazz == null) {
            PsiMethodUtil.$$$reportNull$$$0(1);
        }
        if ((constructors = clazz.getConstructors()).length == 0) {
            return true;
        }
        for (PsiMethod constr : constructors) {
            if (!constr.hasModifierProperty("public") && !constr.hasModifierProperty("protected") && !constr.hasModifierProperty("packageLocal") || !constr.getParameterList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceMainMethodsEnabled(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PsiMethodUtil.$$$reportNull$$$0(2);
        }
        return PsiUtil.isAvailable(JavaFeature.INSTANCE_MAIN_METHOD, psiElement) && psiElement.getLanguage() instanceof JavaLanguage;
    }

    private static boolean inheritedStaticMainEnabled(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PsiMethodUtil.$$$reportNull$$$0(3);
        }
        return PsiUtil.isAvailable(JavaFeature.INHERITED_STATIC_MAIN_METHOD, psiElement);
    }

    @Contract(value="null, _ -> false")
    private static boolean isMainMethod(@Nullable PsiMethod mainMethod, boolean checkNoArgsConstructor) {
        if (mainMethod == null || mainMethod.getContainingClass() == null) {
            return false;
        }
        PsiClass containingClass = mainMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (!PsiTypes.voidType().equals(mainMethod.getReturnType())) {
            return false;
        }
        PsiParameter[] parameters = mainMethod.getParameterList().getParameters();
        if (PsiMethodUtil.instanceMainMethodsEnabled(mainMethod)) {
            if (!(mainMethod.hasModifierProperty("public") || mainMethod.hasModifierProperty("packageLocal") || mainMethod.hasModifierProperty("protected"))) {
                return false;
            }
            if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
                return false;
            }
            if (checkNoArgsConstructor && !mainMethod.hasModifierProperty("static") && !PsiMethodUtil.hasDefaultNonPrivateConstructor(containingClass)) {
                return false;
            }
            if (parameters.length == 1) {
                return PsiMethodUtil.isJavaLangStringArray(parameters[0]);
            }
            return parameters.length == 0;
        }
        if (!mainMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!mainMethod.hasModifierProperty("public")) {
            return false;
        }
        if (parameters.length != 1) {
            return false;
        }
        return PsiMethodUtil.isJavaLangStringArray(parameters[0]);
    }

    @Contract(value="null -> false")
    public static boolean isMainMethod(@Nullable PsiMethod method) {
        return PsiMethodUtil.isMainMethod(method, true);
    }

    private static boolean isJavaLangStringArray(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            PsiMethodUtil.$$$reportNull$$$0(4);
        }
        try {
            PsiType type = parameter.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            return (Boolean)DumbService.getInstance((Project)parameter.getProject()).computeWithAlternativeResolveEnabled(() -> {
                PsiType componentType = ((PsiArrayType)type).getComponentType();
                return componentType.equalsToText("java.lang.String");
            });
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public static boolean hasMainMethod(PsiClass psiClass) {
        JavaMainMethodProvider mainMethodProvider = PsiMethodUtil.getApplicableMainMethodProvider(psiClass);
        if (mainMethodProvider != null) {
            return mainMethodProvider.hasMainMethod(psiClass);
        }
        DumbService dumbService = DumbService.getInstance((Project)psiClass.getProject());
        try {
            return (Boolean)dumbService.computeWithAlternativeResolveEnabled(() -> {
                PsiMethod[] mainMethods = psiClass.findMethodsByName("main", true);
                return PsiMethodUtil.findMainMethod(mainMethods, psiClass, true) != null;
            });
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public static boolean isMainMethodWithProvider(@NotNull PsiClass psiClass, @NotNull PsiElement psiElement) {
        JavaMainMethodProvider mainMethodProvider;
        if (psiClass == null) {
            PsiMethodUtil.$$$reportNull$$$0(5);
        }
        if (psiElement == null) {
            PsiMethodUtil.$$$reportNull$$$0(6);
        }
        if ((mainMethodProvider = PsiMethodUtil.getApplicableMainMethodProvider(psiClass)) != null) {
            return mainMethodProvider.isMain(psiElement);
        }
        DumbService dumbService = DumbService.getInstance((Project)psiElement.getProject());
        try {
            return (Boolean)dumbService.computeWithAlternativeResolveEnabled(() -> {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
                if (psiMethod == null) {
                    return false;
                }
                return "main".equals(psiMethod.getName()) && PsiMethodUtil.isMainMethod(psiMethod);
            });
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @Nullable
    public static String getMainJVMClassName(@NotNull PsiClass psiClass) {
        JavaMainMethodProvider mainMethodProvider;
        if (psiClass == null) {
            PsiMethodUtil.$$$reportNull$$$0(7);
        }
        if ((mainMethodProvider = PsiMethodUtil.getApplicableMainMethodProvider(psiClass)) != null) {
            return mainMethodProvider.getMainClassName(psiClass);
        }
        return ClassUtil.getJVMClassName(psiClass);
    }

    @Nullable
    public static PsiMethod findMainInClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiMethodUtil.$$$reportNull$$$0(8);
        }
        if (!MAIN_CLASS.value((Object)aClass)) {
            return null;
        }
        return PsiMethodUtil.findMainMethod(aClass);
    }

    public static boolean hasMainInClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiMethodUtil.$$$reportNull$$$0(9);
        }
        if (!MAIN_CLASS.value((Object)aClass)) {
            return false;
        }
        return PsiMethodUtil.hasMainMethod(aClass);
    }

    @Nullable
    private static JavaMainMethodProvider getApplicableMainMethodProvider(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiMethodUtil.$$$reportNull$$$0(10);
        }
        DumbService dumbService = DumbService.getInstance((Project)aClass.getProject());
        List javaMainMethodProviders = dumbService.filterByDumbAwareness((Collection)JavaMainMethodProvider.EP_NAME.getExtensionList());
        return (JavaMainMethodProvider)ContainerUtil.find((Iterable)javaMainMethodProviders, provider -> provider.isApplicable(aClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PsiMethodUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDefaultNonPrivateConstructor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceMainMethodsEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inheritedStaticMainEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaLangStringArray";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isMainMethodWithProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMainJVMClassName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainInClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMainInClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplicableMainMethodProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

