/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.action;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.erd.DiagramCollectSettings;
import org.jkiss.dbeaver.model.erd.DiagramObjectCollector;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dnd.DatabaseObjectTransfer;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorAdapter;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.model.DiagramCollectSettingsDefault;
import org.jkiss.utils.CommonUtils;

public class ERDHandlerPaste
extends AbstractHandler {
    public boolean isEnabled() {
        Collection objects = DatabaseObjectTransfer.getFromClipboard();
        if (objects == null || CommonUtils.isEmpty((Collection)objects)) {
            return false;
        }
        for (DBPNamedObject object : objects) {
            if (!(object instanceof DBSTable) && !(object instanceof DBSObjectContainer)) continue;
            return true;
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Collection objects;
        ERDEditorPart editor;
        Control control = (Control)HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeFocusControl");
        if (control != null && (editor = ERDEditorAdapter.getEditor(control)) != null && !editor.isReadOnly() && !CommonUtils.isEmpty((Collection)(objects = (Collection)DatabaseObjectTransfer.getInstance().getObject()))) {
            try {
                UIUtils.runInProgressService(monitor -> {
                    List erdEntities = DiagramObjectCollector.generateEntityList((DBRProgressMonitor)monitor, (ERDDiagram)editor.getDiagram(), (DBPProject)editor.getDiagramProject(), (Collection)objects, (DiagramCollectSettings)new DiagramCollectSettingsDefault(), (boolean)true);
                    if (!CommonUtils.isEmpty((Collection)erdEntities)) {
                        UIUtils.syncExec(() -> {
                            Command command = editor.getDiagramPart().createEntityAddCommand(erdEntities, new Point(10, 10));
                            editor.getCommandStack().execute(command);
                        });
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Entity collect error", "Error during diagram entities collect", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }
}

