package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRetcodeShareUrl invokes the arms.GetRetcodeShareUrl API synchronously
func (client *Client) GetRetcodeShareUrl(request *GetRetcodeShareUrlRequest) (response *GetRetcodeShareUrlResponse, err error) {
	response = CreateGetRetcodeShareUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetRetcodeShareUrlWithChan invokes the arms.GetRetcodeShareUrl API asynchronously
func (client *Client) GetRetcodeShareUrlWithChan(request *GetRetcodeShareUrlRequest) (<-chan *GetRetcodeShareUrlResponse, <-chan error) {
	responseChan := make(chan *GetRetcodeShareUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRetcodeShareUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRetcodeShareUrlWithCallback invokes the arms.GetRetcodeShareUrl API asynchronously
func (client *Client) GetRetcodeShareUrlWithCallback(request *GetRetcodeShareUrlRequest, callback func(response *GetRetcodeShareUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRetcodeShareUrlResponse
		var err error
		defer close(result)
		response, err = client.GetRetcodeShareUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRetcodeShareUrlRequest is the request struct for api GetRetcodeShareUrl
type GetRetcodeShareUrlRequest struct {
	*requests.RpcRequest
	Pid string `position:"Query" name:"Pid"`
}

// GetRetcodeShareUrlResponse is the response struct for api GetRetcodeShareUrl
type GetRetcodeShareUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Url       string `json:"Url" xml:"Url"`
}

// CreateGetRetcodeShareUrlRequest creates a request to invoke GetRetcodeShareUrl API
func CreateGetRetcodeShareUrlRequest() (request *GetRetcodeShareUrlRequest) {
	request = &GetRetcodeShareUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetRetcodeShareUrl", "", "")
	request.Method = requests.POST
	return
}

// CreateGetRetcodeShareUrlResponse creates a response to parse from GetRetcodeShareUrl response
func CreateGetRetcodeShareUrlResponse() (response *GetRetcodeShareUrlResponse) {
	response = &GetRetcodeShareUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
