package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricConsortiumAdminStatus invokes the baas.DescribeFabricConsortiumAdminStatus API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumadminstatus.html
func (client *Client) DescribeFabricConsortiumAdminStatus(request *DescribeFabricConsortiumAdminStatusRequest) (response *DescribeFabricConsortiumAdminStatusResponse, err error) {
	response = CreateDescribeFabricConsortiumAdminStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricConsortiumAdminStatusWithChan invokes the baas.DescribeFabricConsortiumAdminStatus API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumadminstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumAdminStatusWithChan(request *DescribeFabricConsortiumAdminStatusRequest) (<-chan *DescribeFabricConsortiumAdminStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricConsortiumAdminStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricConsortiumAdminStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricConsortiumAdminStatusWithCallback invokes the baas.DescribeFabricConsortiumAdminStatus API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumadminstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumAdminStatusWithCallback(request *DescribeFabricConsortiumAdminStatusRequest, callback func(response *DescribeFabricConsortiumAdminStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricConsortiumAdminStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricConsortiumAdminStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricConsortiumAdminStatusRequest is the request struct for api DescribeFabricConsortiumAdminStatus
type DescribeFabricConsortiumAdminStatusRequest struct {
	*requests.RpcRequest
	Location string `position:"Body" name:"Location"`
}

// DescribeFabricConsortiumAdminStatusResponse is the response struct for api DescribeFabricConsortiumAdminStatus
type DescribeFabricConsortiumAdminStatusResponse struct {
	*responses.BaseResponse
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Success   bool                    `json:"Success" xml:"Success"`
	ErrorCode int                     `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ConsortimeAdminStatus `json:"Result" xml:"Result"`
}

// CreateDescribeFabricConsortiumAdminStatusRequest creates a request to invoke DescribeFabricConsortiumAdminStatus API
func CreateDescribeFabricConsortiumAdminStatusRequest() (request *DescribeFabricConsortiumAdminStatusRequest) {
	request = &DescribeFabricConsortiumAdminStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricConsortiumAdminStatus", "baas", "openAPI")
	return
}

// CreateDescribeFabricConsortiumAdminStatusResponse creates a response to parse from DescribeFabricConsortiumAdminStatus response
func CreateDescribeFabricConsortiumAdminStatusResponse() (response *DescribeFabricConsortiumAdminStatusResponse) {
	response = &DescribeFabricConsortiumAdminStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
