package chatbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Chat invokes the chatbot.Chat API synchronously
// api document: https://help.aliyun.com/api/chatbot/chat.html
func (client *Client) Chat(request *ChatRequest) (response *ChatResponse, err error) {
	response = CreateChatResponse()
	err = client.DoAction(request, response)
	return
}

// ChatWithChan invokes the chatbot.Chat API asynchronously
// api document: https://help.aliyun.com/api/chatbot/chat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChatWithChan(request *ChatRequest) (<-chan *ChatResponse, <-chan error) {
	responseChan := make(chan *ChatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Chat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChatWithCallback invokes the chatbot.Chat API asynchronously
// api document: https://help.aliyun.com/api/chatbot/chat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChatWithCallback(request *ChatRequest, callback func(response *ChatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChatResponse
		var err error
		defer close(result)
		response, err = client.Chat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChatRequest is the request struct for api Chat
type ChatRequest struct {
	*requests.RpcRequest
	KnowledgeId string    `position:"Query" name:"KnowledgeId"`
	SenderId    string    `position:"Query" name:"SenderId"`
	InstanceId  string    `position:"Query" name:"InstanceId"`
	SenderNick  string    `position:"Query" name:"SenderNick"`
	Perspective *[]string `position:"Query" name:"Perspective"  type:"Repeated"`
	SessionId   string    `position:"Query" name:"SessionId"`
	Tag         string    `position:"Query" name:"Tag"`
	Utterance   string    `position:"Query" name:"Utterance"`
}

// ChatResponse is the response struct for api Chat
type ChatResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	SessionId string    `json:"SessionId" xml:"SessionId"`
	MessageId string    `json:"MessageId" xml:"MessageId"`
	Tag       string    `json:"Tag" xml:"Tag"`
	Messages  []Message `json:"Messages" xml:"Messages"`
}

// CreateChatRequest creates a request to invoke Chat API
func CreateChatRequest() (request *ChatRequest) {
	request = &ChatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Chatbot", "2017-10-11", "Chat", "beebot", "openAPI")
	return
}

// CreateChatResponse creates a response to parse from Chat response
func CreateChatResponse() (response *ChatResponse) {
	response = &ChatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
